/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;

public class ViewMode {
    public static final int BINDING = 1;
    public static final int MESSAGE = 2;
    public static final int PORT_TYPE = 3;
    public static final int SERVICE = 4;
    public static final int TYPES = 5;
    public static final String BINDING_DESCRIPTION = WSDLEditorPlugin.getWSDLString("_UI_LABEL_BINDING");
    public static final String MESSAGE_DESCRIPTION = WSDLEditorPlugin.getWSDLString("_UI_LABEL_MESSAGE");
    public static final String PORT_TYPE_DESCRIPTION = WSDLEditorPlugin.getWSDLString("_UI_LABEL_PORTTYPE");
    public static final String SERVICE_DESCRIPTION = WSDLEditorPlugin.getWSDLString("_UI_LABEL_SERVICE");
    public static final String TYPES_DESCRIPTION = WSDLEditorPlugin.getWSDLString("_UI_LABEL_TYPES");
    protected boolean isBindingVisible = true;
    protected int mode = 4;
    protected List listenerList = new ArrayList();

    public void setBindingVisible(boolean isVisible) {
        if (this.isBindingVisible != isVisible) {
            this.isBindingVisible = isVisible;
            this.fireChangeNotification();
        }
    }

    public boolean isBindingVisible() {
        return this.isBindingVisible;
    }

    public static int getModeForDescription(String description) {
        int result = 4;
        if (description.equals(BINDING_DESCRIPTION)) {
            result = 1;
        } else if (description.equals(MESSAGE_DESCRIPTION)) {
            result = 2;
        } else if (description.equals(PORT_TYPE_DESCRIPTION)) {
            result = 3;
        } else if (description.equals(SERVICE_DESCRIPTION)) {
            result = 4;
        } else if (description.equals(TYPES_DESCRIPTION)) {
            result = 5;
        }
        return result;
    }

    public static String getDescriptionForMode(int mode) {
        String result = SERVICE_DESCRIPTION;
        switch (mode) {
            case 1: {
                result = BINDING_DESCRIPTION;
                break;
            }
            case 2: {
                result = MESSAGE_DESCRIPTION;
                break;
            }
            case 3: {
                result = PORT_TYPE_DESCRIPTION;
                break;
            }
            case 4: {
                result = SERVICE_DESCRIPTION;
                break;
            }
            case 5: {
                result = TYPES_DESCRIPTION;
            }
        }
        return result;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.fireChangeNotification();
    }

    public void setMode(String description) {
        this.mode = ViewMode.getModeForDescription(description);
        this.fireChangeNotification();
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeDescription() {
        return ViewMode.getDescriptionForMode(this.mode);
    }

    public void addListener(Listener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listenerList.remove(listener);
    }

    public void fireChangeNotification() {
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            Listener listener = (Listener)i.next();
            listener.viewModeChanged(this);
        }
    }

    public static interface Listener {
        public void viewModeChanged(ViewMode var1);
    }
}

