/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editparts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLComponentViewer;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.ContainerFigure;

public class DrillDownEditPart
extends AbstractGraphicalEditPart {
    protected Label drillDownButtonLabel;
    protected Label label;

    protected IFigure createFigure() {
        ContainerFigure figure = new ContainerFigure();
        this.drillDownButtonLabel = new Label();
        this.drillDownButtonLabel.setIcon(WSDLEditorPlugin.getInstance().getImage("icons/forward.gif"));
        figure.add((IFigure)this.drillDownButtonLabel);
        this.label = new Label();
        this.label.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_UNKNOWN"));
        boolean isLinux = File.separator.equals("/");
        if (!isLinux) {
            Font underlineFont = new Font((Device)Display.getCurrent(), "Tahoma", 8, 0);
            FontData oldData = underlineFont.getFontData()[0];
            FontData fontData = new FontData(oldData.getName(), oldData.getHeight(), 0);
            try {
                Object data = fontData.getClass().getField("data").get(fontData);
                System.out.println("data" + data.getClass());
                data.getClass().getField("lfUnderline").setByte(data, (byte)1);
                Font font = new Font((Device)Display.getCurrent(), fontData);
                this.label.setFont(font);
            }
            catch (Exception exception) {}
        }
        figure.add((IFigure)this.label);
        return figure;
    }

    protected void createEditPolicies() {
        DrillDownEditPartSelectionHandlesEditPolicy policy = new DrillDownEditPartSelectionHandlesEditPolicy();
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
    }

    public void performRequest(Request request) {
        LocationRequest locationRequest;
        Point p;
        if ((request.getType() == "direct edit" || request.getType() == "open") && request instanceof LocationRequest && (this.hitTest((IFigure)this.drillDownButtonLabel, p = (locationRequest = (LocationRequest)request).getLocation()) || this.hitTest((IFigure)this.label, p))) {
            this.performDrillDownAction();
        }
    }

    protected EditPart createChild(Object model) {
        return null;
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean hitTest(IFigure target, Point location) {
        Rectangle b = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)b);
        return b.contains(location);
    }

    protected void performDrillDownAction() {
        Runnable runnable = new Runnable(){

            public void run() {
                ((WSDLComponentViewer)DrillDownEditPart.this.getViewer()).setInput(DrillDownEditPart.this.getModel());
            }
        };
        Display.getCurrent().asyncExec(runnable);
    }

    private class DrillDownEditPartSelectionHandlesEditPolicy
    extends SelectionHandlesEditPolicy {
        DrillDownEditPartSelectionHandlesEditPolicy() {
        }

        protected List createSelectionHandles() {
            ArrayList<MoveHandle> list = new ArrayList<MoveHandle>();
            EditPart editPart = this.getHost();
            if (editPart instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                IFigure figure = graphicalEditPart.getFigure();
                MoveHandleLocator loc = new MoveHandleLocator(figure);
                MoveHandle moveHandle = new MoveHandle(graphicalEditPart, (Locator)loc);
                list.add(moveHandle);
            }
            return list;
        }
    }
}

