/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.DefinitionEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.GroupEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.TreeNodeEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editpolicies.WSDLDragAndDropEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.graph.editpolicies.WSDLGraphNodeDragTracker;
import org.eclipse.wst.wsdl.ui.internal.graph.editpolicies.WSDLSelectionHandlesEditPolicyImpl;
import org.eclipse.wst.wsdl.ui.internal.graph.figures.TreeNodeContentFigure;
import org.eclipse.wst.wsdl.ui.internal.graph.model.WSDLGraphModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;

public class WSDLTreeNodeEditPart
extends TreeNodeEditPart {
    protected Label label2;
    protected boolean isEmphasized = false;
    protected static final Color emphasisColor = new Color(null, 238, 238, 238);
    protected static final Color label2ForegroundColor = new Color(null, 82, 82, 158);
    protected static final Color label2ForegroundColorSelected = new Color(null, 182, 182, 255);
    WSDLSelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;

    protected ModelAdapter getModelAdapter(Object modelObject) {
        return WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory().getAdapter(modelObject);
    }

    protected void createContentFigure() {
        this.contentFigure = new TreeNodeContentFigure(){

            public IFigure getConnectionFigure() {
                return WSDLTreeNodeEditPart.this.isTopLevel() ? this.outlinedArea : this.iconArea;
            }
        };
    }

    protected boolean isTopLevel() {
        return this.getParent() instanceof GroupEditPart;
    }

    protected void createFigureContent() {
        super.createFigureContent();
        if (this.getModel() instanceof Part) {
            this.label2 = new Label();
            this.labelHolder.add((IFigure)this.label2);
            this.label2.setBorder((Border)new MarginBorder(0, 5, 0, 0));
            this.label2.setForegroundColor(label2ForegroundColor);
        }
    }

    public void setEmphasized(boolean isEmphasized) {
        this.isEmphasized = isEmphasized;
        this.refreshVisuals();
    }

    protected void updateEmphasis() {
        boolean isEmphasisShowing;
        boolean bl = isEmphasisShowing = this.isEmphasized && (!this.isSelected || this.getModelChildren().size() > 0);
        if (isEmphasisShowing) {
            this.contentFigure.getOutlinedArea().setBackgroundColor(emphasisColor);
        }
        this.contentFigure.getOutlinedArea().setFill(isEmphasisShowing);
        this.contentFigure.getOutlinedArea().setOutlined(isEmphasisShowing);
        this.contentFigure.setForegroundColor(elementBorderColor);
    }

    public void refreshVisuals() {
        this.updateEmphasis();
        super.refreshVisuals();
        if (this.label2 != null) {
            Part part = (Part)this.getModel();
            String value = ComponentReferenceUtil.getPartReferenceValue(part);
            this.label2.setText("(" + value + ")");
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            EditPart parent = this.getParent();
            while (parent != null) {
                if (parent instanceof DefinitionEditPart) {
                    ((DefinitionEditPart)parent).handleOpenRequest((EditPart)this);
                    break;
                }
                parent = parent.getParent();
            }
        }
    }

    public void addFeedback() {
        super.addFeedback();
        if (this.label2 != null) {
            this.label2.setForegroundColor(label2ForegroundColorSelected);
        }
        this.updateEmphasis();
    }

    public void removeFeedback() {
        super.removeFeedback();
        if (this.label2 != null) {
            this.label2.setForegroundColor(label2ForegroundColor);
        }
        this.updateEmphasis();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.selectionHandlesEditPolicy = new WSDLSelectionHandlesEditPolicyImpl();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new WSDLDragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }

    public IFigure getSelectionFigure() {
        return this.getFigure();
    }

    public DragTracker getDragTracker(Request request) {
        return new WSDLGraphNodeDragTracker((EditPart)this);
    }
}

