/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.figures;

import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.DefinitionEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.GroupEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.PartReferenceSectionEditPart;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IConnectedFigure;

public class MyConnectionRenderingHelper {
    protected boolean isOutlined = true;
    protected EditPartViewer viewer;
    static final int DOTTED_LINE_HEIGHT = 20;

    public MyConnectionRenderingHelper(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    public void fillShapeHelper(Graphics graphics) {
        this.drawLines(graphics, (EditPart)this.viewer.getRootEditPart());
    }

    protected Rectangle getConnectionBounds(IFigure figure) {
        Rectangle r = null;
        if (figure instanceof IConnectedFigure) {
            IConnectedFigure connectedFigure = (IConnectedFigure)figure;
            r = connectedFigure.getConnectionFigure().getBounds();
        } else {
            r = figure.getBounds();
        }
        return r;
    }

    protected int getClippedY(int y, Rectangle bounds) {
        if (bounds != null) {
            if (y < bounds.y) {
                y = bounds.y;
            }
            if (y > bounds.y + bounds.height) {
                y = bounds.y + bounds.height;
            }
        }
        return y;
    }

    protected void drawLine(Graphics graphics, IFigure a, IFigure b, int mx, Rectangle bounds) {
        Rectangle r1 = this.getConnectionBounds(a);
        Rectangle r2 = this.getConnectionBounds(b);
        int x1 = r1.x + r1.width;
        int y1 = r1.y + r1.height / 2;
        int x2 = r2.x - 1;
        int y2 = r2.y + r2.height / 2;
        int clippedY1 = this.getClippedY(y1, bounds);
        int clippedY2 = this.getClippedY(y2, bounds);
        graphics.setForegroundColor(ColorConstants.black);
        if (clippedY1 == y1 || clippedY2 == y2) {
            if (clippedY1 == y1) {
                graphics.drawLine(x1, y1, mx, y1);
            }
            if (clippedY2 == y2) {
                graphics.drawLine(mx, y2, x2 - 1, y2);
                graphics.drawLine(x2 - 1, y2, x2 - 4, y2 - 3);
                graphics.drawLine(x2 - 1, y2, x2 - 4, y2 + 3);
            }
            int lowClippedY = Math.min(clippedY1, clippedY2);
            int highClippedY = Math.max(clippedY1, clippedY2);
            int lowY = Math.min(y1, y2);
            int highY = Math.max(y1, y2);
            if (lowY == lowClippedY && highY == highClippedY) {
                graphics.drawLine(mx, lowClippedY, mx, highClippedY);
            } else {
                int dottedLineLength = Math.min(20, (highY - lowY) / 3);
                if (lowY != lowClippedY) {
                    graphics.setLineStyle(3);
                    int dottedY = lowClippedY + dottedLineLength;
                    graphics.drawLine(mx, lowClippedY, mx, dottedY);
                    graphics.setLineStyle(1);
                    graphics.drawLine(mx, dottedY, mx, highClippedY);
                } else {
                    graphics.setLineStyle(3);
                    int dottedY = highClippedY - dottedLineLength;
                    graphics.drawLine(mx, highClippedY, mx, dottedY);
                    graphics.setLineStyle(1);
                    graphics.drawLine(mx, dottedY, mx, lowClippedY);
                }
            }
        }
    }

    protected void drawLines(Graphics graphics, EditPart editPart) {
        if (editPart instanceof GroupEditPart) {
            GroupEditPart leftGroupEditPart = (GroupEditPart)editPart;
            GroupEditPart rightGroupEditPart = leftGroupEditPart.getNext();
            if (leftGroupEditPart != null && rightGroupEditPart != null && leftGroupEditPart.outputConnection != null && rightGroupEditPart.inputConnection != null) {
                int mx = rightGroupEditPart.getFigure().getBounds().x - 5;
                Rectangle l = leftGroupEditPart.outerPane.getBounds();
                Rectangle r = leftGroupEditPart.outerPane.getBounds();
                int ux1 = Math.min(l.x, r.x);
                int uy1 = Math.min(l.y, r.y);
                int ux2 = Math.max(l.x + l.width, r.x + r.width);
                int uy2 = Math.max(l.y + l.height, r.y + r.height);
                Rectangle bounds = new Rectangle(ux1, uy1, ux2 - ux1, uy2 - uy1);
                this.drawLine(graphics, leftGroupEditPart.outputConnection.getFigure(), rightGroupEditPart.inputConnection.getFigure(), mx, bounds);
            }
        } else if (editPart instanceof PartReferenceSectionEditPart) {
            DefinitionEditPart def;
            GroupEditPart groupEditPart;
            AbstractGraphicalEditPart child;
            AbstractGraphicalEditPart abstractGraphicalEditPart = child = editPart.getChildren().size() > 0 ? (AbstractGraphicalEditPart)editPart.getChildren().get(0) : null;
            if (child != null && (groupEditPart = (def = (DefinitionEditPart)editPart.getParent()).getGroupEditPart(2)) != null && groupEditPart.outputConnection != null) {
                int mx = child.getFigure().getBounds().x - 12;
                this.drawLine(graphics, groupEditPart.outputConnection.getFigure(), child.getFigure(), mx, null);
            }
        } else {
            Iterator i = editPart.getChildren().iterator();
            while (i.hasNext()) {
                EditPart child = (EditPart)i.next();
                this.drawLines(graphics, child);
            }
        }
    }
}

