/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.OperationType;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.UnknownExtensibilityElement;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.OperationImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLSwitch;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.extension.ITreeChildProvider;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLModelAdapterFactory
implements ModelAdapterFactory {
    protected static WSDLModelAdapterFactory wsdlModelAdapterFactoryInstance;
    public AdapterFactory adapterFactory = this.createAdapterFactory();

    protected boolean isExtensibilityElementConsideredChild() {
        return true;
    }

    protected void addExtensiblityElementChildren(List list, ExtensibleElement extensibleElement) {
        if (this.isExtensibilityElementConsideredChild()) {
            list.addAll(WSDLEditorUtil.getInstance().getExtensibilityElementNodes(extensibleElement));
        }
    }

    public static WSDLModelAdapterFactory getWSDLModelAdapterFactory() {
        if (wsdlModelAdapterFactoryInstance == null) {
            wsdlModelAdapterFactoryInstance = new WSDLModelAdapterFactory();
        }
        return wsdlModelAdapterFactoryInstance;
    }

    protected AdapterFactory createAdapterFactory() {
        return new WSDLAdapterFactoryImpl();
    }

    public ModelAdapter getAdapter(Object o) {
        ModelAdapter adapter = null;
        if (o instanceof WSDLElement) {
            adapter = (ModelAdapter)this.adapterFactory.adapt((Notifier)((WSDLElement)o), (Object)this.adapterFactory);
        } else if (o instanceof WSDLGroupObject) {
            adapter = (WSDLGroupObject)o;
        }
        return adapter;
    }

    public static void addModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = WSDLModelAdapterFactory.getWSDLModelAdapterFactory().getAdapter(modelObject);
        if (adapter != null) {
            adapter.addListener(listener);
        }
    }

    public static void removeModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = WSDLModelAdapterFactory.getWSDLModelAdapterFactory().getAdapter(modelObject);
        if (adapter != null) {
            adapter.removeListener(listener);
        }
    }

    public class WSDLAdapterFactoryImpl
    extends AdapterFactoryImpl {
        public Adapter createAdapter(Notifier target) {
            WSDLSwitch wsdlSwitch = new WSDLSwitch(this){
                final /* synthetic */ WSDLAdapterFactoryImpl this$1;
                {
                    this.this$1 = wSDLAdapterFactoryImpl;
                }

                public Object caseWSDLElement(WSDLElement wsdlElement) {
                    if (wsdlElement instanceof ExtensibilityElement) {
                        return this.this$1.createExtensibilityElementAdapter();
                    }
                    return this.this$1.createWSDLElementAdapter();
                }

                public Object caseBinding(Binding binding) {
                    return this.this$1.createBindingAdapter();
                }

                public Object caseBindingFault(BindingFault bindingFault) {
                    return this.this$1.createBindingFaultAdapter();
                }

                public Object caseBindingInput(BindingInput bindingInput) {
                    return this.this$1.createBindingInputAdapter();
                }

                public Object caseBindingOutput(BindingOutput bindingOutput) {
                    return this.this$1.createBindingOutputAdapter();
                }

                public Object caseBindingOperation(BindingOperation bindingOperation) {
                    return this.this$1.createBindingOperationAdapter();
                }

                public Object caseDefinition(Definition definition) {
                    return this.this$1.createDefinitionAdapter();
                }

                public Object caseFault(Fault fault) {
                    return this.this$1.createFaultAdapter();
                }

                public Object caseImport(Import i) {
                    return this.this$1.createImportAdapter();
                }

                public Object caseInput(Input input) {
                    return this.this$1.createInputAdapter();
                }

                public Object caseOutput(Output output) {
                    return this.this$1.createOutputAdapter();
                }

                public Object caseMessage(Message message) {
                    return this.this$1.createMessageAdapter();
                }

                public Object caseOperation(Operation operation) {
                    return this.this$1.createOperationAdapter();
                }

                public Object casePart(Part part) {
                    return this.this$1.createPartAdapter();
                }

                public Object casePort(Port port) {
                    return this.this$1.createPortAdapter();
                }

                public Object casePortType(PortType portType) {
                    return this.this$1.createPortTypeAdapter();
                }

                public Object caseService(Service service) {
                    return this.this$1.createServiceAdapter();
                }

                public Object caseTypes(Types types) {
                    return this.this$1.createTypesAdapter();
                }

                public Object defaultCase(EObject object) {
                    if (object instanceof ExtensibilityElement) {
                        return this.this$1.createExtensibilityElementAdapter();
                    }
                    return null;
                }
            };
            Object o = wsdlSwitch.doSwitch((EObject)target);
            Adapter result = null;
            if (o instanceof Adapter) {
                result = (Adapter)o;
            } else {
                System.out.println("did not create adapter for target : " + target);
                Thread.dumpStack();
            }
            return result;
        }

        public Adapter createWSDLElementAdapter() {
            return new WSDLElementAdapter();
        }

        public Adapter createBindingAdapter() {
            return new BindingAdapter();
        }

        public Adapter createBindingFaultAdapter() {
            return new BindingFaultAdapter();
        }

        public Adapter createBindingInputAdapter() {
            return new BindingInputAdapter();
        }

        public Adapter createBindingOutputAdapter() {
            return new BindingOutputAdapter();
        }

        public Adapter createBindingOperationAdapter() {
            return new BindingOperationAdapter();
        }

        public Adapter createDefinitionAdapter() {
            return new DefinitionAdapter();
        }

        public Adapter createFaultAdapter() {
            return new FaultAdapter();
        }

        public Adapter createImportAdapter() {
            return new ImportAdapter();
        }

        public Adapter createInputAdapter() {
            return new InputAdapter();
        }

        public Adapter createMessageAdapter() {
            return new MessageAdapter();
        }

        public Adapter createOperationAdapter() {
            return new OperationAdapter();
        }

        public Adapter createOutputAdapter() {
            return new OutputAdapter();
        }

        public Adapter createPartAdapter() {
            return new PartAdapter();
        }

        public Adapter createPortAdapter() {
            return new PortAdapter();
        }

        public Adapter createPortTypeAdapter() {
            return new PortTypeAdapter();
        }

        public Adapter createServiceAdapter() {
            return new ServiceAdapter();
        }

        public Adapter createTypesAdapter() {
            return new TypesAdapter();
        }

        public Adapter createExtensibilityElementAdapter() {
            return new ExtensibilityElementAdapter();
        }

        public Adapter adapt(Notifier target) {
            return this.adapt(target, (Object)this);
        }
    }

    protected class WSDLElementAdapter
    extends AdapterImpl
    implements ModelAdapter {
        protected List listenerList = new ArrayList();

        public boolean isAdapterForType(Object type) {
            return type == WSDLModelAdapterFactory.this.adapterFactory;
        }

        public void addListener(ModelAdapterListener listener) {
            if (!this.listenerList.contains(listener)) {
                this.listenerList.add(listener);
            }
        }

        public void removeListener(ModelAdapterListener listener) {
            if (this.listenerList.contains(listener)) {
                this.listenerList.remove(listener);
            }
        }

        public void firePropertyChanged(Object notifier, String property) {
            ArrayList list = new ArrayList();
            list.addAll(this.listenerList);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ModelAdapterListener listener = (ModelAdapterListener)i.next();
                listener.propertyChanged(this.getTarget(), property);
            }
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() != 9) {
                this.firePropertyChanged(msg.getNotifier(), null);
            }
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if (propertyName.equals("CHILDREN_PROPERTY")) {
                result = this.getChildren();
            } else if (propertyName.equals("LABEL_PROPERTY")) {
                result = this.getLabel();
            } else if (propertyName.equals("IMAGE_PROPERTY")) {
                result = this.getImage();
            } else if (propertyName.equals("extensibilityElements")) {
                if (modelObject instanceof ExtensibleElement) {
                    result = WSDLEditorUtil.getInstance().getExtensibilityElementNodes((ExtensibleElement)modelObject);
                }
            } else if (propertyName.equals("isReadOnly")) {
                Element element = WSDLEditorUtil.getInstance().getElementForObject(this.target);
                result = element instanceof IDOMNode ? Boolean.FALSE : Boolean.TRUE;
            }
            return result;
        }

        protected List getChildren() {
            return Collections.EMPTY_LIST;
        }

        protected String getLabel() {
            return "todo";
        }

        protected Image getImage() {
            return null;
        }
    }

    protected class BindingAdapter
    extends WSDLElementAdapter {
        protected Binding binding;

        protected BindingAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.binding = (Binding)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            WSDLModelAdapterFactory.this.addExtensiblityElementChildren(list, (ExtensibleElement)this.binding);
            EList operationsList = this.binding.getEBindingOperations();
            ArrayList tempList = new ArrayList();
            tempList.addAll(operationsList);
            Collections.sort(tempList, new Comparator(this){
                final /* synthetic */ BindingAdapter this$1;
                {
                    this.this$1 = bindingAdapter;
                }

                public int compare(Object o1, Object o2) {
                    String s1 = ((BindingOperation)o1).getName();
                    String s2 = ((BindingOperation)o2).getName();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    return s1.compareToIgnoreCase(s2);
                }
            });
            list.addAll(tempList);
            return list;
        }

        protected String getLabel() {
            return this.binding.getQName().getLocalPart();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/binding_obj.gif");
        }
    }

    protected class BindingFaultAdapter
    extends WSDLElementAdapter {
        protected BindingFault bindingFault;

        protected BindingFaultAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.bindingFault = (BindingFault)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            WSDLModelAdapterFactory.this.addExtensiblityElementChildren(list, (ExtensibleElement)this.bindingFault);
            return list;
        }

        protected String getLabel() {
            return this.bindingFault.getName();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/fault_obj.gif");
        }
    }

    protected class BindingInputAdapter
    extends WSDLElementAdapter {
        protected BindingInput bindingInput;

        protected BindingInputAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.bindingInput = (BindingInput)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            WSDLModelAdapterFactory.this.addExtensiblityElementChildren(list, (ExtensibleElement)this.bindingInput);
            return list;
        }

        protected String getLabel() {
            return "input";
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/input_obj.gif");
        }
    }

    protected class BindingOutputAdapter
    extends WSDLElementAdapter {
        protected BindingOutput bindingOutput;

        protected BindingOutputAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.bindingOutput = (BindingOutput)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            WSDLModelAdapterFactory.this.addExtensiblityElementChildren(list, (ExtensibleElement)this.bindingOutput);
            return list;
        }

        protected String getLabel() {
            return "output";
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/output_obj.gif");
        }
    }

    protected class BindingOperationAdapter
    extends WSDLElementAdapter {
        protected BindingOperation bindingOperation;

        protected BindingOperationAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.bindingOperation = (BindingOperation)newTarget;
        }

        protected List getChildren() {
            ArrayList<Object> list = new ArrayList<Object>();
            WSDLModelAdapterFactory.this.addExtensiblityElementChildren(list, (ExtensibleElement)this.bindingOperation);
            if (this.bindingOperation.getBindingInput() != null) {
                list.add(this.bindingOperation.getBindingInput());
            }
            if (this.bindingOperation.getBindingOutput() != null) {
                list.add(this.bindingOperation.getBindingOutput());
            }
            list.addAll((Collection<Object>)this.bindingOperation.getEBindingFaults());
            return list;
        }

        protected String getLabel() {
            return this.bindingOperation.getName();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/operationbinding_obj.gif");
        }
    }

    protected class DefinitionAdapter
    extends WSDLElementAdapter
    implements ModelAdapterListener {
        protected List permanentWSDLGroupObjectList;
        protected Definition definition;
        protected WSDLGroupObject typesGroup;
        protected WSDLGroupObject extensibilityElementsGroup;
        protected Types types;

        protected DefinitionAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.definition = (Definition)newTarget;
            this.typesGroup = new WSDLGroupObject(this.definition, 6, this.getModelAdapterFactory());
            this.permanentWSDLGroupObjectList = new ArrayList();
            this.permanentWSDLGroupObjectList.add(new WSDLGroupObject(this.definition, 1));
            this.permanentWSDLGroupObjectList.add(this.typesGroup);
            this.permanentWSDLGroupObjectList.add(new WSDLGroupObject(this.definition, 2));
            this.permanentWSDLGroupObjectList.add(new WSDLGroupObject(this.definition, 4));
            this.permanentWSDLGroupObjectList.add(new WSDLGroupObject(this.definition, 5));
            this.permanentWSDLGroupObjectList.add(new WSDLGroupObject(this.definition, 3));
            this.extensibilityElementsGroup = new WSDLGroupObject(this.definition, 7);
            this.updateTypes();
        }

        protected List getChildren() {
            ArrayList<WSDLGroupObject> list = new ArrayList<WSDLGroupObject>();
            list.addAll(this.permanentWSDLGroupObjectList);
            list.add(this.extensibilityElementsGroup);
            return list;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() != 9) {
                this.updateTypes();
                this.firePropertyChangedHelper();
            }
        }

        protected void updateTypes() {
            if (this.types != this.definition.getETypes()) {
                if (this.types != null) {
                    WSDLModelAdapterFactory.removeModelAdapterListener(this.types, this);
                }
                this.types = this.definition.getETypes();
                if (this.types != null) {
                    WSDLModelAdapterFactory.addModelAdapterListener(this.types, this);
                }
            }
        }

        protected void firePropertyChangedHelper() {
            this.firePropertyChanged(this.getTarget(), null);
            Iterator i = this.getChildren().iterator();
            while (i.hasNext()) {
                ModelAdapter adapter = WSDLModelAdapterFactory.this.getAdapter(i.next());
                adapter.firePropertyChanged(adapter, null);
            }
        }

        public void propertyChanged(Object object, String property) {
            this.typesGroup.firePropertyChanged(this.typesGroup, property);
        }

        protected ModelAdapterFactory getModelAdapterFactory() {
            return WSDLModelAdapterFactory.getWSDLModelAdapterFactory();
        }

        protected String getLabel() {
            if (this.definition.getQName() != null) {
                return this.definition.getQName().getLocalPart();
            }
            return "";
        }

        protected Image getImage() {
            return null;
        }
    }

    protected class FaultAdapter
    extends WSDLElementAdapter {
        protected Fault fault;

        protected FaultAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.fault = (Fault)newTarget;
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/fault_obj.gif");
        }

        protected String getLabel() {
            return this.fault.getName();
        }
    }

    protected class ImportAdapter
    extends WSDLElementAdapter {
        protected Import theImport;

        protected ImportAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.theImport = (Import)newTarget;
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/import_obj.gif");
        }

        protected String getLabel() {
            String result = this.theImport.getLocationURI();
            if (result == null || result.length() == 0) {
                result = WSDLEditorPlugin.getWSDLString("_UI_NO_IMPORT_SPECIFIED");
            }
            return result;
        }
    }

    protected class InputAdapter
    extends WSDLElementAdapter {
        protected Input input;

        protected InputAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.input = (Input)newTarget;
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/input_obj.gif");
        }

        protected String getLabel() {
            return "input";
        }
    }

    protected class MessageAdapter
    extends WSDLElementAdapter {
        protected Message message;

        protected MessageAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.message = (Message)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            list.addAll(this.message.getEParts());
            return list;
        }

        protected String getLabel() {
            if (this.message.getQName() == null) {
                return "";
            }
            return this.message.getQName().getLocalPart();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/message_obj.gif");
        }
    }

    protected class OutputAdapter
    extends WSDLElementAdapter {
        protected Output output;

        protected OutputAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.output = (Output)newTarget;
        }

        protected String getLabel() {
            return "output";
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/output_obj.gif");
        }
    }

    protected class OperationAdapter
    extends WSDLElementAdapter {
        protected Operation operation;

        protected OperationAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.operation = (Operation)newTarget;
        }

        protected List getChildren() {
            ArrayList<Object> list = new ArrayList<Object>();
            Input input = this.operation.getEInput();
            Output output = this.operation.getEOutput();
            OperationType operationType = ((OperationImpl)this.operation).getStyle();
            if (operationType != null) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE) && input != null && output != null) {
                    list.add(input);
                    list.add(output);
                } else if (operationType.equals(OperationType.SOLICIT_RESPONSE) && input != null && output != null) {
                    list.add(output);
                    list.add(input);
                } else if (operationType.equals(OperationType.ONE_WAY) && input != null) {
                    list.add(input);
                } else if (operationType.equals(OperationType.NOTIFICATION) && output != null) {
                    list.add(output);
                }
            }
            list.addAll(this.operation.getFaults().values());
            return list;
        }

        protected String getLabel() {
            return this.operation.getName();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/operation_obj.gif");
        }
    }

    protected class PartAdapter
    extends WSDLElementAdapter {
        protected Part part;

        protected PartAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.part = (Part)newTarget;
        }

        protected String getLabel() {
            return this.part.getName();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/part_obj.gif");
        }
    }

    protected class PortAdapter
    extends WSDLElementAdapter
    implements ModelAdapterListener {
        protected Port port;

        protected PortAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.port = (Port)newTarget;
        }

        protected String getLabel() {
            return this.port.getName();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/port_obj.gif");
        }

        protected List getChildren() {
            return WSDLEditorUtil.getInstance().getExtensibilityElementNodes((ExtensibleElement)this.port);
        }

        public void propertyChanged(Object object, String property) {
            this.firePropertyChanged(this.port, property);
        }
    }

    protected class ExtensibilityElementAdapter
    extends WSDLElementAdapter
    implements ModelAdapterListener {
        protected ExtensibilityElement ee;

        protected ExtensibilityElementAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.ee = (ExtensibilityElement)newTarget;
        }

        protected String getLabel() {
            String result = null;
            Element node = this.ee.getElement();
            ILabelProvider labelProvider = this.getExtensibilityLabelProvider(node);
            if (labelProvider != null) {
                result = labelProvider.getText((Object)node);
            }
            if (result == null) {
                result = node.getNodeName();
            }
            return result;
        }

        protected Image getImage() {
            Image image = null;
            Element node = this.ee.getElement();
            ILabelProvider labelProvider = this.getExtensibilityLabelProvider(node);
            if (labelProvider != null) {
                image = labelProvider.getImage((Object)node);
            }
            if (image == null) {
                image = WSDLEditorPlugin.getInstance().getImage("icons/element_obj.gif");
            }
            return image;
        }

        protected List getChildren() {
            EList list = null;
            if (this.ee instanceof UnknownExtensibilityElement) {
                list = ((UnknownExtensibilityElement)this.ee).getChildren();
            }
            return list;
        }

        public void propertyChanged(Object object, String property) {
            this.firePropertyChanged(this.ee, property);
        }

        protected ILabelProvider getExtensibilityLabelProvider(Node node) {
            ILabelProvider result = null;
            String namespaceURI = node.getNamespaceURI();
            if (namespaceURI != null) {
                result = WSDLEditorPlugin.getInstance().getExtensibilityItemTreeProviderRegistry().getLabelProvider(namespaceURI);
            }
            return result;
        }

        protected ITreeChildProvider getExtensibilityContentProvider(Node node) {
            ITreeChildProvider result = null;
            String namespaceURI = node.getNamespaceURI();
            if (namespaceURI != null) {
                result = WSDLEditorPlugin.getInstance().getExtensibilityItemTreeProviderRegistry().getContentProvider(namespaceURI);
            }
            return result;
        }

        boolean isReadOnly() {
            return true;
        }
    }

    protected class PortTypeAdapter
    extends WSDLElementAdapter {
        protected PortType portType;

        protected PortTypeAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.portType = (PortType)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            list.addAll(this.portType.getOperations());
            Collections.sort(list, new Comparator(this){
                final /* synthetic */ PortTypeAdapter this$1;
                {
                    this.this$1 = portTypeAdapter;
                }

                public int compare(Object o1, Object o2) {
                    String o1Name = ((Operation)o1).getName();
                    String o2Name = ((Operation)o2).getName();
                    if (o1Name == null) {
                        o1Name = "";
                    }
                    if (o2Name == null) {
                        o2Name = "";
                    }
                    return o1Name.compareToIgnoreCase(o2Name);
                }
            });
            return list;
        }

        protected String getLabel() {
            return this.portType.getQName().getLocalPart();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/porttype_obj.gif");
        }
    }

    protected class ServiceAdapter
    extends WSDLElementAdapter {
        protected Service service;

        protected ServiceAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.service = (Service)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            list.addAll(this.service.getEPorts());
            return list;
        }

        protected String getLabel() {
            return this.service.getQName().getLocalPart();
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/service_obj.gif");
        }
    }

    public class TypesAdapter
    extends WSDLElementAdapter {
        protected Types types;

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.types = (Types)newTarget;
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            list.addAll(WSDLEditorUtil.getInstance().getExtensibilityElementNodes((ExtensibleElement)this.types));
            return list;
        }

        protected String getLabel() {
            return "Types";
        }

        protected Image getImage() {
            return WSDLEditorPlugin.getInstance().getImage("icons/types_obj.gif");
        }
    }
}

