/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.parameters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddPartCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.wsdl.ui.internal.parameters.WNameHelperUtil;
import org.eclipse.wst.wsdl.ui.internal.parameters.XSDComponentHelper;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class AddBaseParameterCommand {
    public static int PART_ELEMENT_SEQ_ELEMENT = 0;
    public static int PART_ELEMENT = 1;
    public static int PART_COMPLEXTYPE_SEQ_ELEMENT = 2;
    public static int PART_COMPLEXTYPE = 3;
    protected int style = 0;
    protected Operation operation;
    protected XSDElementDeclaration newXSDElement;
    protected String newAnonymousXSDElementName;
    protected String newXSDElementName;
    protected String newWSDLMessageName;
    protected String newWSDLPartName;

    public abstract void run();

    public AddBaseParameterCommand(Operation operation, int style) {
        this.operation = operation;
        this.style = style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public XSDElementDeclaration getXSDElementDeclaration() {
        return this.newXSDElement;
    }

    protected boolean isPartElementReference() {
        return this.style == PART_ELEMENT || this.style == PART_ELEMENT_SEQ_ELEMENT;
    }

    protected XSDElementDeclaration createPartElementReferenceComponents(Part part) {
        Object returnedXSDElement = null;
        XSDElementDeclaration partElement = part.getElementDeclaration();
        if (this.style == PART_ELEMENT_SEQ_ELEMENT) {
            XSDElementDeclaration originalElement = null;
            XSDElementDeclaration anonXSDElement = null;
            if (partElement == null || partElement.getAnonymousTypeDefinition() == null) {
                anonXSDElement = XSDComponentHelper.createAnonymousXSDElementDefinition(this.getAnonymousXSDElementBaseName(), part);
                String prefixedName = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)anonXSDElement);
                ComponentReferenceUtil.setComponentReference(part, false, prefixedName);
                part.setTypeDefinition(null);
                if (partElement != null) {
                    originalElement = partElement;
                    partElement.getSchema().getContents().remove((Object)partElement);
                }
            } else {
                anonXSDElement = partElement;
            }
            XSDModelGroup modelGroup = XSDComponentHelper.getXSDModelGroup(anonXSDElement, part.getEnclosingDefinition());
            returnedXSDElement = XSDComponentHelper.createXSDElementDeclarationCommand(null, this.getNewXSDElementBaseName(), modelGroup);
            XSDComponentHelper.addXSDElementToModelGroup(anonXSDElement, (XSDElementDeclaration)returnedXSDElement);
            if (originalElement != null) {
                XSDComponentHelper.addXSDElementToModelGroup(anonXSDElement, originalElement);
            }
        } else if (this.style == PART_ELEMENT) {
            if (partElement == null) {
                returnedXSDElement = XSDComponentHelper.createXSDElementDeclarationCommand(part.getEnclosingDefinition(), this.getNewXSDElementBaseName(), part);
            }
            if (returnedXSDElement != null && !returnedXSDElement.equals(part.getElementDeclaration())) {
                String prefixedName = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)returnedXSDElement);
                ComponentReferenceUtil.setComponentReference(part, false, prefixedName);
            }
        }
        return returnedXSDElement;
    }

    protected XSDElementDeclaration createPartComplexTypeReference(Part part) {
        XSDElementDeclaration returnedXSDElement = null;
        if (this.style == PART_COMPLEXTYPE_SEQ_ELEMENT) {
            XSDTypeDefinition originalType = null;
            XSDComplexTypeDefinition topLevelType = null;
            if (part.getTypeDefinition() == null || part.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                XSDSchema schema = XSDComponentHelper.getXSDSchema(part.getEnclosingDefinition());
                String topLevelName = WNameHelperUtil.getXSDComplexTypeName(part.getName(), schema);
                topLevelType = XSDComponentHelper.createXSDComplexTypeDefiniion(topLevelName, part);
                if (part.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                    originalType = part.getTypeDefinition();
                }
            } else if (part.getTypeDefinition() instanceof XSDComplexTypeDefinition) {
                topLevelType = (XSDComplexTypeDefinition)part.getTypeDefinition();
            }
            XSDModelGroup modelGroup = XSDComponentHelper.getXSDModelGroup(topLevelType);
            returnedXSDElement = XSDComponentHelper.createXSDElementDeclarationCommand(null, this.getNewXSDElementBaseName(), modelGroup);
            if (originalType != null) {
                XSDElementDeclaration origXSDElement = XSDComponentHelper.createXSDElementDeclarationCommand(null, this.getNewXSDElementBaseName(), modelGroup);
                origXSDElement.setTypeDefinition(originalType);
            }
            String prefixedName = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)topLevelType);
            ComponentReferenceUtil.setComponentReference(part, true, prefixedName);
        } else if (this.style == PART_COMPLEXTYPE) {
            Object complexType = null;
            if (part.getTypeDefinition() == null) {
                XSDSchema schema = XSDComponentHelper.getXSDSchema(part.getEnclosingDefinition());
                String complexName = WNameHelperUtil.getXSDComplexTypeName(part.getName(), schema);
                complexType = XSDComponentHelper.createXSDComplexTypeDefiniion(complexName, part);
                XSDModelGroup xsdModelGroup = XSDComponentHelper.getXSDModelGroup((XSDComplexTypeDefinition)complexType);
                returnedXSDElement = XSDComponentHelper.createXSDElementDeclarationCommand(null, this.getNewXSDElementBaseName(), xsdModelGroup);
            }
            if (complexType != null && !complexType.equals(part.getTypeDefinition())) {
                String prefixedName = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)complexType);
                ComponentReferenceUtil.setComponentReference(part, true, prefixedName);
            }
        }
        return returnedXSDElement;
    }

    protected Part createWSDLComponents(MessageReference messageRef) {
        WSDLElementCommand command;
        Message message = messageRef.getEMessage();
        Part part = null;
        if (message == null) {
            command = new AddMessageCommand(messageRef.getEnclosingDefinition(), this.getWSDLMessageName());
            ((AddMessageCommand)command).run();
            message = (Message)((AddMessageCommand)command).getWSDLElement();
            messageRef.setEMessage(message);
        }
        if (message.getEParts().size() == 0) {
            command = new AddPartCommand(message, this.getWSDLPartName());
            ((AddPartCommand)command).run();
            part = (Part)((AddPartCommand)command).getWSDLElement();
        } else {
            part = (Part)message.getEParts().get(0);
        }
        return part;
    }

    protected XSDElementDeclaration createXSDObjects(Part part) {
        XSDElementDeclaration returnedXSDElement = null;
        returnedXSDElement = this.isPartElementReference() ? this.createPartElementReferenceComponents(part) : this.createPartComplexTypeReference(part);
        return returnedXSDElement;
    }

    private String getPrefixedComponentName(Definition definition, XSDNamedComponent component) {
        String name = component.getName();
        String tns = component.getTargetNamespace();
        List prefixes = this.getPrefixes(definition, tns);
        if (prefixes.size() > 0) {
            name = prefixes.get(0) + ":" + name;
        }
        return name;
    }

    private List getPrefixes(Definition definition, String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = definition.getNamespaces();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String theNamespace = (String)map.get(prefix);
            if (theNamespace == null || !theNamespace.equals(namespace)) continue;
            list.add(prefix);
        }
        return list;
    }

    protected abstract String getAnonymousXSDElementBaseName();

    protected abstract String getNewXSDElementBaseName();

    protected abstract String getWSDLMessageName();

    protected abstract String getWSDLPartName();
}

