/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.refactor.actions;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.ui.internal.refactor.actions.WSDLRefactorActionGroup;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactorActionGroup;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactorGroupActionDelegate;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactorGroupSubMenu;

public class WSDLRefactorGroupActionDelegate
extends RefactorGroupActionDelegate {
    protected void fillMenu(Menu menu) {
        if (this.fSelection == null) {
            return;
        }
        if (this.workbenchPart != null) {
            IEditorInput editorInput;
            IWorkbenchPartSite site = this.workbenchPart.getSite();
            if (site == null) {
                return;
            }
            IEditorPart editor = site.getPage().getActiveEditor();
            if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)editorInput;
                Definition definition = WSDLRefactorGroupActionDelegate.createDefinition(fileInput.getFile(), this.resourceSet);
                WSDLRefactorActionGroup refactorMenuGroup = new WSDLRefactorActionGroup(this.fSelection, definition);
                RefactorGroupSubMenu subMenu = new RefactorGroupSubMenu((RefactorActionGroup)refactorMenuGroup);
                subMenu.fill(menu, -1);
            }
        }
    }

    public static Definition createDefinition(IFile file, ResourceSet resourceSet) {
        URI uri = URI.createFileURI((String)file.getLocation().toString());
        Definition definition = WSDLFactory.eINSTANCE.createDefinition();
        try {
            definition.setDocumentBaseURI(uri.toString());
            IStructuredModel structuredModel = StructuredModelManager.getModelManager().getModelForRead(file);
            IDOMModel domModel = (IDOMModel)structuredModel;
            WSDLResourceFactoryImpl resourceFactory = new WSDLResourceFactoryImpl();
            Resource wsdlResource = resourceFactory.createResource(uri);
            wsdlResource.setURI(uri);
            if (resourceSet != null) {
                resourceSet.getResources().add((Object)wsdlResource);
            }
            definition.setElement(domModel.getDocument().getDocumentElement());
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        return definition;
    }
}

