/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.extension.INodeAssociationProvider;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtensionRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeAssociationManager {
    protected WSDLEditorExtension[] extensions;
    protected INodeAssociationProvider[] providers;

    public NodeAssociationManager() {
        WSDLEditorExtensionRegistry registry = WSDLEditorPlugin.getInstance().getWSDLEditorExtensionRegistry();
        this.extensions = registry.getRegisteredExtensions(8);
        this.providers = new INodeAssociationProvider[this.extensions.length];
        int i = 0;
        while (i < this.extensions.length) {
            this.providers[i] = (INodeAssociationProvider)this.extensions[i].createExtensionObject(8, null);
            ++i;
        }
    }

    protected INodeAssociationProvider getAppicableProvider(Object object) {
        INodeAssociationProvider provider = null;
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].isApplicable(object) && (provider = this.providers[i]) != null) break;
            ++i;
        }
        return provider;
    }

    public Object getModelObjectForNode(Object rootObject, Element targetNode) {
        int currentIndex = 0;
        Element[] elementChain = this.getParentElementChain(targetNode);
        INodeAssociationProvider p = this.getAppicableProvider(rootObject);
        if (p != null) {
            Node rootObjectNode = p.getNode(rootObject);
            while (currentIndex < elementChain.length) {
                Element e = elementChain[currentIndex];
                if (e == rootObjectNode) {
                    ++currentIndex;
                    break;
                }
                ++currentIndex;
            }
        }
        Object currentObject = rootObject;
        int[] end = new int[1];
        while (currentIndex < elementChain.length) {
            p = this.getAppicableProvider(currentObject);
            if (p == null) break;
            end[0] = elementChain.length;
            if ((currentObject = p.getModelObject(currentObject, elementChain, currentIndex, end)) == null) break;
            currentIndex = Math.max(end[0], currentIndex + 1);
        }
        return currentIndex == elementChain.length ? currentObject : null;
    }

    public Node getNode(Object modelObject) {
        Node result = null;
        if (modelObject instanceof Node) {
            result = (Node)modelObject;
        } else {
            INodeAssociationProvider p = this.getAppicableProvider(modelObject);
            if (p != null) {
                result = p.getNode(modelObject);
            }
        }
        return result;
    }

    protected Element[] getParentElementChain(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (element != null) {
            list.add(0, element);
            Node node = element.getParentNode();
            Element element2 = element = node != null && node.getNodeType() == 1 ? (Element)node : null;
        }
        int listSize = list.size();
        Element[] result = new Element[listSize];
        int i = 0;
        while (i < listSize) {
            result[i] = (Element)list.get(i);
            ++i;
        }
        return result;
    }
}

