/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util.flatui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.HyperlinkHandler;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.IHyperlinkListener;

public class WidgetFactory {
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BACKGROUND = "__bg";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";
    public static final String COLOR_HYPERLINK = "__hyperlink";
    private Hashtable colorRegistry = new Hashtable();
    private Color backgroundColor;
    private Color clientAreaColor;
    private Color foregroundColor;
    private Color fReadOnlyColor;
    private Display fDisplay = Display.getDefault();
    public static final int BORDER_STYLE = 0;
    private BorderPainter borderPainter;
    private Color borderColor;
    private HyperlinkHandler hyperlinkHandler;
    private static Image fBanner;

    public WidgetFactory() {
        this.initialize();
    }

    public Button createButton(Composite parent, String text, int style) {
        int flatStyle = 0x800000;
        Button button = new Button(parent, style | flatStyle);
        button.setBackground(this.backgroundColor);
        button.setForeground(this.foregroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setBackground(this.backgroundColor);
        return composite;
    }

    public Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        return composite;
    }

    public Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 32);
        group.setText(text);
        group.setBackground(this.backgroundColor);
        group.setForeground(this.foregroundColor);
        return group;
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg) {
        return this.createHeadingLabel(parent, text, bg, 0);
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener) {
        return this.createHyperlinkLabel(parent, text, listener, 0);
    }

    public Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener, int style) {
        Label label = this.createLabel(parent, text, style);
        this.turnIntoHyperlink((Control)label, listener);
        return label;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        return label;
    }

    public Label createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 2 | style);
        label.setBackground(this.backgroundColor);
        label.setForeground(this.borderColor);
        return label;
    }

    public ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledcomposite = new ScrolledComposite(parent, 768);
        scrolledcomposite.setBackground(this.backgroundColor);
        scrolledcomposite.setForeground(this.foregroundColor);
        return scrolledcomposite;
    }

    public Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        table.setBackground(this.backgroundColor);
        table.setForeground(this.foregroundColor);
        return table;
    }

    public Text createText(Composite parent, String value) {
        return this.createText(parent, value, 4);
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, style);
        text.setText(value);
        text.setBackground(this.clientAreaColor);
        text.setForeground(this.foregroundColor);
        if ((style & 8) != 0) {
            text.setForeground(this.fReadOnlyColor);
        }
        return text;
    }

    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setBackground(this.backgroundColor);
        tree.setForeground(this.foregroundColor);
        return tree;
    }

    public ViewForm createViewForm(Composite parent) {
        ViewForm viewForm = new ViewForm(parent, 0);
        viewForm.setBackground(this.clientAreaColor);
        viewForm.setForeground(this.foregroundColor);
        return viewForm;
    }

    public void dispose() {
        Enumeration colors = this.colorRegistry.elements();
        while (colors.hasMoreElements()) {
            Color c = (Color)colors.nextElement();
            c.dispose();
        }
        this.hyperlinkHandler.dispose();
        this.colorRegistry = null;
        if (fBanner != null) {
            fBanner.dispose();
            fBanner = null;
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Image getBanner() {
        if (fBanner == null) {
            try {
                fBanner = ImageDescriptor.createFromURL((URL)new URL(WSDLEditorPlugin.getInstance().getDescriptor().getInstallURL(), "icons\form_banner.gif")).createImage();
                System.out.println("Created Image!!!! ");
            }
            catch (MalformedURLException e) {
                System.out.println("Exception!!!! " + e);
            }
        }
        return fBanner;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Cursor getBusyCursor() {
        return this.hyperlinkHandler.getBusyCursor();
    }

    public Color getClientAreaColor() {
        return this.clientAreaColor;
    }

    public Color getColor(String key) {
        return (Color)this.colorRegistry.get(key);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getHyperlinkColor() {
        return this.hyperlinkHandler.getForeground();
    }

    public Cursor getHyperlinkCursor() {
        return this.hyperlinkHandler.getHyperlinkCursor();
    }

    public Color getHyperlinkHoverColor() {
        return this.hyperlinkHandler.getActiveForeground();
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkHandler.getHyperlinkUnderlineMode();
    }

    private void initStaticColors() {
        if (this.colorRegistry == null) {
            this.colorRegistry = new Hashtable();
            this.registerColor(COLOR_BACKGROUND, 255, 254, 249);
            this.registerColor(COLOR_BORDER, 195, 191, 179);
            this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
            this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
            this.registerColor(COLOR_HYPERLINK, 0, 0, 153);
        }
    }

    private void initialize() {
        this.clientAreaColor = this.fDisplay.getSystemColor(25);
        this.fReadOnlyColor = this.fDisplay.getSystemColor(16);
        this.initStaticColors();
        this.backgroundColor = this.clientAreaColor;
        this.borderColor = this.getColor(COLOR_BORDER);
        this.foregroundColor = this.fDisplay.getSystemColor(24);
        this.hyperlinkHandler = new HyperlinkHandler();
        this.hyperlinkHandler.setForeground(this.getColor(COLOR_HYPERLINK));
        this.hyperlinkHandler.setBackground(this.backgroundColor);
    }

    public void paintBordersFor(Composite parent) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.borderPainter);
    }

    public Color registerColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.fDisplay, r, g, b);
        this.colorRegistry.put(key, c);
        return c;
    }

    public void setClientAreaColor(Color color) {
        this.backgroundColor = this.clientAreaColor = color;
    }

    public void setHyperlinkColor(Color color) {
        this.hyperlinkHandler.setForeground(color);
    }

    public void setHyperlinkHoverColor(Color hoverColor) {
        this.hyperlinkHandler.setActiveForeground(hoverColor);
    }

    public void setHyperlinkUnderlineMode(int newHyperlinkUnderlineMode) {
        this.hyperlinkHandler.setHyperlinkUnderlineMode(newHyperlinkUnderlineMode);
    }

    public void turnIntoHyperlink(Control control, IHyperlinkListener listener) {
        this.hyperlinkHandler.registerHyperlink(control, listener);
    }

    class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                GC gc;
                Rectangle b;
                Control c = children[i];
                if (c instanceof Text || c instanceof Canvas || c instanceof CCombo) {
                    b = c.getBounds();
                    gc = event.gc;
                    gc.setForeground(c.getBackground());
                    gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                    gc.setForeground(WidgetFactory.this.foregroundColor);
                    gc.drawRectangle(b.x - 2, b.y - 2, b.width + 3, b.height + 3);
                } else if (c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                    b = c.getBounds();
                    gc = event.gc;
                    gc.setForeground(WidgetFactory.this.borderColor);
                    gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                }
                ++i;
            }
        }
    }
}

