/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.viewers.BaseViewer;
import org.eclipse.wst.wsdl.ui.internal.viewers.widgets.AttributesTable;
import org.w3c.dom.Element;

public class ExtensibilityElementViewer
extends BaseViewer
implements ModelAdapterListener {
    protected Composite control;
    protected IEditorPart editorPart;
    protected AttributesTable attributesTable;
    boolean isForTabbedProperties = false;

    public ExtensibilityElementViewer(Composite parent, IEditorPart editorPart) {
        super(ExtensibilityElementViewer.getStatusLineManager(editorPart));
        this.editorPart = editorPart;
        this.createControl(parent);
    }

    public ExtensibilityElementViewer(Composite parent, IEditorPart editorPart, boolean isForTabbedProperties) {
        super(ExtensibilityElementViewer.getStatusLineManager(editorPart));
        this.editorPart = editorPart;
        this.isForTabbedProperties = isForTabbedProperties;
        if (isForTabbedProperties) {
            this.createControlForTabbedPropertySheet(parent);
        } else {
            this.createControl(parent);
        }
    }

    protected String getHeadingText() {
        Element node;
        String result = "";
        if (this.input != null && ((result = (node = ((WSDLElement)this.input).getElement()).getNodeName()) == null || result.length() == 0)) {
            result = WSDLEditorPlugin.getWSDLString("_UI_LABEL_UNKNOWN_EXTENSIBILITY_ELEMENT");
        }
        return result;
    }

    public void doHandleEvent(Event event) {
    }

    public void createControlForTabbedPropertySheet(Composite parent) {
        this.attributesTable = new AttributesTable(this.editorPart, parent);
    }

    public void createControl(Composite parent) {
        this.control = this.flatViewUtility.createComposite(parent, 1, true);
        this.control.setBackground(new Color(null, 255, 0, 0));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.control.setLayoutData((Object)gd);
        GridLayout layout = (GridLayout)this.control.getLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.flatViewUtility.createFlatPageHeader(this.control, "");
        Composite c = this.flatViewUtility.createComposite(this.control, 1, true);
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessHorizontalSpace = true;
        cGD.verticalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        c.setLayoutData((Object)cGD);
        this.attributesTable = new AttributesTable(this.editorPart, c);
        GridData attributesTableGD = new GridData();
        attributesTableGD.horizontalAlignment = 4;
        attributesTableGD.grabExcessHorizontalSpace = true;
        attributesTableGD.verticalAlignment = 4;
        attributesTableGD.grabExcessVerticalSpace = true;
        this.attributesTable.getControl().setLayoutData((Object)attributesTableGD);
    }

    public Control getControl() {
        return this.control;
    }

    public void doSetInput(Object input) {
        if (!this.isForTabbedProperties) {
            this.flatViewUtility.updateFlatPageHeaderTitle(this.getHeadingText());
        }
        this.setListenerEnabled(false);
        this.attributesTable.setInput(((WSDLElement)input).getElement());
        this.setListenerEnabled(true);
        if (oldInput != null) {
            WSDLModelAdapterFactory.removeModelAdapterListener(oldInput, this);
        }
        WSDLModelAdapterFactory.addModelAdapterListener(input, this);
        oldInput = input;
    }

    public void propertyChanged(Object object, String property) {
        if (this.isListenerEnabled()) {
            this.setListenerEnabled(false);
            this.update();
            this.setListenerEnabled(true);
        }
    }

    protected void update() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!ExtensibilityElementViewer.this.attributesTable.getControl().isDisposed()) {
                    ExtensibilityElementViewer.this.attributesTable.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(runnable);
    }
}

