/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.xsd.XSDComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TabbedViewer
implements ISelectionChangedListener {
    protected WSDLEditor editor;
    protected CTabFolder tabFolder;
    protected Text documentationField;
    protected DocumentationListener documentationListener;
    protected boolean listenerEnabled;

    public TabbedViewer(WSDLEditor editor) {
        this.editor = editor;
    }

    public Control createControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0);
        CTabItem tab = new CTabItem(this.tabFolder, 0);
        tab.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_DOCUMENTION"));
        this.documentationField = new Text((Composite)this.tabFolder, 834);
        tab.setControl((Control)this.documentationField);
        this.tabFolder.setSelection(tab);
        this.documentationListener = new DocumentationListener();
        this.listenerEnabled = true;
        this.documentationField.addModifyListener((ModifyListener)this.documentationListener);
        this.editor.getSelectionManager().addSelectionChangedListener(this);
        return this.tabFolder;
    }

    public void setInput(Object object) {
        this.listenerEnabled = false;
        this.documentationListener.setInput(object);
        this.documentationField.setEnabled(true);
        this.documentationField.setText("");
        if (object instanceof XSDComponent || !(object instanceof WSDLElement)) {
            this.documentationField.setEnabled(false);
            this.listenerEnabled = true;
            return;
        }
        Element element = WSDLEditorUtil.getInstance().getElementForObject(object);
        if (element != null) {
            Node textNode;
            if (element.getLocalName().equals("documentation")) {
                this.documentationField.setEnabled(false);
                this.listenerEnabled = true;
                return;
            }
            Node docNode = this.getChildNode(element, element.getPrefix(), "documentation");
            if (docNode != null && (textNode = docNode.getFirstChild()) != null) {
                String textNodeValue = textNode.getNodeValue();
                this.documentationField.setText(textNodeValue != null ? textNodeValue : "");
            }
        }
        this.listenerEnabled = true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) != null) {
            this.setInput(o);
        }
    }

    public Node getChildNode(Element parent, String prefix, String childName) {
        NodeList list = null;
        if (parent != null) {
            list = parent.getChildNodes();
        }
        String targetName = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + childName : childName;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) instanceof Element && list.item(i).getNodeName().equals(targetName)) {
                    return list.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    class DocumentationListener
    implements ModifyListener {
        Object object;

        DocumentationListener() {
        }

        public void setInput(Object object) {
            this.object = object;
        }

        public void modifyText(ModifyEvent e) {
            Element element;
            if (TabbedViewer.this.listenerEnabled && (element = WSDLEditorUtil.getInstance().getElementForObject(this.object)) != null) {
                Node docNode = TabbedViewer.this.getChildNode(element, element.getPrefix(), "documentation");
                if (docNode != null) {
                    Node textNode = docNode.getFirstChild();
                    if (textNode != null) {
                        textNode.setNodeValue(TabbedViewer.this.documentationField.getText());
                    } else if (TabbedViewer.this.documentationField.getText() != null && TabbedViewer.this.documentationField.getText().length() > 0) {
                        Document document = docNode.getOwnerDocument();
                        org.w3c.dom.Text newTextNode = document.createTextNode(TabbedViewer.this.documentationField.getText());
                        docNode.appendChild(newTextNode);
                    }
                } else {
                    AddElementAction action = new AddElementAction(element, element.getPrefix(), "documentation", element.getFirstChild());
                    action.run();
                    Element newDocumentation = action.getNewElement();
                    Document document = newDocumentation.getOwnerDocument();
                    org.w3c.dom.Text newTextNode = document.createTextNode(TabbedViewer.this.documentationField.getText());
                    newDocumentation.appendChild(newTextNode);
                }
            }
        }
    }
}

