/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers.widgets;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.viewers.widgets.ExtensiblePropertySource;
import org.eclipse.wst.wsdl.ui.internal.viewers.widgets.ReadOnlyPropertySource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;

public class AttributesTable
extends TableViewer
implements ICellModifier {
    protected static final String PROPERTY = WSDLEditorPlugin.getWSDLString("_UI_LABEL_PROPERTY");
    protected static final String VALUE = WSDLEditorPlugin.getWSDLString("_UI_LABEL_VALUE");
    protected IEditorPart editorPart;
    protected String[] columnProperties = new String[]{PROPERTY, VALUE};
    protected PropertyTableProvider tableProvider = new PropertyTableProvider(this);
    protected CellEditor textCellEditor;
    protected IPropertySource propertySource;

    public AttributesTable(IEditorPart editorPart, Composite parent) {
        super(new Table(parent, 8454146));
        this.editorPart = editorPart;
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.setContentProvider((IContentProvider)this.tableProvider);
        this.setLabelProvider((IBaseLabelProvider)this.tableProvider);
        this.setColumnProperties(this.columnProperties);
        int i = 0;
        while (i < this.columnProperties.length) {
            TableColumn column = new TableColumn(this.getTable(), 0, i);
            column.setText(this.columnProperties[i]);
            column.setAlignment(16384);
            ++i;
        }
        TableLayout layout = new TableLayout();
        ColumnWeightData data = new ColumnWeightData(40, 40, true);
        layout.addColumnData((ColumnLayoutData)data);
        ColumnWeightData data2 = new ColumnWeightData(80, 80, true);
        layout.addColumnData((ColumnLayoutData)data2);
        this.getTable().setLayout((Layout)layout);
        this.textCellEditor = new TextCellEditor((Composite)this.getTable());
        this.resetCellEditors();
        this.setCellModifier(this);
    }

    protected void hookControl(Control control) {
        Table tableControl = (Table)control;
        tableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AttributesTable.this.updateCellEditors();
            }
        });
        super.hookControl(control);
    }

    public boolean canModify(Object element, String property) {
        return property.equals(VALUE);
    }

    public Object getValue(Object element, String property) {
        int column = 0;
        if (property.equals(this.columnProperties[0])) {
            column = 0;
        } else if (property.equals(this.columnProperties[1])) {
            column = 1;
        }
        return this.tableProvider.getColumnText(element, column);
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        IPropertyDescriptor propertyDescriptor = (IPropertyDescriptor)item.getData();
        Object oldValue = this.getValue(propertyDescriptor, property);
        if (value != null && !value.equals(oldValue)) {
            if (value instanceof String && ((String)value).length() == 0) {
                value = null;
            }
            this.propertySource.setPropertyValue(propertyDescriptor.getId(), value);
            this.refresh(item.getData());
        }
    }

    protected void updateCellEditors() {
        CellEditor[] cellEditors = new CellEditor[]{this.textCellEditor, this.textCellEditor};
        IPropertyDescriptor[] propertyDescriptors = this.propertySource.getPropertyDescriptors();
        int index = this.getTable().getSelectionIndex();
        if (index >= 0 && index < propertyDescriptors.length) {
            CellEditor oldCellEditor;
            CellEditor[] oldCellEditors = this.getCellEditors();
            CellEditor cellEditor = oldCellEditor = oldCellEditors.length > 1 ? oldCellEditors[1] : null;
            if (oldCellEditor != null && oldCellEditor != this.textCellEditor) {
                oldCellEditor.deactivate();
                oldCellEditor.dispose();
            }
            cellEditors[1] = propertyDescriptors[index].createPropertyEditor((Composite)this.getTable());
        }
        this.setCellEditors(cellEditors);
    }

    public String[] getStringArray(List list) {
        String[] result = new String[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)list.get(i);
            ++i;
        }
        return result;
    }

    protected void resetCellEditors() {
        CellEditor[] cellEditors = new CellEditor[]{this.textCellEditor, this.textCellEditor};
        this.setCellEditors(cellEditors);
    }

    class PropertyTableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        protected TableViewer viewer;

        PropertyTableProvider(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            AttributesTable.this.resetCellEditors();
            AttributesTable.this.propertySource = newInput instanceof IDOMElement ? new ExtensiblePropertySource(AttributesTable.this.editorPart, (INodeNotifier)((IDOMElement)newInput)) : (newInput instanceof Element ? new ReadOnlyPropertySource(AttributesTable.this.editorPart, (Element)newInput) : null);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object o, int columnIndex) {
            IPropertyDescriptor propertyDescriptor = (IPropertyDescriptor)o;
            return columnIndex == 0 ? propertyDescriptor.getId().toString() : AttributesTable.this.propertySource.getPropertyValue(propertyDescriptor.getId()).toString();
        }

        public Object[] getElements(Object o) {
            Object[] result = AttributesTable.this.propertySource.getPropertyDescriptors();
            if (result.length > 0) {
                Arrays.sort(result, new InternalComparator());
            }
            return result;
        }
    }

    class InternalComparator
    implements Comparator {
        InternalComparator() {
        }

        public int compare(Object e1, Object e2) {
            IPropertyDescriptor p1 = (IPropertyDescriptor)e1;
            IPropertyDescriptor p2 = (IPropertyDescriptor)e2;
            return Collator.getInstance().compare(p1.getDisplayName(), p2.getDisplayName());
        }
    }
}

