/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.wizards;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.ui.internal.UIPlugin;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.binding.http.internal.generator.HTTPContentGenerator;
import org.eclipse.wst.wsdl.binding.soap.internal.generator.SOAPContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLFactoryImpl;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFileOptionsPage;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFilePage;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.DOMValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.w3c.dom.Element;

public class NewWSDLWizard
extends Wizard
implements INewWizard {
    private WSDLNewFilePage newFilePage;
    private WSDLNewFileOptionsPage optionsPage;
    private IStructuredSelection selection;
    static /* synthetic */ Class class$0;

    public boolean performFinish() {
        IFile file = this.newFilePage.createNewFile();
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        if (charSet == null || charSet.trim().equals("")) {
            charSet = "UTF-8";
        }
        String wsdlPrefix = "wsdl";
        Vector namespaces = this.optionsPage.getNamespaceInfo();
        String prefix = this.optionsPage.getPrefix();
        String definitionName = this.optionsPage.getDefinitionName();
        URI uri2 = URI.createPlatformResourceURI((String)file.getFullPath().toOSString());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.createResource(URI.createURI((String)"*.wsdl"));
        resource.setURI(uri2);
        WSDLFactoryImpl factory = new WSDLFactoryImpl();
        DefinitionImpl definition = (DefinitionImpl)factory.createDefinition();
        resource.getContents().add((Object)definition);
        definition.setTargetNamespace(this.optionsPage.getTargetNamespace());
        definition.setLocation(file.getLocation().toString());
        definition.setEncoding(charSet);
        definition.setQName(new QName(wsdlPrefix, definitionName));
        definition.addNamespace(prefix, this.optionsPage.getTargetNamespace());
        int i = 0;
        while (i < namespaces.size()) {
            NamespaceInfo info = (NamespaceInfo)namespaces.get(i);
            if (info.prefix.length() > 0) {
                definition.addNamespace(info.prefix, info.uri);
            } else {
                definition.addNamespace(null, info.uri);
            }
            ++i;
        }
        definition.updateElement(true);
        try {
            if (this.optionsPage.getCreateSkeletonBoolean()) {
                CreateWSDLElementHelper.PART_TYPE_OR_DEFINITION = this.optionsPage.isSoapDocLiteralProtocol() ? "ELEMENT_DECLARATION" : "TYPE_DEFINITION";
                CreateWSDLElementHelper.serviceName = definitionName;
                CreateWSDLElementHelper.portName = String.valueOf(definitionName) + this.optionsPage.getProtocol();
                Service service = CreateWSDLElementHelper.createService((Definition)definition);
                Iterator bindingIt = definition.getEBindings().iterator();
                Binding binding = null;
                if (bindingIt.hasNext()) {
                    binding = (Binding)bindingIt.next();
                }
                BindingGenerator bindingGenerator = new BindingGenerator((Definition)definition, binding, "http://schemas.xmlsoap.org/wsdl/soap/");
                Port port = (Port)service.getEPorts().iterator().next();
                bindingGenerator.setName(ComponentReferenceUtil.getName(port.getEBinding()));
                bindingGenerator.setRefName(ComponentReferenceUtil.getPortTypeReference(port.getEBinding()));
                bindingGenerator.setOverwrite(true);
                if (this.optionsPage.getProtocol().equals("SOAP")) {
                    String namespace = "http://schemas.xmlsoap.org/wsdl/soap/";
                    bindingGenerator.setContentGenerator(BindingGenerator.getContentGenerator((String)namespace));
                    SOAPContentGenerator soapGen = (SOAPContentGenerator)bindingGenerator.getContentGenerator();
                    Boolean booleanValue = (Boolean)this.optionsPage.getProtocolOptions()[0];
                    Boolean booleanValue2 = (Boolean)this.optionsPage.getProtocolOptions()[2];
                    if (booleanValue.booleanValue()) {
                        soapGen.setStyle(1);
                        soapGen.setUse(1);
                    } else if (booleanValue2.booleanValue()) {
                        soapGen.setStyle(2);
                        soapGen.setUse(1);
                    } else {
                        soapGen.setStyle(2);
                        soapGen.setUse(2);
                    }
                } else if (this.optionsPage.getProtocol().equals("HTTP")) {
                    String namespace = "http://schemas.xmlsoap.org/wsdl/http/";
                    bindingGenerator.setContentGenerator(BindingGenerator.getContentGenerator((String)namespace));
                    Boolean booleanValue = (Boolean)this.optionsPage.getProtocolOptions()[0];
                    if (booleanValue.booleanValue()) {
                        ((HTTPContentGenerator)bindingGenerator.getContentGenerator()).setVerb(0);
                    } else {
                        ((HTTPContentGenerator)bindingGenerator.getContentGenerator()).setVerb(1);
                    }
                }
                bindingGenerator.generateBinding();
                bindingGenerator.generatePortContent();
            }
            resource.save(null);
        }
        catch (Exception e) {
            System.out.println("\nCould not write new WSDL file in WSDL Wizard: " + e);
        }
        NewWSDLWizard.openEditor(file);
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.ui.internal.WSDLEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/new_wsdl_wiz.gif"));
        this.setWindowTitle(WSDLEditorPlugin.getWSDLString("_UI_TITLE_NEW_WSDL_FILE"));
    }

    public void addPages() {
        this.newFilePage = new WSDLNewFilePage(this.selection);
        this.optionsPage = new WSDLNewFileOptionsPage(WSDLEditorPlugin.getWSDLString("_UI_TITLE_OPTIONS"), WSDLEditorPlugin.getWSDLString("_UI_TITLE_OPTIONS"), null);
        this.addPage((IWizardPage)this.newFilePage);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public IPath getNewFilePath() {
        String fileName = this.newFilePage.getFileName();
        return fileName != null ? new Path(fileName) : null;
    }

    public boolean canFinish() {
        return this.newFilePage.isPageComplete() && this.optionsPage.isPageComplete();
    }

    public static void openEditor(final IFile iFile) {
        if (iFile != null) {
            IWorkbench workbench = UIPlugin.getDefault().getWorkbench();
            final IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.wst.wsdl.ui.internal.WSDLEditor");
                    }
                    catch (PartInitException partInitException) {}
                }
            });
        }
    }

    public class AvailableContentCMVisitor
    extends CMVisitor {
        public static final int INCLUDE_ATTRIBUTES = 1;
        public static final int INCLUDE_CHILD_NODES = 2;
        public static final int INCLUDE_SEQUENCE_GROUPS = 4;
        public Hashtable childNodeTable = new Hashtable();
        public Hashtable attributeTable = new Hashtable();
        public Element rootElement;
        public CMElementDeclaration rootElementDeclaration;
        public boolean isRootVisited;
        protected boolean includeSequenceGroups;
        public DOMValidator validator;

        public AvailableContentCMVisitor(Element rootElement, CMElementDeclaration rootElementDeclaration) {
            this.rootElement = rootElement;
            this.rootElementDeclaration = rootElementDeclaration;
            this.validator = new DOMValidator();
        }

        protected String getKey(CMNode cmNode) {
            String namespaceURI;
            String key = cmNode.getNodeName();
            CMDocument cmDocument = (CMDocument)cmNode.getProperty("CMDocument");
            if (cmDocument != null && (namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) != null) {
                key = "[" + namespaceURI + "]" + key;
            }
            return key;
        }

        public List computeAvailableContent(int includeOptions) {
            Vector<Object> v = new Vector<Object>();
            int contentType = this.rootElementDeclaration.getContentType();
            this.includeSequenceGroups = (includeOptions & 4) != 0;
            this.visitCMNode((CMNode)this.rootElementDeclaration);
            if ((includeOptions & 1) != 0) {
                v.addAll(this.attributeTable.values());
                CMAttributeDeclaration nillableAttribute = (CMAttributeDeclaration)this.rootElementDeclaration.getProperty("http://org.eclipse.wst/cm/properties/nillable");
                if (nillableAttribute != null) {
                    v.add(nillableAttribute);
                }
            }
            if ((includeOptions & 2) != 0) {
                CMDataType dataType;
                CMDocument cmDocument;
                if (contentType == 3 || contentType == 2) {
                    v.addAll(this.childNodeTable.values());
                } else if (contentType == 0 && (cmDocument = (CMDocument)this.rootElementDeclaration.getProperty("CMDocument")) != null) {
                    CMNamedNodeMap elements = cmDocument.getElements();
                    Iterator i = elements.iterator();
                    while (i.hasNext()) {
                        v.add((CMElementDeclaration)i.next());
                    }
                }
                if ((contentType == 3 || contentType == 4 || contentType == 0) && (dataType = this.rootElementDeclaration.getDataType()) != null) {
                    v.add(dataType);
                }
            }
            return v;
        }

        public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
            super.visitCMAttributeDeclaration(ad);
            this.attributeTable.put(ad.getNodeName(), ad);
        }

        public void visitCMElementDeclaration(CMElementDeclaration ed) {
            if (ed == this.rootElementDeclaration && !this.isRootVisited) {
                this.isRootVisited = true;
                super.visitCMElementDeclaration(ed);
            } else {
                CMNodeList substitutionGroup;
                if (!Boolean.TRUE.equals(ed.getProperty("Abstract"))) {
                    this.childNodeTable.put(this.getKey((CMNode)ed), ed);
                }
                if ((substitutionGroup = (CMNodeList)ed.getProperty("SubstitutionGroup")) != null) {
                    this.handleSubstitutionGroup(substitutionGroup);
                }
            }
        }

        protected void handleSubstitutionGroup(CMNodeList substitutionGroup) {
            int substitutionGroupLength = substitutionGroup.getLength();
            if (substitutionGroupLength > 1) {
                int i = 0;
                while (i < substitutionGroupLength) {
                    CMNode ed = substitutionGroup.item(i);
                    if (!Boolean.TRUE.equals(ed.getProperty("Abstract"))) {
                        this.childNodeTable.put(this.getKey(ed), ed);
                    }
                    ++i;
                }
            }
        }

        public void visitCMGroup(CMGroup group) {
            if (this.includeSequenceGroups && group.getOperator() == 1 && group.getChildNodes().getLength() > 1 && this.includesRequiredContent(group)) {
                this.childNodeTable.put(group, group);
            }
            super.visitCMGroup(group);
        }

        public boolean includesRequiredContent(CMGroup group) {
            List list = this.getValidator().createContentSpecificationList((CMNode)group);
            return list.size() > 1;
        }

        public DOMValidator getValidator() {
            return this.validator;
        }
    }
}

