/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;

class WSDL11ValidatorPluginRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsdl.validation";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_NAMESPACE = "namespace";
    protected static final String ATT_RESOURCEBUNDLE = "resourcebundle";
    protected String extensionPointId;
    protected String tagName;

    public WSDL11ValidatorPluginRegistryReader(String extensionPointId, String tagName) {
        this.extensionPointId = extensionPointId;
        this.tagName = tagName;
    }

    public void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, this.extensionPointId);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(this.tagName)) {
            String validatorClass = element.getAttribute(ATT_CLASS);
            String namespace = element.getAttribute(ATT_NAMESPACE);
            String resourceBundle = element.getAttribute(ATT_RESOURCEBUNDLE);
            if (validatorClass != null && namespace != null) {
                try {
                    ClassLoader pluginLoader = element.getDeclaringExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
                    WSDL11ValidatorDelegate delegate = new WSDL11ValidatorDelegate(validatorClass, resourceBundle, pluginLoader);
                    WSDLValidator.getInstance().registerWSDL11Validator(namespace, delegate);
                }
                catch (Exception exception) {}
            }
        }
    }
}

