/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl20;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.wsdl20.IWSDL20Validator;

public class WSDL20ValidatorDelegate {
    private String validatorClassname = null;
    private String resourceBundle = null;
    private ClassLoader classLoader = null;
    private IWSDL20Validator validator = null;

    public WSDL20ValidatorDelegate(String validatorClassname, String resourceBundle) {
        this.validatorClassname = validatorClassname;
        this.resourceBundle = resourceBundle;
    }

    public WSDL20ValidatorDelegate(String validatorClassname, String resourceBundle, ClassLoader classLoader) {
        this(validatorClassname, resourceBundle);
        this.classLoader = classLoader;
    }

    public IWSDL20Validator getValidator() {
        if (this.validator == null) {
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<?> validatorClass = this.classLoader != null ? this.classLoader.loadClass(this.validatorClassname) : Class.forName(this.validatorClassname);
                this.validator = (IWSDL20Validator)validatorClass.newInstance();
                if (this.resourceBundle != null) {
                    ResourceBundle validatorBundle = ResourceBundle.getBundle(this.resourceBundle, Locale.getDefault(), this.classLoader);
                    this.validator.setResourceBundle(validatorBundle);
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            catch (InstantiationException e) {
                System.err.println(e);
            }
        }
        return this.validator;
    }
}

