/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.wizards;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.wsi.ui.internal.Messages;
import org.eclipse.wst.wsi.ui.internal.wizards.ValidationWizard;

public class ValidationWizardWSDLContentPage
extends WizardPage
implements SelectionListener {
    IStructuredSelection selection;
    public static final String PORT = "port";
    public static final String OPERATION = "operation";
    public static final String BINDING = "binding";
    public static final String PORTTYPE = "porttype";
    public static final String MESSAGE = "message";
    protected Button wsdlPortButton;
    protected Button wsdlBindingButton;
    protected Button wsdlPortTypeButton;
    protected Button wsdlOperationButton;
    protected Button wsdlMessageButton;
    protected Combo nameCombo;
    protected Text namespaceText;
    protected Text parentnameText;
    protected List ports = null;
    protected List operations = null;
    protected List bindings = null;
    protected List porttypes = null;
    protected List messages = null;

    public ValidationWizardWSDLContentPage(IStructuredSelection selection) {
        super("ValidationWizardWSDLContentPage");
        this.selection = selection;
        this.setTitle(Messages.WSDL_CONTENT_PAGE_SELECT_HEADING);
        this.setDescription(Messages.WSDL_CONTENT_PAGE_SELECT_EXPL);
    }

    public boolean isPageComplete() {
        if (((ValidationWizard)this.getWizard()).includeWSDLFile()) {
            int selection = this.nameCombo.getSelectionIndex();
            return selection != -1 && !this.nameCombo.getItem(selection).equals("");
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        Group wsdlElementGroup = new Group(base, 16);
        wsdlElementGroup.setText(Messages.WSDL_CONTENT_PAGE_GROUP_TEXT_ELEMENT);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        wsdlElementGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        wsdlElementGroup.setLayout((Layout)layout);
        Composite basePanel = new Composite((Composite)wsdlElementGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        basePanel.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        basePanel.setLayoutData((Object)data);
        this.createWSDLElementTypeContent(basePanel);
        this.createWSDLElementContent(basePanel);
        this.setControl((Control)base);
    }

    protected void createWSDLElementTypeContent(Composite parent) {
        Group wsdlTypeGroup = new Group(parent, 16);
        wsdlTypeGroup.setText(Messages.WSDL_CONTENT_PAGE_GROUP_TEXT_TYPE);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        wsdlTypeGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        wsdlTypeGroup.setLayout((Layout)layout);
        this.wsdlPortButton = new Button((Composite)wsdlTypeGroup, 16);
        this.wsdlPortButton.setText(Messages.WSDL_CONTENT_PAGE_RADIO_PORT);
        this.wsdlPortButton.setData((Object)"wsdlPortButton");
        this.wsdlPortButton.setSelection(true);
        this.wsdlPortButton.addSelectionListener((SelectionListener)new PortButtonSelectionListener());
        this.wsdlBindingButton = new Button((Composite)wsdlTypeGroup, 16);
        this.wsdlBindingButton.setData((Object)"wsdlBindingButton");
        this.wsdlBindingButton.setText(Messages.WSDL_CONTENT_PAGE_RADIO_BINDING);
        this.wsdlBindingButton.setSelection(false);
        this.wsdlBindingButton.addSelectionListener((SelectionListener)new BindingButtonSelectionListener());
        this.wsdlPortTypeButton = new Button((Composite)wsdlTypeGroup, 16);
        this.wsdlPortTypeButton.setData((Object)"wsdlPortTypeButton");
        this.wsdlPortTypeButton.setText(Messages.WSDL_CONTENT_PAGE_RADIO_PORT_TYPE);
        this.wsdlPortTypeButton.setSelection(false);
        this.wsdlPortTypeButton.addSelectionListener((SelectionListener)new PortTypeButtonSelectionListener());
        this.wsdlOperationButton = new Button((Composite)wsdlTypeGroup, 16);
        this.wsdlOperationButton.setData((Object)"wsdlOperationButton");
        this.wsdlOperationButton.setText(Messages.WSDL_CONTENT_PAGE_RADIO_OPERATION);
        this.wsdlOperationButton.setSelection(false);
        this.wsdlOperationButton.addSelectionListener((SelectionListener)new OperationButtonSelectionListener());
        this.wsdlMessageButton = new Button((Composite)wsdlTypeGroup, 16);
        this.wsdlMessageButton.setData((Object)"wsdlMessageButton");
        this.wsdlMessageButton.setText(Messages.WSDL_CONTENT_PAGE_RADIO_MESSAGE);
        this.wsdlMessageButton.setSelection(false);
        this.wsdlMessageButton.addSelectionListener((SelectionListener)new MessageButtonSelectionListener());
    }

    protected void createWSDLElementContent(Composite parent) {
        Composite fieldColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        fieldColumn.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        fieldColumn.setLayoutData((Object)data);
        Label label = new Label(fieldColumn, 16384);
        label.setText(Messages.WSDL_CONTENT_PAGE_LABEL_NAME);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.nameCombo = new Combo(fieldColumn, 8);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.nameCombo.setLayoutData((Object)data);
        this.nameCombo.addSelectionListener((SelectionListener)new NameSelectionListener());
        label = new Label(fieldColumn, 16384);
        label.setText(Messages.WSDL_CONTENT_PAGE_LABEL_NAMESPACE);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.namespaceText = new Text(fieldColumn, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 50;
        this.namespaceText.setLayoutData((Object)data);
        this.namespaceText.addModifyListener((ModifyListener)new TextBoxListener());
        this.namespaceText.setEditable(false);
        label = new Label(fieldColumn, 16384);
        label.setText(Messages.WSDL_CONTENT_PAGE_LABEL_PARENT);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.parentnameText = new Text(fieldColumn, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 50;
        this.parentnameText.setLayoutData((Object)data);
        this.parentnameText.addModifyListener((ModifyListener)new TextBoxListener());
        this.parentnameText.setEditable(false);
    }

    public boolean performFinish() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public String getElementName() {
        int selection = this.nameCombo.getSelectionIndex();
        if (selection != -1) {
            return this.nameCombo.getItem(selection);
        }
        return "";
    }

    public String getNamespace() {
        return this.namespaceText.getText();
    }

    public String getParentName() {
        return this.parentnameText.getText();
    }

    public String getType() {
        if (this.wsdlBindingButton.getSelection()) {
            return BINDING;
        }
        if (this.wsdlMessageButton.getSelection()) {
            return MESSAGE;
        }
        if (this.wsdlOperationButton.getSelection()) {
            return OPERATION;
        }
        if (this.wsdlPortButton.getSelection()) {
            return PORT;
        }
        if (this.wsdlPortTypeButton.getSelection()) {
            return PORTTYPE;
        }
        return null;
    }

    public void addElement(String type, String name, String namespace, String parent) {
        if (this.ports == null) {
            this.resetElements();
        }
        if (type.equals(PORT)) {
            this.ports.add(new WSDLElement(name, namespace, parent));
        } else if (type.equalsIgnoreCase(OPERATION)) {
            this.operations.add(new WSDLElement(name, namespace, parent));
        } else if (type.equalsIgnoreCase(BINDING)) {
            this.bindings.add(new WSDLElement(name, namespace, parent));
        } else if (type.equalsIgnoreCase(PORTTYPE)) {
            this.porttypes.add(new WSDLElement(name, namespace, parent));
        } else if (type.equalsIgnoreCase(MESSAGE)) {
            this.messages.add(new WSDLElement(name, namespace, parent));
        }
    }

    public void resetElements() {
        this.ports = new Vector();
        this.operations = new Vector();
        this.bindings = new Vector();
        this.porttypes = new Vector();
        this.messages = new Vector();
        this.nameCombo.clearSelection();
        this.nameCombo.removeAll();
    }

    public void setVisible(boolean visible) {
        this.resetElements();
        super.setVisible(visible);
        if (visible) {
            try {
                Collection messages;
                Map messagemap;
                Collection porttypes;
                Map porttypemap;
                Collection bindings;
                Map bindingmap;
                Collection servs;
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader reader = factory.newWSDLReader();
                Definition defElem = reader.readWSDL(((ValidationWizard)this.getWizard()).getWSDLFile());
                QName defQName = defElem.getQName();
                String defname = "";
                if (defQName != null) {
                    defname = defQName.getLocalPart();
                }
                String namespace = defElem.getTargetNamespace();
                Map servmap = defElem.getServices();
                if (servmap != null && (servs = servmap.values()) != null) {
                    Iterator servIter = servs.iterator();
                    while (servIter.hasNext()) {
                        Collection ports;
                        Service service = (Service)servIter.next();
                        String servname = service.getQName().getLocalPart();
                        Map portmap = service.getPorts();
                        if (portmap == null || (ports = portmap.values()) == null) continue;
                        Iterator portIter = ports.iterator();
                        while (portIter.hasNext()) {
                            Port port = (Port)portIter.next();
                            String name = port.getName();
                            this.addElement(PORT, name, namespace, servname);
                        }
                    }
                }
                if ((bindingmap = defElem.getBindings()) != null && (bindings = bindingmap.values()) != null) {
                    Iterator bindIter = bindings.iterator();
                    while (bindIter.hasNext()) {
                        Binding binding = (Binding)bindIter.next();
                        String name = binding.getQName().getLocalPart();
                        this.addElement(BINDING, name, namespace, defname);
                    }
                }
                if ((porttypemap = defElem.getPortTypes()) != null && (porttypes = porttypemap.values()) != null) {
                    Iterator porttypeIter = porttypes.iterator();
                    while (porttypeIter.hasNext()) {
                        PortType porttype = (PortType)porttypeIter.next();
                        String porttypename = porttype.getQName().getLocalPart();
                        this.addElement(PORTTYPE, porttypename, namespace, defname);
                        List operations = porttype.getOperations();
                        if (operations == null) continue;
                        Iterator operIter = operations.iterator();
                        while (operIter.hasNext()) {
                            Operation operation = (Operation)operIter.next();
                            String name = operation.getName();
                            this.addElement(OPERATION, name, namespace, porttypename);
                        }
                    }
                }
                if ((messagemap = defElem.getMessages()) != null && (messages = messagemap.values()) != null) {
                    Iterator messIter = messages.iterator();
                    while (messIter.hasNext()) {
                        Message message = (Message)messIter.next();
                        String name = message.getQName().getLocalPart();
                        this.addElement(MESSAGE, name, namespace, defname);
                    }
                }
                this.nameCombo.removeAll();
                this.namespaceText.setText("");
                this.parentnameText.setText("");
                int numElems = this.ports.size();
                WSDLElement[] elems = this.ports.toArray(new WSDLElement[numElems]);
                int i = 0;
                while (i < numElems) {
                    this.nameCombo.add(elems[i].getName(), i);
                    if (i == 0) {
                        this.nameCombo.select(0);
                        this.namespaceText.setText(elems[i].getNamespace());
                        this.parentnameText.setText(elems[i].getParentName());
                    }
                    ++i;
                }
                this.wsdlPortButton.setSelection(true);
                this.wsdlBindingButton.setSelection(false);
                this.wsdlMessageButton.setSelection(false);
                this.wsdlOperationButton.setSelection(false);
                this.wsdlPortTypeButton.setSelection(false);
            }
            catch (WSDLException wSDLException) {}
        } else {
            this.resetElements();
        }
    }

    class WorkspaceButtonListener
    implements SelectionListener {
        WorkspaceButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    }

    class BrowseButtonListener
    implements SelectionListener {
        BrowseButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    }

    class SearchUDDIButtonListener
    implements SelectionListener {
        SearchUDDIButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
        }
    }

    class TextBoxListener
    implements ModifyListener {
        TextBoxListener() {
        }

        public void modifyText(ModifyEvent e) {
            ValidationWizardWSDLContentPage.this.getContainer().updateButtons();
        }
    }

    private class WSDLElement {
        private String name;
        private String namespace;
        private String parent;

        public WSDLElement(String name, String namespace, String parent) {
            this.name = name;
            this.namespace = namespace;
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getParentName() {
            return this.parent;
        }
    }

    class PortButtonSelectionListener
    implements SelectionListener {
        PortButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ValidationWizardWSDLContentPage.this.nameCombo.removeAll();
            ValidationWizardWSDLContentPage.this.namespaceText.setText("");
            ValidationWizardWSDLContentPage.this.parentnameText.setText("");
            int numElems = ValidationWizardWSDLContentPage.this.ports.size();
            WSDLElement[] elems = ValidationWizardWSDLContentPage.this.ports.toArray(new WSDLElement[numElems]);
            int i = 0;
            while (i < numElems) {
                ValidationWizardWSDLContentPage.this.nameCombo.add(elems[i].getName(), i);
                if (i == 0) {
                    ValidationWizardWSDLContentPage.this.nameCombo.select(0);
                    ValidationWizardWSDLContentPage.this.namespaceText.setText(elems[i].getNamespace());
                    ValidationWizardWSDLContentPage.this.parentnameText.setText(elems[i].getParentName());
                }
                ++i;
            }
        }
    }

    class BindingButtonSelectionListener
    implements SelectionListener {
        BindingButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ValidationWizardWSDLContentPage.this.nameCombo.removeAll();
            ValidationWizardWSDLContentPage.this.namespaceText.setText("");
            ValidationWizardWSDLContentPage.this.parentnameText.setText("");
            int numElems = ValidationWizardWSDLContentPage.this.bindings.size();
            WSDLElement[] elems = ValidationWizardWSDLContentPage.this.bindings.toArray(new WSDLElement[numElems]);
            int i = 0;
            while (i < numElems) {
                ValidationWizardWSDLContentPage.this.nameCombo.add(elems[i].getName(), i);
                if (i == 0) {
                    ValidationWizardWSDLContentPage.this.nameCombo.select(0);
                    ValidationWizardWSDLContentPage.this.namespaceText.setText(elems[i].getNamespace());
                    ValidationWizardWSDLContentPage.this.parentnameText.setText(elems[i].getParentName());
                }
                ++i;
            }
        }
    }

    class PortTypeButtonSelectionListener
    implements SelectionListener {
        PortTypeButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ValidationWizardWSDLContentPage.this.nameCombo.removeAll();
            ValidationWizardWSDLContentPage.this.namespaceText.setText("");
            ValidationWizardWSDLContentPage.this.parentnameText.setText("");
            int numElems = ValidationWizardWSDLContentPage.this.porttypes.size();
            WSDLElement[] elems = ValidationWizardWSDLContentPage.this.porttypes.toArray(new WSDLElement[numElems]);
            int i = 0;
            while (i < numElems) {
                ValidationWizardWSDLContentPage.this.nameCombo.add(elems[i].getName(), i);
                if (i == 0) {
                    ValidationWizardWSDLContentPage.this.nameCombo.select(0);
                    ValidationWizardWSDLContentPage.this.namespaceText.setText(elems[i].getNamespace());
                    ValidationWizardWSDLContentPage.this.parentnameText.setText(elems[i].getParentName());
                }
                ++i;
            }
        }
    }

    class OperationButtonSelectionListener
    implements SelectionListener {
        OperationButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ValidationWizardWSDLContentPage.this.nameCombo.removeAll();
            ValidationWizardWSDLContentPage.this.namespaceText.setText("");
            ValidationWizardWSDLContentPage.this.parentnameText.setText("");
            int numElems = ValidationWizardWSDLContentPage.this.operations.size();
            WSDLElement[] elems = ValidationWizardWSDLContentPage.this.operations.toArray(new WSDLElement[numElems]);
            int i = 0;
            while (i < numElems) {
                ValidationWizardWSDLContentPage.this.nameCombo.add(elems[i].getName(), i);
                if (i == 0) {
                    ValidationWizardWSDLContentPage.this.nameCombo.select(0);
                    ValidationWizardWSDLContentPage.this.namespaceText.setText(elems[i].getNamespace());
                    ValidationWizardWSDLContentPage.this.parentnameText.setText(elems[i].getParentName());
                }
                ++i;
            }
        }
    }

    class MessageButtonSelectionListener
    implements SelectionListener {
        MessageButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ValidationWizardWSDLContentPage.this.nameCombo.removeAll();
            ValidationWizardWSDLContentPage.this.namespaceText.setText("");
            ValidationWizardWSDLContentPage.this.parentnameText.setText("");
            int numElems = ValidationWizardWSDLContentPage.this.messages.size();
            WSDLElement[] elems = ValidationWizardWSDLContentPage.this.messages.toArray(new WSDLElement[numElems]);
            int i = 0;
            while (i < numElems) {
                ValidationWizardWSDLContentPage.this.nameCombo.add(elems[i].getName(), i);
                if (i == 0) {
                    ValidationWizardWSDLContentPage.this.nameCombo.select(0);
                    ValidationWizardWSDLContentPage.this.namespaceText.setText(elems[i].getNamespace());
                    ValidationWizardWSDLContentPage.this.parentnameText.setText(elems[i].getParentName());
                }
                ++i;
            }
        }
    }

    class NameSelectionListener
    implements SelectionListener {
        NameSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selection = ((Combo)e.getSource()).getSelectionIndex();
            String type = ValidationWizardWSDLContentPage.this.getType();
            WSDLElement elem = null;
            if (type.equals(ValidationWizardWSDLContentPage.PORT)) {
                elem = (WSDLElement)ValidationWizardWSDLContentPage.this.ports.get(selection);
            } else if (type.equals(ValidationWizardWSDLContentPage.BINDING)) {
                elem = (WSDLElement)ValidationWizardWSDLContentPage.this.bindings.get(selection);
            } else if (type.equals(ValidationWizardWSDLContentPage.PORTTYPE)) {
                elem = (WSDLElement)ValidationWizardWSDLContentPage.this.porttypes.get(selection);
            } else if (type.equals(ValidationWizardWSDLContentPage.OPERATION)) {
                elem = (WSDLElement)ValidationWizardWSDLContentPage.this.operations.get(selection);
            } else if (type.equals(ValidationWizardWSDLContentPage.MESSAGE)) {
                elem = (WSDLElement)ValidationWizardWSDLContentPage.this.messages.get(selection);
            }
            if (elem != null) {
                ValidationWizardWSDLContentPage.this.namespaceText.setText(elem.getNamespace());
                ValidationWizardWSDLContentPage.this.parentnameText.setText(elem.getParentName());
            }
        }
    }
}

