/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.wsi.ui.internal.Messages;
import org.eclipse.wst.wsi.ui.internal.WSIUIPlugin;
import org.eclipse.wst.wsi.ui.internal.wizards.ValidationWizard;

public class ValidationWizardWSDLPage
extends WizardPage
implements SelectionListener {
    IStructuredSelection selection;
    protected boolean wsdlinvalid = false;
    protected Button includeWSDLButton;
    protected Group documentGroup;
    protected Text documentLocationText;
    protected Combo fileField;

    public ValidationWizardWSDLPage(IStructuredSelection selection) {
        super("ValidationWizardWSDLPage");
        this.selection = selection;
        this.setTitle(Messages.WSDL_PAGE_SELECT_WSDL_FILENAME_HEADING);
        this.setDescription(Messages.WSDL_PAGE_SELECT_WSDL_FILENAME_EXPL);
    }

    public boolean isPageComplete() {
        return !this.includeWSDLFile() || this.fileField.getText() != null && !this.fileField.getText().equals("") && !this.wsdlinvalid;
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        this.includeWSDLButton = new Button(base, 32);
        this.includeWSDLButton.setText(Messages.WSDL_PAGE_INCLUDE_WSDL_BUTTON);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.includeWSDLButton.setLayoutData((Object)data);
        this.includeWSDLButton.addSelectionListener((SelectionListener)this);
        this.includeWSDLButton.setSelection(false);
        this.documentGroup = new Group(base, 16);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.documentGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.documentGroup.setLayout((Layout)layout);
        this.documentGroup.setVisible(false);
        this.createDocumentGroupContents((Composite)this.documentGroup);
        this.setControl((Control)base);
    }

    protected Control createDocumentGroupContents(Composite documentGroup) {
        Composite basePanel = new Composite(documentGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        basePanel.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        basePanel.setLayoutData((Object)data);
        Composite group1 = new Composite(basePanel, 0);
        group1.setFont(this.getFont());
        layout = new GridLayout();
        layout.numColumns = 1;
        group1.setLayout((Layout)layout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        group1.setLayoutData((Object)data);
        Label documentLabel = new Label(group1, 16384);
        documentLabel.setText(Messages.WSDL_PAGE_INCLUDE_WSDL_LABEL);
        data = new GridData();
        data.horizontalAlignment = 4;
        documentLabel.setLayoutData((Object)data);
        this.fileField = new Combo(group1, 4);
        String[] wsdllocations = ((ValidationWizard)this.getWizard()).getWSDLLocations();
        if (wsdllocations != null) {
            int numlocs = wsdllocations.length;
            int i = 0;
            while (i < numlocs) {
                this.fileField.add(wsdllocations[i]);
                ++i;
            }
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 30;
        this.fileField.setLayoutData((Object)data);
        this.fileField.addModifyListener((ModifyListener)new FileFieldListener());
        Label wsdlLabel = new Label(group1, 16384);
        wsdlLabel.setText(Messages.WSDL_PAGE_VALID_WSDL_LABEL);
        data = new GridData();
        data.horizontalAlignment = 4;
        documentLabel.setLayoutData((Object)data);
        Composite group = new Composite(basePanel, 0);
        group.setFont(this.getFont());
        layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        Button workspaceButton = new Button(group, 8);
        workspaceButton.setText(Messages.WSDL_PAGE_WORKBENCH_BUTTON);
        data = new GridData();
        data.horizontalAlignment = 4;
        workspaceButton.setLayoutData((Object)data);
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonListener());
        Button browseButton = new Button(group, 8);
        browseButton.setText(Messages.WSDL_PAGE_BROWSE_BUTTON);
        data = new GridData();
        data.horizontalAlignment = 4;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new BrowseButtonListener());
        return documentGroup;
    }

    public boolean includeWSDLFile() {
        return this.includeWSDLButton.getSelection();
    }

    public String getWSDLFile() {
        return this.fileField.getText();
    }

    public boolean performFinish() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.includeWSDLButton) {
            if (this.includeWSDLButton.getSelection()) {
                this.documentGroup.setVisible(true);
            } else {
                this.documentGroup.setVisible(false);
            }
            this.getContainer().updateButtons();
        }
    }

    public void setWSDLInvalid() {
        this.wsdlinvalid = true;
    }

    class WorkspaceButtonListener
    implements SelectionListener {
        WorkspaceButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            IFile currentIFile;
            SelectSingleFileDialog dialog = new SelectSingleFileDialog(ValidationWizardWSDLPage.this.getShell(), ValidationWizardWSDLPage.this.selection, false);
            dialog.addFilterExtensions(new String[]{".wsdl"});
            dialog.create();
            dialog.getShell().setText(Messages.WSDL_PAGE_FILE_SHELL_TEXT);
            dialog.setTitle(Messages.WSDL_PAGE_FILE_TITLE);
            dialog.setMessage(Messages.WSDL_PAGE_FILE_DESCRIPTION);
            dialog.setTitleImage(WSIUIPlugin.getResourceImage("actions/icons/wsi_logfile_wiz.gif"));
            int result = dialog.open();
            if (result == 0 && (currentIFile = dialog.getFile()) != null) {
                ValidationWizardWSDLPage.this.fileField.add(currentIFile.getLocation().toString(), 0);
                ValidationWizardWSDLPage.this.fileField.select(0);
            }
        }
    }

    class BrowseButtonListener
    implements SelectionListener {
        BrowseButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(ValidationWizardWSDLPage.this.getShell());
            dialog.setFilterExtensions(new String[]{"*.wsdl"});
            String selection = dialog.open();
            if (selection != null) {
                ValidationWizardWSDLPage.this.fileField.add(selection, 0);
                ValidationWizardWSDLPage.this.fileField.select(0);
            }
        }
    }

    class FileFieldListener
    implements ModifyListener {
        FileFieldListener() {
        }

        public void modifyText(ModifyEvent e) {
            ValidationWizardWSDLPage.this.wsdlinvalid = false;
            ValidationWizardWSDLPage.this.getContainer().updateButtons();
        }
    }
}

