/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RefreshStructureJob
extends Job {
    static final boolean DEBUG;
    private static final long UPDATE_DELAY = 200L;
    private final List fRequests;
    List fViewers = new ArrayList(3);

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/outline");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public RefreshStructureJob() {
        super(XMLUIMessages.refreshoutline_0);
        this.setPriority(30);
        this.setSystem(true);
        this.fRequests = new ArrayList(1);
    }

    private synchronized void addRequest(Node node) {
        int size = this.fRequests.size();
        int i = 0;
        while (i < size) {
            if (this.contains((Node)this.fRequests.get(i), node)) {
                return;
            }
            ++i;
        }
        Iterator it = this.fRequests.iterator();
        while (it.hasNext()) {
            if (!this.contains(node, (Node)it.next())) continue;
            it.remove();
        }
        this.fRequests.add(node);
    }

    private synchronized void addViewer(StructuredViewer viewer) {
        if (!this.fViewers.contains(viewer)) {
            this.fViewers.add(viewer);
        }
    }

    private boolean contains(Node root, Node possible) {
        if (DEBUG) {
            System.out.println("==============================================================================================================");
            System.out.println("recursive call w/ root: " + root.getNodeName() + " and possible: " + possible);
            System.out.println("--------------------------------------------------------------------------------------------------------------");
        }
        if (root == null) {
            if (DEBUG) {
                System.out.println("returning false: root is null");
            }
            return false;
        }
        if (possible instanceof Document) {
            if (DEBUG) {
                System.out.println("returning false: possible is Document node");
            }
            return false;
        }
        if (root instanceof Document) {
            if (DEBUG) {
                System.out.println("returning true: root is Document node");
            }
            return true;
        }
        Node current = root;
        while (current != null) {
            if (DEBUG) {
                System.out.println("   -> iterating sibling (" + current.getNodeName() + ")");
            }
            if (possible.equals(current)) {
                if (DEBUG) {
                    System.out.println("   !!! found: " + possible.getNodeName() + " in subtree for: " + root.getNodeName());
                }
                return true;
            }
            if (current.getFirstChild() != null) {
                return this.contains(current.getFirstChild(), possible);
            }
            current = current.getNextSibling();
        }
        return false;
    }

    private void doRefresh(final Node node) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (DEBUG) {
                    System.out.println("refresh on: [" + node.getNodeName() + "]");
                }
                StructuredViewer[] viewers = RefreshStructureJob.this.fViewers.toArray(new StructuredViewer[0]);
                RefreshStructureJob.this.fViewers.clear();
                int i = 0;
                while (i < viewers.length) {
                    if (!viewers[i].getControl().isDisposed()) {
                        if (node instanceof Document) {
                            viewers[i].refresh();
                        } else {
                            viewers[i].refresh((Object)node, true);
                        }
                    } else if (DEBUG) {
                        System.out.println("   !!! skipped refreshing disposed viewer: " + viewers[i]);
                    }
                    ++i;
                }
            }
        });
    }

    private synchronized Node[] getRequests() {
        Node[] toRefresh = this.fRequests.toArray(new Node[this.fRequests.size()]);
        this.fRequests.clear();
        return toRefresh;
    }

    public void refresh(StructuredViewer viewer, Node node) {
        if (node == null) {
            return;
        }
        this.cancel();
        this.addRequest(node);
        this.addViewer(viewer);
        this.schedule(200L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            Node[] toRefresh = this.getRequests();
            int i = 0;
            while (i < toRefresh.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.doRefresh(toRefresh[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        return status;
    }
}

