/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class EncodingSettings
extends Composite {
    private static String ENCODING_LABEL = XMLUIMessages.EncodingSettings_1;
    private static String IANA_LABEL = XMLUIMessages.EncodingSettings_0;
    private ModifyListener comboListener = new ComboListener();
    protected Combo encodingCombo;
    protected Label encodingLabel;
    protected Label ianaLabel;
    protected Text ianaText;
    protected Vector ianaVector;

    public EncodingSettings(Composite parent) {
        super(parent, 0);
        this.init(IANA_LABEL, ENCODING_LABEL);
    }

    public EncodingSettings(Composite parent, String encodingLabel) {
        super(parent, 0);
        this.init(IANA_LABEL, encodingLabel);
    }

    public EncodingSettings(Composite parent, String ianaLabel, String encodingLabel) {
        super(parent, 0);
        this.init(ianaLabel, encodingLabel);
    }

    public void addEntry(String description, String ianaTag) {
        this.encodingCombo.add(description);
        this.ianaVector.add(ianaTag);
    }

    public void addEntry(String description, String ianaTag, int index) {
        if (index == this.ianaVector.size()) {
            this.addEntry(description, ianaTag);
            return;
        }
        if (index >= 0 && index < this.ianaVector.size()) {
            this.encodingCombo.add(description, index);
            this.ianaVector.add(index, ianaTag);
        }
    }

    protected Combo createComboBox(Composite parent, boolean isReadOnly) {
        int style = isReadOnly ? 8 : 4;
        Combo combo = new Combo(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent, int width) {
        Text text = new Text(parent, 12);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = width;
        text.setLayoutData((Object)data);
        return text;
    }

    public void dispose() {
        this.encodingCombo.removeModifyListener(this.comboListener);
        super.dispose();
    }

    private void fillCombo() {
        try {
            String[] ianaTags = CommonCharsetNames.getCommonCharsetNames();
            int totalNum = ianaTags.length;
            int i = 0;
            while (i < totalNum) {
                String iana = ianaTags[i];
                String enc = CommonCharsetNames.getDisplayString((String)iana);
                if (enc != null) {
                    this.encodingCombo.add(enc);
                } else {
                    Logger.log(2, "CommonCharsetNames.getDisplayString(" + iana + ") returned null");
                    this.encodingCombo.add(iana);
                }
                this.ianaVector.add(iana);
                ++i;
            }
        }
        catch (Exception e) {
            Logger.log(4, "Exception", e);
        }
    }

    public String getEncoding() {
        return this.encodingCombo.getText();
    }

    public Combo getEncodingCombo() {
        return this.encodingCombo;
    }

    public String getIANATag() {
        int i = this.encodingCombo.getSelectionIndex();
        if (i >= 0) {
            return (String)this.ianaVector.elementAt(i);
        }
        return "";
    }

    protected void init(String ianaLabelStr, String encodingLabelStr) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.setLayoutData(data);
        this.encodingLabel = this.createLabel(this, encodingLabelStr);
        this.encodingCombo = this.createComboBox(this, true);
        this.ianaLabel = this.createLabel(this, ianaLabelStr);
        this.ianaText = this.createTextField(this, 20);
        this.ianaVector = new Vector();
        this.fillCombo();
        this.resetToDefaultEncoding();
        this.encodingCombo.addModifyListener(this.comboListener);
    }

    public boolean isEncodingInList(String enc) {
        int i = this.encodingCombo.indexOf(enc);
        return i >= 0;
    }

    public boolean isIANATagInList(String ianaTag) {
        int i = this.ianaVector.indexOf(ianaTag);
        return i >= 0;
    }

    public void removeEntry(int index) {
        if (index >= 0 && index < this.ianaVector.size()) {
            this.encodingCombo.remove(index);
            this.ianaVector.remove(index);
        }
    }

    public void resetToDefaultEncoding() {
        String defaultIANATag = "UTF-8";
        this.ianaText.setText(defaultIANATag);
        this.setIANATag(defaultIANATag);
    }

    public void setEnabled(boolean enabled) {
        this.encodingCombo.setEnabled(enabled);
        this.encodingLabel.setEnabled(enabled);
        this.ianaLabel.setEnabled(enabled);
        this.ianaText.setEnabled(enabled);
    }

    public void setEncoding(String enc) {
        this.encodingCombo.setText(enc);
        this.encodingCombo.select(this.encodingCombo.indexOf(enc));
    }

    public void setIANATag(String ianaTag) {
        int i = this.ianaVector.indexOf(ianaTag);
        if (i >= 0) {
            this.encodingCombo.select(i);
        }
    }

    private class ComboListener
    implements ModifyListener {
        ComboListener() {
        }

        public void modifyText(ModifyEvent e) {
            int i = EncodingSettings.this.encodingCombo.getSelectionIndex();
            if (i >= 0 && i < EncodingSettings.this.ianaVector.size()) {
                EncodingSettings.this.ianaText.setText((String)EncodingSettings.this.ianaVector.elementAt(EncodingSettings.this.encodingCombo.getSelectionIndex()));
            }
        }
    }
}

