/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;

public class TreeExtension
implements PaintListener {
    protected Tree fTree;
    protected EditManager editManager;
    protected String[] fColumnProperties;
    protected ICellModifier cellModifier;
    protected int columnPosition = 300;
    protected int columnHitWidth = 5;
    protected Color tableLineColor;
    protected int controlWidth;
    protected DelayedDrawTimer delayedDrawTimer;
    private boolean fisUnsupportedInput = false;

    public TreeExtension(Tree tree) {
        this.fTree = tree;
        InternalMouseListener listener = new InternalMouseListener();
        tree.addMouseMoveListener((MouseMoveListener)listener);
        tree.addMouseListener((MouseListener)listener);
        tree.addPaintListener((PaintListener)this);
        this.editManager = new EditManager(tree);
        this.delayedDrawTimer = new DelayedDrawTimer((Control)tree);
        this.tableLineColor = tree.getDisplay().getSystemColor(19);
    }

    public void dispose() {
        this.tableLineColor.dispose();
    }

    public void setCellModifier(ICellModifier modifier) {
        this.cellModifier = modifier;
    }

    public void resetCachedData() {
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    public List getItemList() {
        Vector list = new Vector();
        this.getItemListHelper(this.fTree.getItems(), list);
        return list;
    }

    protected void getItemListHelper(TreeItem[] items, List list) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            list.add(item);
            this.getItemListHelper(item.getItems(), list);
            ++i;
        }
    }

    protected TreeItem getTreeItemOnRow(int px, int py) {
        TreeItem result = null;
        List list = this.getItemList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            TreeItem item = (TreeItem)i.next();
            Rectangle r = item.getBounds();
            if (r == null || px < r.x || py < r.y || py > r.y + r.height) continue;
            result = item;
        }
        return result;
    }

    public String[] getColumnProperties() {
        return this.fColumnProperties;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.fColumnProperties = columnProperties;
    }

    public void paintControl(PaintEvent event) {
        GC gc = event.gc;
        Rectangle treeBounds = this.fTree.getBounds();
        this.controlWidth = treeBounds.width;
        Color bg = this.fTree.getDisplay().getSystemColor(25);
        Color bg2 = this.fTree.getDisplay().getSystemColor(26);
        gc.setBackground(bg2);
        if (!this.fisUnsupportedInput) {
            TreeItem[] items = this.fTree.getItems();
            if (items.length > 0) {
                gc.setForeground(this.tableLineColor);
                gc.setBackground(bg);
                gc.fillRectangle(this.columnPosition, treeBounds.x, treeBounds.width, treeBounds.height);
                Rectangle itemBounds = items[0].getBounds();
                int height = this.computeTreeItemHeight();
                if (itemBounds != null) {
                    int startY;
                    int i = startY = itemBounds.y < treeBounds.y ? itemBounds.y : treeBounds.y + (treeBounds.y - itemBounds.y) % height;
                    while (i < treeBounds.height) {
                        if (i >= treeBounds.y) {
                            gc.drawLine(0, i, treeBounds.width, i);
                        }
                        i += height;
                    }
                }
                gc.drawLine(this.columnPosition, 0, this.columnPosition, treeBounds.height);
                this.paintItems(gc, items, treeBounds);
            } else {
                this.addEmptyTreeMessage(gc);
            }
        } else {
            this.addUnableToPopulateTreeMessage(gc);
        }
    }

    protected int computeTreeItemHeight() {
        int result = -1;
        result = result != -1 ? result : this.fTree.getItemHeight();
        return result;
    }

    protected void addEmptyTreeMessage(GC gc) {
    }

    private void addUnableToPopulateTreeMessage(GC gc) {
        gc.setForeground(this.fTree.getDisplay().getSystemColor(2));
        gc.setBackground(this.fTree.getDisplay().getSystemColor(25));
        gc.drawString(XMLEditorMessages.TreeExtension_0, 10, 10);
    }

    void setIsUnsupportedInput(boolean isUnsupported) {
        this.fisUnsupportedInput = isUnsupported;
    }

    public void paintItems(GC gc, TreeItem[] items, Rectangle treeBounds) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (item != null) {
                    Rectangle bounds = item.getBounds();
                    if (bounds != null && treeBounds.intersects(bounds)) {
                        this.paintItem(gc, item, bounds);
                    }
                    if (item.getExpanded()) {
                        this.paintItems(gc, item.getItems(), treeBounds);
                    }
                }
                ++i;
            }
        }
    }

    protected void paintItem(GC gc, TreeItem item, Rectangle bounds) {
    }

    Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    protected class InternalMouseListener
    extends MouseAdapter
    implements MouseMoveListener {
        protected int columnDragged = -1;
        protected boolean isDown = false;
        protected int prevX = -1;
        protected Cursor cursor = null;

        protected InternalMouseListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (e.x > TreeExtension.this.columnPosition - TreeExtension.this.columnHitWidth && e.x < TreeExtension.this.columnPosition + TreeExtension.this.columnHitWidth) {
                if (this.cursor == null) {
                    this.cursor = new Cursor((Device)TreeExtension.this.fTree.getDisplay(), 9);
                    TreeExtension.this.fTree.setCursor(this.cursor);
                }
            } else if (this.cursor != null) {
                TreeExtension.this.fTree.setCursor(null);
                this.cursor.dispose();
                this.cursor = null;
            }
            if (this.columnDragged != -1 && e.x > 20) {
                TreeExtension.this.columnPosition = e.x;
                TreeExtension.this.delayedDrawTimer.reset(20);
            }
        }

        public void mouseDown(MouseEvent e) {
            TreeItem item;
            this.columnDragged = -1;
            TreeExtension.this.editManager.deactivateCellEditor();
            if (e.x > TreeExtension.this.columnPosition - TreeExtension.this.columnHitWidth && e.x < TreeExtension.this.columnPosition + TreeExtension.this.columnHitWidth) {
                this.columnDragged = 0;
            }
            if ((item = TreeExtension.this.fTree.getItem(new Point(e.x, e.y))) == null && (item = TreeExtension.this.getTreeItemOnRow(e.x, e.y)) != null) {
                TreeItem[] items = new TreeItem[]{item};
                TreeExtension.this.fTree.setSelection(items);
            }
        }

        public void mouseUp(MouseEvent e) {
            this.columnDragged = -1;
        }
    }

    public static interface ICellEditorProvider {
        public CellEditor getCellEditor(Object var1, int var2);
    }

    public class DelayedDrawTimer
    implements Runnable {
        protected Control control;

        public DelayedDrawTimer(Control control1) {
            this.control = control1;
        }

        public void reset(int milliseconds) {
            TreeExtension.this.getDisplay().timerExec(milliseconds, (Runnable)this);
        }

        public void run() {
            this.control.redraw();
        }
    }

    public class EditManager {
        protected Tree fTree1;
        protected Control cellEditorHolder;
        protected CellEditorState cellEditorState;

        public EditManager(Tree tree) {
            ScrollBar vBar;
            this.fTree1 = tree;
            this.cellEditorHolder = new Composite((Composite)tree, 0);
            Tree theTree = tree;
            MouseAdapter theMouseAdapter = new MouseAdapter(this, theTree){
                final /* synthetic */ EditManager this$1;
                private final /* synthetic */ Tree val$theTree;
                {
                    this.this$1 = editManager;
                    this.val$theTree = tree;
                }

                public void mouseDown(MouseEvent e) {
                    Rectangle bounds;
                    TreeItem[] items;
                    this.this$1.deactivateCellEditor();
                    if (e.x > EditManager.access$0((EditManager)this.this$1).columnPosition + EditManager.access$0((EditManager)this.this$1).columnHitWidth && (items = this.val$theTree.getSelection()).length == 1 && (bounds = items[0].getBounds()) != null && e.y >= bounds.y && e.y <= bounds.y + bounds.height) {
                        int columnToEdit = 1;
                        this.this$1.activateCellEditor(items[0], columnToEdit);
                    }
                }
            };
            SelectionListener selectionListener = new SelectionListener(this){
                final /* synthetic */ EditManager this$1;
                {
                    this.this$1 = editManager;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.applyCellEditorValue();
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.applyCellEditorValue();
                }
            };
            KeyAdapter keyListener = new KeyAdapter(this, theTree){
                final /* synthetic */ EditManager this$1;
                private final /* synthetic */ Tree val$theTree;
                {
                    this.this$1 = editManager;
                    this.val$theTree = tree;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        this.this$1.deactivateCellEditor();
                        TreeItem[] items = this.val$theTree.getSelection();
                        if (items.length == 1) {
                            this.this$1.activateCellEditor(items[0], 1);
                        }
                    }
                }
            };
            tree.addMouseListener((MouseListener)theMouseAdapter);
            tree.addKeyListener((KeyListener)keyListener);
            ScrollBar hBar = tree.getHorizontalBar();
            if (hBar != null) {
                hBar.addSelectionListener(selectionListener);
            }
            if ((vBar = tree.getVerticalBar()) != null) {
                vBar.addSelectionListener(selectionListener);
            }
        }

        public boolean isCellEditorActive() {
            return this.cellEditorState != null;
        }

        public void applyCellEditorValue() {
            if (this.cellEditorState != null && TreeExtension.this.cellModifier != null) {
                TreeItem treeItem = this.cellEditorState.fTreeItem;
                Object value = this.cellEditorState.fCellEditor.getValue();
                String property = this.cellEditorState.fProperty;
                this.deactivateCellEditor();
                TreeExtension.this.cellModifier.modify((Object)treeItem, property, value);
            }
        }

        public void deactivateCellEditor() {
            if (this.cellEditorState != null) {
                this.cellEditorState.deactivate();
                this.cellEditorState = null;
            }
        }

        public void activateCellEditor(TreeItem treeItem, int column) {
            if (TreeExtension.this.cellModifier instanceof ICellEditorProvider) {
                Control control;
                CellEditor newCellEditor;
                String property;
                ICellEditorProvider cellEditorProvider = (ICellEditorProvider)TreeExtension.this.cellModifier;
                Object data = treeItem.getData();
                if (TreeExtension.this.fColumnProperties.length > column && TreeExtension.this.cellModifier.canModify(data, property = TreeExtension.this.fColumnProperties[column]) && (newCellEditor = cellEditorProvider.getCellEditor(data, column)) != null && (control = newCellEditor.getControl()) != null) {
                    this.cellEditorState = new CellEditorState(newCellEditor, control, treeItem, column, property);
                    this.cellEditorState.activate();
                }
            }
        }

        public class CellEditorState
        implements ICellEditorListener,
        FocusListener {
            public CellEditor fCellEditor;
            public Control fControl;
            public TreeItem fTreeItem;
            public int fColumnNumber;
            public String fProperty;

            public CellEditorState(CellEditor cellEditor, Control control, TreeItem treeItem, int columnNumber, String property) {
                this.fCellEditor = cellEditor;
                this.fControl = control;
                this.fTreeItem = treeItem;
                this.fColumnNumber = columnNumber;
                this.fProperty = property;
            }

            public void activate() {
                Rectangle r;
                Object element = this.fTreeItem.getData();
                String value = ((EditManager)EditManager.this).TreeExtension.this.cellModifier.getValue(element, this.fProperty).toString();
                if (this.fControl instanceof Text) {
                    Text text = (Text)this.fControl;
                    int requiredSize = value.length() + 100;
                    if (text.getTextLimit() < requiredSize) {
                        text.setTextLimit(requiredSize);
                    }
                }
                if ((r = this.fTreeItem.getBounds()) != null) {
                    this.fControl.setBounds(((EditManager)EditManager.this).TreeExtension.this.columnPosition + 5, r.y + 1, EditManager.this.fTree1.getClientArea().width - (((EditManager)EditManager.this).TreeExtension.this.columnPosition + 5), r.height - 1);
                    this.fControl.setVisible(true);
                    this.fCellEditor.setValue((Object)value);
                    this.fCellEditor.addListener((ICellEditorListener)this);
                    this.fCellEditor.setFocus();
                    this.fControl.addFocusListener((FocusListener)this);
                }
            }

            public void deactivate() {
                this.fCellEditor.removeListener((ICellEditorListener)this);
                this.fControl.removeFocusListener((FocusListener)this);
                this.fCellEditor.deactivate();
                EditManager.this.fTree1.forceFocus();
            }

            public void applyEditorValue() {
                EditManager.this.applyCellEditorValue();
            }

            public void cancelEditor() {
                EditManager.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                EditManager.this.applyCellEditorValue();
            }
        }
    }
}

