/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.validation.XMLMessageInfoHelper;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidationUIMessages;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidator;
import org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction;

public class ValidateAction
extends org.eclipse.wst.xml.ui.internal.validation.core.ValidateAction {
    private InputStream inputStream;

    public ValidateAction(IFile file, boolean showDialog) {
        super(file, showDialog);
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        if (this.inputStream != null) {
            XMLMessageInfoHelper messageInfoHelper = new XMLMessageInfoHelper();
            String[] messageInfo = messageInfoHelper.createMessageInfo(validationMessage.getKey(), validationMessage.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)messageInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)messageInfo[1]);
        }
    }

    protected void validate(final IFile file) {
        final XMLValidationOutcome valoutcome = new XMLValidationOutcome();
        IPath path = file.getLocation();
        final String uri = this.createURIForFilePath(path.toString());
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                XMLValidator validator = XMLValidator.getInstance();
                ValidateAction.this.clearMarkers(file);
                XMLValidationReport valreport = null;
                valreport = ValidateAction.this.inputStream != null ? validator.validate(uri, ValidateAction.this.inputStream) : validator.validate(uri);
                valoutcome.isValid = valreport.isValid();
                valoutcome.hasMessages = valreport.getValidationMessages().length != 0;
                valoutcome.isGrammarEncountered = valreport.isGrammarEncountered();
                ValidateAction.this.createMarkers(file, valreport.getValidationMessages());
                file.setSessionProperty(ValidationMessage.ERROR_MESSAGE_MAP_QUALIFIED_NAME, (Object)valreport.getNestedMessages());
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, null);
            if (this.showDialog) {
                if (!valoutcome.isValid) {
                    String title = XMLValidationUIMessages._UI_VALIDATION_FAILED;
                    String message = XMLValidationUIMessages._UI_THE_XML_FILE_IS_NOT_VALID;
                    this.openErrorDialog(title, message);
                } else if (valoutcome.hasMessages) {
                    String title = XMLValidationUIMessages._UI_VALIDATION_SUCEEDED;
                    String message = valoutcome.isGrammarEncountered ? XMLValidationUIMessages._UI_THE_XML_FILE_IS_VALID_WITH_WARNINGS : String.valueOf(XMLValidationUIMessages._UI_THE_XML_FILE_IS_WELL_FORMED_WITH_WARNINGS) + XMLValidationUIMessages._UI_NO_GRAMMAR_WARNING;
                    this.openWarningDialog(title, message);
                } else {
                    String title = XMLValidationUIMessages._UI_VALIDATION_SUCEEDED;
                    String message = valoutcome.isGrammarEncountered ? XMLValidationUIMessages._UI_THE_XML_FILE_IS_VALID : String.valueOf(XMLValidationUIMessages._UI_THE_XML_FILE_IS_WELL_FORMED) + XMLValidationUIMessages._UI_NO_GRAMMAR_WARNING;
                    this.openValidDialog(title, message);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected class XMLValidationOutcome
    extends ValidateAction.ValidationOutcome {
        public boolean isGrammarEncountered = false;

        protected XMLValidationOutcome() {
            super(ValidateAction.this);
        }
    }
}

