/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.validation.ValidateAction;

public class Validator
implements IValidator {
    private final String GET_FILE = "getFile";
    public final String GET_PROJECT_FILES = "getAllFiles";

    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void validate(IFile file) {
        ValidateAction validateAction = new ValidateAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    public void validate(IFile file, InputStream inputStream, IReporter reporter) {
        ValidateAction validateAction = new ValidateAction(file, false);
        validateAction.setValidator(this);
        if (inputStream != null) {
            validateAction.setInputStream(inputStream);
            validateAction.setReporter(reporter);
        }
        validateAction.run();
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] fileURIs = helper.getURIs();
        if (fileURIs != null && fileURIs.length > 0) {
            int i = 0;
            while (i < fileURIs.length) {
                Object[] parms;
                IFile file;
                String fileName = fileURIs[i];
                if (fileName != null && (file = (IFile)helper.loadModel("getFile", parms = new Object[]{fileName})) != null && Validator.shouldValidate(file)) {
                    if (helper.loadModel("inputStream") instanceof InputStream) {
                        this.validate(file, (InputStream)helper.loadModel("inputStream"), reporter);
                    } else {
                        this.validateIfNeeded(file, helper, reporter);
                    }
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getClass().getName()};
            Collection files = (Collection)helper.loadModel("getAllFiles", parms);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                this.validateIfNeeded(file, helper, reporter);
            }
        }
    }

    public void validate(IFile file, IReporter reporter, int ruleGroup) {
        ValidateAction validateAction = new ValidateAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    protected void validateIfNeeded(IFile file, IValidationContext helper, IReporter reporter) {
        LocalizedMessage message = new LocalizedMessage(4, NLS.bind((String)XMLUIMessages.MESSAGE_XML_VALIDATION_MESSAGE_UI_, (Object[])new String[]{file.getFullPath().toString()}));
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        Integer ruleGroupInt = (Integer)helper.loadModel("PASS_LEVEL", null);
        int ruleGroup = ruleGroupInt == null ? 3 : ruleGroupInt;
        this.validate(file, reporter, ruleGroup);
    }

    public void cleanup(IReporter reporter) {
    }

    class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }
    }
}

