/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.xsd.util.JAXPConfiguration;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DefaultJAXPConfiguration
implements JAXPConfiguration {
    public Transformer createTransformer(String encoding) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        return transformer;
    }

    public SAXParser createSAXParser(LexicalHandler lexicalHandler) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        return saxParser;
    }

    public DocumentBuilder createDocumentBuilder(ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
        parser.setEntityResolver(this.createEntityResolver());
        parser.setErrorHandler(errorHandler);
        return parser;
    }

    public EntityResolver createEntityResolver() {
        return XSDResourceImpl.createEntityResolver();
    }
}

