/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.content.provider.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.ui.services.helper.ViewerHelper;
import org.polarsys.capella.common.ui.toolkit.browser.BrowserActivator;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.IBrowserContentProvider;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.model.ISemanticBrowserModel;
import org.polarsys.capella.common.ui.toolkit.browser.query.QueryAdapter;
import org.polarsys.capella.common.ui.toolkit.provider.GroupedAdapterFactoryContentProvider;

public abstract class AbstractContentProvider
extends GroupedAdapterFactoryContentProvider
implements IBrowserContentProvider {
    protected EObject _rootElement;
    protected boolean _inputHasChanged;
    protected HashMap<BrowserElementWrapper, BrowserElementWrapper> _semanticParentHashMap;
    protected boolean refreshRequired = false;
    protected ISemanticBrowserModel model;

    public AbstractContentProvider(AdapterFactory adapterFactory, ISemanticBrowserModel model) {
        super(adapterFactory);
        this.model = model;
        this._semanticParentHashMap = new HashMap(0);
    }

    public void dispose() {
        this._semanticParentHashMap.clear();
        super.dispose();
    }

    protected void getCategoryChildren(ICategory category, BrowserElementWrapper wrapper, Set<Object> gatheredElements) {
        EObject elementToQuery = this.lookUpModelElement(wrapper);
        gatheredElements.addAll(category.compute(elementToQuery));
        gatheredElements.addAll(CategoryRegistry.getInstance().gatherSubCategories(this.getBrowserId(), elementToQuery, category));
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        try {
            if (parentElement instanceof BrowserElementWrapper) {
                BrowserElementWrapper wrapper = (BrowserElementWrapper)parentElement;
                Object element = ((BrowserElementWrapper)parentElement).getElement();
                HashSet<Object> gatheredElements = new HashSet<Object>(0);
                if (wrapper instanceof EObjectWrapper) {
                    if (element == this._rootElement && this._inputHasChanged) {
                        this._semanticParentHashMap.put(wrapper, null);
                        this._inputHasChanged = false;
                        if (this.getBrowserId().equalsIgnoreCase("CurrentElementBrowser")) {
                            return new Object[]{wrapper};
                        }
                    }
                    this.getElementChildren((EObject)element, wrapper, gatheredElements);
                } else if (wrapper instanceof CategoryWrapper) {
                    this.getCategoryChildren((ICategory)element, wrapper, gatheredElements);
                }
                HashSet<BrowserElementWrapper> wrappers = new HashSet<BrowserElementWrapper>(0);
                for (Object e : gatheredElements) {
                    if (e == null) continue;
                    BrowserElementWrapper elementWrapper = this.wrapElement(e);
                    wrappers.add(elementWrapper);
                    this._semanticParentHashMap.put(elementWrapper, wrapper);
                    boolean shouldRemovedEmptyCategoryWrapper = false;
                    if (e instanceof ICategory) {
                        if (!this.model.doesShowCategory((ICategory)e)) {
                            shouldRemovedEmptyCategoryWrapper = true;
                        } else {
                            HashSet<Object> categoryChildren = new HashSet<Object>(0);
                            this.getCategoryChildren((ICategory)e, elementWrapper, categoryChildren);
                            if (categoryChildren.isEmpty()) {
                                shouldRemovedEmptyCategoryWrapper = true;
                            }
                        }
                    }
                    if (!shouldRemovedEmptyCategoryWrapper) continue;
                    wrappers.remove(elementWrapper);
                    this._semanticParentHashMap.remove(elementWrapper);
                }
                result = wrappers.toArray();
            } else {
                result = this.getChildren(new EObjectWrapper(parentElement));
            }
        }
        catch (Exception exception) {
            BrowserActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.ui.toolkit.browser", "Error while getting children for " + parentElement, (Throwable)exception));
            result = new Object[]{};
        }
        return result;
    }

    protected void getElementChildren(EObject modelElement, BrowserElementWrapper wrapper, Set<Object> gatheredElements) {
        BrowserElementWrapper parentWrapper;
        Object semanticParent;
        BrowserElementWrapper semanticParentWrapper;
        if (modelElement != this._rootElement && (semanticParentWrapper = this._semanticParentHashMap.get(wrapper)) != null && (semanticParent = semanticParentWrapper.getElement()) instanceof ICategory) {
            for (Object query : ((ICategory)semanticParent).getItemQueries()) {
                gatheredElements.addAll(QueryAdapter.getInstance().compute(modelElement, query));
            }
        }
        if (this._semanticParentHashMap.get(parentWrapper = this._semanticParentHashMap.get(wrapper)) == null) {
            gatheredElements.addAll(CategoryRegistry.getInstance().gatherCategories(this.getBrowserId(), modelElement));
        }
    }

    public Object[] getElements(Object rootElement) {
        return this.getChildren(rootElement);
    }

    public Object getParent(Object element) {
        return this._semanticParentHashMap.get(element);
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer == null) {
            this.viewer = viewer;
        }
        if (newInput instanceof BrowserElementWrapper) {
            if (oldInput == null) {
                this.inputChanged(viewer, new EObjectWrapper(null), ((BrowserElementWrapper)newInput).getElement());
            } else if (oldInput instanceof BrowserElementWrapper) {
                this.inputChanged(viewer, ((BrowserElementWrapper)oldInput).getElement(), ((BrowserElementWrapper)newInput).getElement());
            } else if (oldInput instanceof EObject) {
                this.inputChanged(viewer, oldInput, ((BrowserElementWrapper)newInput).getElement());
            }
        } else if (newInput instanceof EObject) {
            this._semanticParentHashMap.clear();
            this._inputHasChanged = true;
            this._rootElement = (EObject)newInput;
        } else if (newInput == null) {
            this._inputHasChanged = false;
            this._rootElement = null;
            this._semanticParentHashMap.clear();
        }
    }

    private EObject lookUpModelElement(BrowserElementWrapper wrapper) {
        BrowserElementWrapper parentWrapper = this._semanticParentHashMap.get(wrapper);
        if (parentWrapper instanceof CategoryWrapper) {
            return this.lookUpModelElement(parentWrapper);
        }
        return (EObject)parentWrapper.getElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshRequired(ResourceSetChangeEvent event) {
        boolean result = false;
        AbstractContentProvider abstractContentProvider = this;
        synchronized (abstractContentProvider) {
            if (this.refreshRequired) {
                result = true;
            }
        }
        return result || super.refreshRequired(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanged(Notification notification) {
        if (notification instanceof IViewerNotification) {
            IViewerNotification viewerNotification = (IViewerNotification)notification;
            if (!viewerNotification.isContentRefresh()) {
                Object element = viewerNotification.getElement();
                BrowserElementWrapper wrappedElement = this.wrapElement(element);
                if (wrappedElement != null) {
                    super.notifyChanged(ViewerNotification.wrapNotification((Notification)viewerNotification, (Object)wrappedElement));
                }
            } else {
                AbstractContentProvider abstractContentProvider = this;
                synchronized (abstractContentProvider) {
                    if (!this.refreshRequired) {
                        this.refreshRequired = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRefresh() {
        boolean refresh = false;
        AbstractContentProvider abstractContentProvider = this;
        synchronized (abstractContentProvider) {
            refresh = this.refreshRequired;
            this.refreshRequired = false;
            if (this.refreshRequired) {
                this.notifications = null;
                this.toRefresh = null;
            }
        }
        if (!refresh) {
            super.processRefresh();
        } else if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            ViewerHelper.run((StructuredViewer)((StructuredViewer)this.viewer), (Runnable)new Runnable(){

                @Override
                public void run() {
                    Object input = AbstractContentProvider.this.viewer.getInput();
                    AbstractContentProvider.this.viewer.setInput(input);
                }
            });
        }
    }

    private BrowserElementWrapper wrapElement(Object gatherElement) {
        BrowserElementWrapper wrapper = null;
        if (gatherElement != null && gatherElement instanceof EObject) {
            wrapper = new EObjectWrapper(gatherElement);
        } else if (gatherElement instanceof ICategory) {
            wrapper = new CategoryWrapper(gatherElement);
        }
        return wrapper;
    }

    public EObject getRootElement() {
        return this._rootElement;
    }
}

