/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.la.ContextInterfaceRealization;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class InterfaceProcessorHelper {
    public static void addCommunicationLink(Component cpnt, List<CommunicationLink> communicationLinksToAdd, List<CommunicationLink> communicationLinksToRemove) {
        for (CommunicationLink communicationLink : communicationLinksToAdd) {
            if (communicationLinksToRemove.contains(communicationLink)) continue;
            ComponentExt.addCommunicationLink((Component)cpnt, (CommunicationLink)communicationLink);
        }
    }

    public static void addUseInterface(Component implementorCpnt, List<Interface> usedItf, List<Interface> unUsedItf) {
        for (Interface itf : usedItf) {
            if (unUsedItf.contains(itf)) continue;
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.addUsedInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.addUsedInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void addImplementationInterface(Component implementorCpnt, List<Interface> implementedItf, List<Interface> unImplementedItf) {
        for (Interface itf : implementedItf) {
            if (unImplementedItf.contains(itf)) continue;
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.addImplementedInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.addImplementedInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void addRequireInterface(Component implementorCpnt, List<Interface> requiredItf, List<Interface> unRequiredItf) {
        for (Interface itf : requiredItf) {
            if (unRequiredItf.contains(itf)) continue;
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.addRequiredInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.addRequiredInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void addProvideInterface(Component implementorCpnt, List<Interface> providedItf, List<Interface> unProvidedItf) {
        for (Interface itf : providedItf) {
            if (unProvidedItf.contains(itf)) continue;
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.addProvidedInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.addProvidedInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void removeCommunicationLink(Component cpnt, List<CommunicationLink> communicationLinksToRemove) {
        for (CommunicationLink communicationLink : communicationLinksToRemove) {
            ComponentExt.removeCommunicationLink((Component)cpnt, (CommunicationLink)communicationLink);
        }
    }

    public static void removeUseInterface(Component implementorCpnt, List<Interface> unUsedItf) {
        for (Interface itf : unUsedItf) {
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.removeUsedInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.removeUsedInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void removeImplementationInterface(Component implementorCpnt, List<Interface> unImplementedItf) {
        for (Interface itf : unImplementedItf) {
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.removeImplementedInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.removeImplementedInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void removeRequireInterface(Component implementorCpnt, List<Interface> unRequiredItf) {
        for (Interface itf : unRequiredItf) {
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.removeRequiredInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.removeRequiredInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static void removeProvideInterface(Component implementorCpnt, List<Interface> unProvidedItf) {
        for (Interface itf : unProvidedItf) {
            Interface itfTransf = InterfaceProcessorHelper.retrieveTransformedInterface(itf);
            if (itfTransf != null) {
                ComponentExt.removeProvidedInterface((Component)implementorCpnt, (Interface)itfTransf);
                continue;
            }
            ComponentExt.removeProvidedInterface((Component)implementorCpnt, (Interface)itf);
        }
    }

    public static List<CommunicationLink> computeCommunicationLinksToAdd(Component implementorCpnt) {
        ArrayList<CommunicationLink> communicationLinks = new ArrayList<CommunicationLink>();
        for (Component implementedCpnt : implementorCpnt.getAllocatedComponents()) {
            for (CommunicationLink communicationLink : implementedCpnt.getOwnedCommunicationLinks()) {
                if (communicationLinks.contains(communicationLink)) continue;
                communicationLinks.add(communicationLink);
            }
        }
        return communicationLinks;
    }

    public static List<Interface> computeUsageToAdd(Component implementorCpnt) {
        ArrayList<Interface> usedInterfaces = new ArrayList<Interface>();
        for (Component implementedCpnt : implementorCpnt.getAllocatedComponents()) {
            for (Interface itf : ComponentExt.getUsedInterfaces((Component)implementedCpnt)) {
                if (usedInterfaces.contains(itf)) continue;
                usedInterfaces.add(itf);
            }
        }
        return usedInterfaces;
    }

    public static List<Interface> computeImplementationToAdd(Component implementorCpnt) {
        ArrayList<Interface> implementedInterfaces = new ArrayList<Interface>();
        for (Component implementedCpnt : implementorCpnt.getAllocatedComponents()) {
            for (Interface itf : ComponentExt.getImplementedInterfaces((Component)implementedCpnt)) {
                if (implementedInterfaces.contains(itf)) continue;
                implementedInterfaces.add(itf);
            }
        }
        return implementedInterfaces;
    }

    public static List<Interface> computeRequireToAdd(Component implementorCpnt) {
        ArrayList<Interface> requiredItf = new ArrayList<Interface>();
        for (Component implementedCpnt : implementorCpnt.getAllocatedComponents()) {
            for (Interface itf : implementedCpnt.getRequiredInterfaces()) {
                if (requiredItf.contains(itf)) continue;
                requiredItf.add(itf);
            }
        }
        return requiredItf;
    }

    public static List<Interface> computeProvideToAdd(Component implementorCpnt) {
        ArrayList<Interface> providedItf = new ArrayList<Interface>();
        for (Component implementedLC : implementorCpnt.getAllocatedComponents()) {
            for (Interface itf : implementedLC.getProvidedInterfaces()) {
                if (providedItf.contains(itf)) continue;
                providedItf.add(itf);
            }
        }
        return providedItf;
    }

    public static List<CommunicationLink> computeCommunicationLinksToRemove(Component cpnt, List<CommunicationLink> realizedCommunicationLinks, EClass arch) {
        ArrayList<CommunicationLink> communicationLinks = new ArrayList<CommunicationLink>();
        for (CommunicationLink communicationLink : cpnt.getOwnedCommunicationLinks()) {
            ExchangeItem exchangeItem = communicationLink.getExchangeItem();
            if (exchangeItem == null || EcoreUtil2.isContainedBy((EObject)exchangeItem, (EClass)arch)) continue;
            boolean isContained = false;
            for (CommunicationLink lnk : realizedCommunicationLinks) {
                if (!exchangeItem.equals(lnk.getExchangeItem())) continue;
                isContained = true;
            }
            if (isContained || communicationLinks.contains(communicationLink)) continue;
            communicationLinks.add(communicationLink);
        }
        return communicationLinks;
    }

    public static List<Interface> computeUsageToRemove(Component cpnt, List<Interface> usedInterfaces, EClass arch) {
        ArrayList<Interface> unUsedInterfaces = new ArrayList<Interface>();
        for (Interface usedItfByCpnt : ComponentExt.getUsedInterfaces((Component)cpnt)) {
            if (EcoreUtil2.isContainedBy((EObject)usedItfByCpnt, (EClass)arch) || usedInterfaces.contains(usedItfByCpnt) || unUsedInterfaces.contains(usedItfByCpnt)) continue;
            unUsedInterfaces.add(usedItfByCpnt);
        }
        return unUsedInterfaces;
    }

    public static List<Interface> computeImplementationToRemove(Component cpnt, List<Interface> implementedItf, EClass arch) {
        ArrayList<Interface> unImplementedInterfaces = new ArrayList<Interface>();
        for (Interface implementedItfByCpnt : ComponentExt.getImplementedInterfaces((Component)cpnt)) {
            if (EcoreUtil2.isContainedBy((EObject)implementedItfByCpnt, (EClass)arch) || implementedItf.contains(implementedItfByCpnt) || unImplementedInterfaces.contains(implementedItfByCpnt)) continue;
            unImplementedInterfaces.add(implementedItfByCpnt);
        }
        return unImplementedInterfaces;
    }

    public static List<Interface> computeRequireToRemove(Component cpnt, List<Interface> requiredItf, EClass arch) {
        ArrayList<Interface> unRequiredItf = new ArrayList<Interface>();
        for (Interface requiredItfByCpnt : cpnt.getRequiredInterfaces()) {
            if (EcoreUtil2.isContainedBy((EObject)requiredItfByCpnt, (EClass)arch) || requiredItf.contains(requiredItfByCpnt) || unRequiredItf.contains(requiredItfByCpnt)) continue;
            unRequiredItf.add(requiredItfByCpnt);
        }
        return unRequiredItf;
    }

    public static List<Interface> computeProvideToRemove(Component cpnt, List<Interface> providedItf, EClass arch) {
        ArrayList<Interface> unProvidedItf = new ArrayList<Interface>();
        for (Interface providedItfByCpnt : cpnt.getProvidedInterfaces()) {
            if (EcoreUtil2.isContainedBy((EObject)providedItfByCpnt, (EClass)arch) || providedItf.contains(providedItfByCpnt) || unProvidedItf.contains(providedItfByCpnt)) continue;
            unProvidedItf.add(providedItfByCpnt);
        }
        return unProvidedItf;
    }

    private static Interface retrieveTransformedInterface(Interface srcItf) {
        for (AbstractTrace trace : srcItf.getIncomingTraces()) {
            if (!(trace instanceof ContextInterfaceRealization) && !(trace instanceof LogicalInterfaceRealization) || !(trace.getSourceElement() instanceof Interface)) continue;
            return (Interface)trace.getSourceElement();
        }
        return null;
    }
}

