/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.core.compare.CapellaScope;

public class CapellaComparePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.polarsys.capella.core.compare";
    private static CapellaComparePlugin plugin;
    protected static final String CC_PROJECT_NATURE = "com.rational.clearcase.ccprovider_nature";
    protected final Map<CapellaScope, IProject> _proxyProjects = new HashMap<CapellaScope, IProject>();

    public void cleanupProxyProjects() {
        for (IProject proxyProject : this._proxyProjects.values()) {
            try {
                RepositoryProvider.unmap((IProject)proxyProject);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            try {
                proxyProject.delete(true, true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static CapellaComparePlugin getDefault() {
        return plugin;
    }

    public IProject getProxyProject(CapellaScope scope_p, IPath externalFilePath_p) {
        IWorkspace wk;
        IProject result = this._proxyProjects.get((Object)scope_p);
        if (result == null && (wk = ResourcesPlugin.getWorkspace()) != null && wk.getRoot() != null) {
            result = wk.getRoot().getProject("DiffMergeExternalFiles_" + System.identityHashCode((Object)scope_p));
            try {
                if (!result.exists()) {
                    result.create(null);
                }
                if (!result.isOpen()) {
                    result.open(null);
                }
                this.forceClearCaseNature(result, externalFilePath_p);
                this._proxyProjects.put(scope_p, result);
            }
            catch (TeamException teamException) {
            }
            catch (CoreException e) {
                result = null;
            }
        }
        return result;
    }

    protected boolean forceClearCaseNature(IProject project_p, IPath referencePath_p) {
        boolean result = false;
        try {
            RepositoryProvider.map((IProject)project_p, (String)CC_PROJECT_NATURE);
            ProxyProjectWrapper wrapper = new ProxyProjectWrapper(project_p, referencePath_p);
            Bundle ccBundle = Platform.getBundle((String)"com.rational.clearcase");
            Class ccClass = ccBundle.loadClass("com.rational.clearcase.ClearCasePlugin");
            Class srvClass = ccBundle.loadClass("com.rational.clearcase.RSCMService");
            Object service = ccClass.getMethod("getCMService", new Class[0]).invoke(null, new Object[0]);
            Object eval = srvClass.getMethod("connectProject", IProject.class).invoke(service, new Object[]{wrapper});
            result = eval instanceof Boolean && (Boolean)eval != false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.cleanupProxyProjects();
    }

    protected static class ProxyProjectWrapper
    extends Project {
        private final IProject _wrappedProject;
        private final IPath _specificLocation;

        public ProxyProjectWrapper(IProject wrappedProject_p, IPath specificLocation_p) {
            super(wrappedProject_p.getFullPath(), (Workspace)wrappedProject_p.getWorkspace());
            this._wrappedProject = wrappedProject_p;
            this._specificLocation = specificLocation_p;
        }

        public IPath getLocation() {
            return this._specificLocation;
        }

        public IProject getWrappedProject() {
            return this._wrappedProject;
        }

        public boolean equals(Object peer_p) {
            boolean result = false;
            if (peer_p instanceof ProxyProjectWrapper) {
                result = ((ProxyProjectWrapper)((Object)peer_p)).getWrappedProject().equals((Object)this.getWrappedProject());
            } else if (peer_p instanceof IProject) {
                result = ((IProject)peer_p).equals((Object)this.getWrappedProject());
            }
            return result;
        }

        public int hashCode() {
            return this.getWrappedProject().hashCode();
        }
    }
}

