/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.bundle.FeatureHelper;
import org.polarsys.capella.common.consonance.ui.sirius.SiriusScope;
import org.polarsys.capella.common.libraries.LibrariesPackage;
import org.polarsys.capella.common.libraries.LibraryReference;
import org.polarsys.capella.core.compare.CapellaComparePlugin;
import org.polarsys.capella.core.compare.Messages;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaFeatureHelper;
import org.polarsys.capella.core.model.handler.pre.commit.listener.FileModificationPreCommitListener;

public class CapellaScope
extends SiriusScope {
    protected boolean _ignoreCapellaVersions;

    public CapellaScope(URI uri, EditingDomain domain, boolean readOnly) {
        super(uri, domain, readOnly);
    }

    public CapellaScope(URI uri, ResourceSet resourceSet, boolean readOnly) {
        super(uri, resourceSet, readOnly);
    }

    protected void addNewResource(Resource resource) {
        if (!this._ignoreCapellaVersions) {
            this.checkCapellaVersion(resource);
        }
        super.addNewResource(resource);
        if (!resource.isTrackingModification()) {
            resource.setTrackingModification(true);
        }
    }

    protected boolean areCompatible(String toolVersion1, String toolVersion2) {
        boolean result = true;
        if (toolVersion1 != null && toolVersion2 != null) {
            result = false;
            String pattern = Pattern.quote(".");
            String[] segments1 = toolVersion1.split(pattern);
            String[] segments2 = toolVersion2.split(pattern);
            if (segments1.length >= 2 && segments2.length >= 2 && segments1[0].equals(segments2[0])) {
                result = segments1[1].equals(segments2[1]);
            }
        }
        return result;
    }

    protected void checkCapellaVersion(Resource resource) {
        IFile capellaFile;
        if (resource != null && CapellaResourceHelper.isCapellaResource((Resource)resource) && (capellaFile = this.getFileFor(resource)) != null) {
            String fileVersion;
            String capellaVersion = FeatureHelper.getCapellaVersion((boolean)false);
            String rawVersion = CapellaFeatureHelper.getDetectedVersion((IFile)capellaFile);
            String string = fileVersion = rawVersion == null || rawVersion.length() < 5 ? null : rawVersion.substring(0, 5);
            if (!this.areCompatible(fileVersion, capellaVersion)) {
                final ArrayList emptyIfProceed = new ArrayList(1);
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String msg = String.format(Messages.CapellaScope_DifferentVersion, fileVersion, capellaFile.getFullPath().toString());
                        boolean proceed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)EMFDiffMergeUIPlugin.LABEL, (String)msg);
                        if (!proceed) {
                            emptyIfProceed.add(new Object());
                        }
                    }
                });
                if (!emptyIfProceed.isEmpty()) {
                    throw new RuntimeException(Messages.CapellaScope_DifferentVersionInterruption);
                }
                this._ignoreCapellaVersions = true;
            }
        }
    }

    protected boolean checkWritePermission() {
        boolean result;
        int nbResources = this.getResources().size();
        ArrayList<Resource> modifiedResources = new ArrayList<Resource>(nbResources);
        for (Resource currentRes : this.getResources()) {
            if (!currentRes.isModified()) continue;
            modifiedResources.add(currentRes);
        }
        final TransactionalEditingDomain domain = this.findEditingDomain(modifiedResources);
        boolean bl = result = domain == null;
        if (!result) {
            final ArrayList<IFile> modifiedFiles = new ArrayList<IFile>(modifiedResources.size());
            for (Resource currentRes : modifiedResources) {
                IFile file = this.getFileFor(currentRes);
                if (file == null) continue;
                modifiedFiles.add(file);
                try {
                    file.touch(null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            final ArrayList emptyIfOk = new ArrayList(1);
            MiscUtil.executeOnDomain((EditingDomain)domain, (String)Messages.CapellaScope_PermissionCommandName, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FileModificationPreCommitListener.makeFilesWritable((TransactionalEditingDomain)domain, (Collection)modifiedFiles);
                    }
                    catch (Exception e) {
                        emptyIfOk.add(e);
                    }
                }
            });
            result = emptyIfOk.isEmpty();
        }
        return result;
    }

    protected TransactionalEditingDomain findEditingDomain(Collection<Resource> resources) {
        for (Resource resource : resources) {
            TransactionalEditingDomain result = TransactionUtil.getEditingDomain((Resource)resource);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element) {
        Collection result = super.getCrossReferencesInScope(element);
        if (element instanceof LibraryReference) {
            result.add(LibrariesPackage.eINSTANCE.getLibraryReference_Library());
        }
        return result;
    }

    protected IFile getFileFor(Resource resource) {
        IFile result = null;
        URI uri = resource.getURI();
        if (uri != null) {
            if (uri.isPlatformResource()) {
                String platformResourcePath = uri.toPlatformString(true);
                result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath));
            } else {
                String fileString = uri.toFileString();
                if (fileString != null) {
                    Path path = new Path(fileString);
                    IProject proxyProject = CapellaComparePlugin.getDefault().getProxyProject(this, (IPath)path);
                    if (proxyProject != null) {
                        try {
                            String linkName = this.makeLinkName(uri);
                            result = proxyProject.getFile(linkName);
                            result.createLink((IPath)path, 256, null);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return result;
    }

    protected final List<Resource> getRelevantReferencedResources(EObject element) {
        List result = super.getRelevantReferencedResources(element);
        for (Resource resource : new ArrayList(result)) {
            if (!"ecore".equals(resource.getURI().fileExtension())) continue;
            result.remove(resource);
        }
        return result;
    }

    protected String makeLinkName(URI uri) {
        URI truncated = uri.trimFileExtension();
        String extension = uri.fileExtension();
        String segment = truncated.lastSegment();
        URI result = truncated.trimSegments(1).appendSegment(segment);
        result = result.appendFileExtension(extension);
        return result.lastSegment();
    }

    public boolean save() throws Exception {
        boolean result = this.checkWritePermission();
        if (result) {
            result = super.save();
        }
        return result;
    }
}

