/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.ui.properties.helpers.NotificationHelper;

public abstract class AbstractSemanticField
implements SelectionListener,
FocusListener,
KeyListener {
    protected EObject _semanticElement;
    protected EStructuralFeature _semanticFeature;
    protected TabbedPropertySheetWidgetFactory _widgetFactory;
    private boolean _displayedInWizard;

    protected AbstractSemanticField(TabbedPropertySheetWidgetFactory widgetFactory) {
        this._widgetFactory = widgetFactory;
        this._displayedInWizard = false;
    }

    public boolean isDisplayedInWizard() {
        return this._displayedInWizard;
    }

    public void setDisplayedInWizard(boolean displayedInWizard) {
        this._displayedInWizard = displayedInWizard;
    }

    protected void executeCommand(ICommand command) {
        if (command == null) {
            return;
        }
        ICommand cmd = command;
        if (this.isDisplayedInWizard()) {
            cmd = this.createNonDirtyingCommand(command);
        } else if (command instanceof AbstractReadWriteCommand) {
            cmd = this.createReadWriteCommand(command);
        }
        this.verifiedExecution(cmd);
    }

    protected ExecutionManager getExecutionManager() {
        return TransactionHelper.getExecutionManager((EObject)this._semanticElement);
    }

    protected void verifiedExecution(ICommand command) {
        TransactionalEditingDomain editingDomain;
        ExecutionManager executionManager = this.getExecutionManager();
        if (executionManager != null && (editingDomain = executionManager.getEditingDomain()) instanceof InternalTransactionalEditingDomain) {
            InternalTransaction activeTransaction = ((InternalTransactionalEditingDomain)editingDomain).getActiveTransaction();
            if (activeTransaction != null && activeTransaction.isActive()) {
                command.run();
            } else {
                executionManager.execute(command);
            }
        }
    }

    private ICommand createReadWriteCommand(final ICommand command) {
        return new AbstractReadWriteCommand(){

            public void run() {
                command.run();
            }

            public Collection<?> getAffectedObjects() {
                return Collections.singletonList(AbstractSemanticField.this._semanticElement);
            }

            public String getName() {
                return "Model Edition";
            }

            public void commandInterrupted() {
                this.commandRolledBack();
            }

            public void commandRolledBack() {
                AbstractSemanticField.this.loadData(AbstractSemanticField.this._semanticElement);
            }
        };
    }

    private ICommand createNonDirtyingCommand(final ICommand command) {
        return new AbstractNonDirtyingCommand(){

            public void run() {
                command.run();
            }

            public void commandInterrupted() {
                this.commandRolledBack();
            }

            public void commandRolledBack() {
                AbstractSemanticField.this.loadData(AbstractSemanticField.this._semanticElement);
            }
        };
    }

    public void loadData(EObject semanticElement, EStructuralFeature semanticFeature) {
        this._semanticElement = semanticElement;
        this._semanticFeature = semanticFeature;
    }

    public abstract void loadData(EObject var1);

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null && source instanceof Text) {
            this.fillTextField((Text)source);
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        Object source;
        if (event != null && (this._displayedInWizard || !this._displayedInWizard && event.character == '\r') && (source = event.getSource()) != null && source instanceof Text) {
            this.fillTextField((Text)source);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null && source instanceof CCombo) {
            this.fillComboField((CCombo)source);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    protected void fillTextField(Text textField) {
    }

    protected void fillComboField(CCombo comboField) {
    }

    protected void setTextValue(Text text, EObject object, EStructuralFeature feature) {
        Object value = object.eGet(feature);
        if (value instanceof String) {
            text.setText((String)value);
        } else if (value instanceof Integer) {
            text.setText(((Integer)value).toString());
        } else if (value instanceof Float) {
            text.setText(((Float)value).toString());
        } else if (value instanceof Double) {
            text.setText(((Double)value).toString());
        } else {
            text.setText("");
        }
    }

    protected void setDataValue(final EObject object, final EStructuralFeature feature, final Object value) {
        if (NotificationHelper.isNotificationRequired(object, feature, value)) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    if (feature instanceof EAttribute) {
                        EDataType type = ((EAttribute)feature).getEAttributeType();
                        if (EcorePackage.eINSTANCE.getEString().equals(type)) {
                            object.eSet(feature, value);
                        } else if (EcorePackage.eINSTANCE.getEBoolean().equals(type)) {
                            object.eSet(feature, value);
                        } else if (EcorePackage.eINSTANCE.getEInt().equals(type)) {
                            if (value instanceof String) {
                                try {
                                    object.eSet(feature, (Object)Integer.parseInt((String)value));
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else if (EcorePackage.eINSTANCE.getEFloat().equals(type)) {
                            if (value instanceof String) {
                                try {
                                    object.eSet(feature, (Object)new Float(Float.parseFloat((String)value)));
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else if (EcorePackage.eINSTANCE.getEDouble().equals(type) && value instanceof String) {
                            try {
                                object.eSet(feature, (Object)new Double(Double.parseDouble((String)value)));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if (feature instanceof EReference) {
                        if (((EReference)feature).isContainment()) {
                            EObject oldValue = (EObject)object.eGet(feature);
                            AbstractSemanticField.deleteContainmentValue(oldValue);
                        }
                        object.eSet(feature, value);
                    }
                }
            };
            this.executeCommand((ICommand)command);
        }
    }

    protected void addDataValue(final EObject object, final EStructuralFeature feature, final Object value) {
        if (NotificationHelper.isNotificationRequired(object, feature, value)) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    ((List)object.eGet(feature)).add(value);
                }
            };
            this.executeCommand((ICommand)command);
        }
    }

    protected void moveDataValue(final EObject object, final EObject owner, final EStructuralFeature feature) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                if (feature.isMany()) {
                    ((List)owner.eGet(feature)).add(object);
                } else {
                    owner.eSet(feature, (Object)object);
                }
            }
        };
        this.executeCommand((ICommand)command);
    }

    protected void removeDataValue(final EObject object, final EStructuralFeature feature, final Object value) {
        if (NotificationHelper.isNotificationRequired(object, feature, value)) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                        AbstractSemanticField.deleteContainmentValue((EObject)value);
                    } else {
                        ((List)object.eGet(feature)).remove(value);
                    }
                }
            };
            this.executeCommand((ICommand)command);
        }
    }

    protected void removeAllDataValue(final EObject object, final EStructuralFeature feature) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                    ArrayList containmentList = new ArrayList((List)object.eGet(feature));
                    for (EObject containedObject : containmentList) {
                        AbstractSemanticField.deleteContainmentValue(containedObject);
                    }
                } else {
                    ((List)object.eGet(feature)).clear();
                }
            }
        };
        this.executeCommand((ICommand)command);
    }

    public static void deleteContainmentValue(EObject object) {
        CapellaDeleteCommand command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)object), Collections.singleton(object), false, false, true);
        if (command.canExecute()) {
            command.execute();
        }
    }

    protected void setDataValue(final EObject object, final EStructuralFeature feature, boolean value) {
        final Boolean val = value;
        if (NotificationHelper.isNotificationRequired(object, feature, val)) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    object.eSet(feature, (Object)val);
                }
            };
            this.executeCommand((ICommand)command);
        }
    }

    protected void setBooleanValue(Button button, EObject object, EStructuralFeature feature) {
        Object value = object.eGet(feature);
        if (value instanceof Boolean) {
            this.setBooleanValue(button, (Boolean)value);
        }
    }

    protected void setBooleanValue(Button button, boolean value) {
        button.setSelection(value);
    }

    public abstract void setEnabled(boolean var1);

    protected Button createButton(Composite parent, Image image, String tooltip) {
        Button button = this._widgetFactory.createButton(parent, "", 8);
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener((SelectionListener)this);
        button.setImage(image);
        button.setToolTipText(tooltip);
        return button;
    }
}

