/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.model.utils.CollectionExt;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticGroup;

public class EnumerationValueGroup
extends AbstractSemanticGroup {
    protected CCombo _valueField;
    private Map<String, EObject> _items;

    public EnumerationValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, widgetFactory, false);
        this._widgetFactory.createCLabel(this._parent, label);
        this._valueField = this.createValueComboField();
        this._valueField.setEditable(false);
    }

    protected CCombo createValueComboField() {
        CCombo valueField = this._widgetFactory.createCCombo(this._parent, 2048);
        valueField.addSelectionListener((SelectionListener)this);
        valueField.setLayoutData((Object)new GridData(768));
        valueField.setEditable(false);
        return valueField;
    }

    @Override
    public void loadData(EObject semanticElement, EStructuralFeature semanticFeature) {
        super.loadData(semanticElement, semanticFeature);
        this.loadComboValue();
    }

    @Override
    public void loadData(EObject semanticElement) {
        this.loadComboValue();
    }

    public void loadComboValue() {
        if (this._valueField != null) {
            if (this._items == null) {
                this._items = new HashMap<String, EObject>();
            }
            this._items.clear();
            this._items.put("", null);
            for (EObject element : this.getAvailableValues()) {
                if (!(element instanceof AbstractNamedElement)) continue;
                this._items.put(((AbstractNamedElement)element).getName(), element);
            }
            this._valueField.setItems(CollectionExt.getArray(this._items.keySet()));
            int index = this.getSelection();
            if (index == -1) {
                this._valueField.deselectAll();
            } else {
                this._valueField.select(index);
            }
        }
    }

    protected int getSelection() {
        for (EObject element : this.getCurrentValues()) {
            if (!(element instanceof AbstractNamedElement)) continue;
            String selection = ((AbstractNamedElement)element).getName();
            int i = 0;
            while (i < this._valueField.getItemCount()) {
                if (selection.equals(this._valueField.getItem(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected List<EObject> getAvailableValues() {
        ArrayList<EObject> result = new ArrayList<EObject>(0);
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, this._semanticFeature);
        if (query != null) {
            result.addAll(query.getAvailableElements(this._semanticElement));
        }
        return result;
    }

    protected List<EObject> getCurrentValues() {
        ArrayList<EObject> result = new ArrayList<EObject>(0);
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CapellacorePackage.Literals.CAPELLA_ELEMENT, this._semanticFeature);
        if (query != null) {
            result.addAll(query.getCurrentElements(this._semanticElement, false));
        }
        return result;
    }

    @Override
    protected void fillComboField(CCombo comboField) {
        if (comboField.equals(this._valueField)) {
            String selecteditem = this._valueField.getItem(this._valueField.getSelectionIndex());
            this.setDataValue(this._semanticElement, this._semanticFeature, this._items.get(selecteditem));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._valueField != null && !this._valueField.isDisposed()) {
            this._valueField.setEnabled(enabled);
        }
    }
}

