/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.ctx;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorExt;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class GetAvailable_Mission_InteractingActors
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ActorPkg actorPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
        if (systemEngineering == null) {
            return availableElements;
        }
        if (element instanceof Mission) {
            Mission currentMission = (Mission)element;
            availableElements.addAll(this.getRule_MQRY_Mission_Interactions_11(ca.getOwnedActorPkg(), currentMission));
        } else if (element instanceof MissionPkg && (actorPkg = ca.getOwnedActorPkg()) != null) {
            availableElements.addAll(ActorPkgExt.getAllActors((ActorPkg)actorPkg));
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_Mission_Interactions_11(ActorPkg actorPkg, Mission currentMission) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (actorPkg != null) {
            for (Actor actor : ActorPkgExt.getAllActors((ActorPkg)actorPkg)) {
                if (actor == null || ActorExt.isInteracting((Actor)actor, (Mission)currentMission)) continue;
                availableElements.add((CapellaElement)actor);
            }
        }
        return availableElements;
    }
}

