/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.fa;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchangeRealization;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;

public class GetAvailable_FunctionalExchange_FunctionalExchangeRealizations
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        ArrayList<Object> exploredArchitectures = new ArrayList<Object>();
        CapellaElement currentArchitecture = element;
        while (!(currentArchitecture instanceof BlockArchitecture)) {
            if ((currentArchitecture = currentArchitecture.eContainer()) != null) continue;
            return availableElements;
        }
        SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
        if (sysEng == null) {
            return availableElements;
        }
        if (currentArchitecture instanceof SystemAnalysis) {
            exploredArchitectures.add(SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)sysEng));
        } else if (currentArchitecture instanceof LogicalArchitecture) {
            exploredArchitectures.add(SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)sysEng));
        } else if (currentArchitecture instanceof PhysicalArchitecture) {
            exploredArchitectures.addAll(SystemEngineeringExt.getAllLogicalArchitecture((CapellaElement)element));
        } else {
            return availableElements;
        }
        for (BlockArchitecture blockArchitecture : exploredArchitectures) {
            for (EObject aFunctionalExchange : EObjectExt.getAll((EObject)blockArchitecture, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
                availableElements.add((CapellaElement)aFunctionalExchange);
            }
        }
        List<CapellaElement> list = this.getCurrentElements(element, false);
        for (CapellaElement capellaElement : list) {
            availableElements.remove(capellaElement);
        }
        return availableElements;
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof FunctionalExchange) {
            FunctionalExchange ele = (FunctionalExchange)element;
            EList ownedFunctionalExchangeRealisations = ele.getOwnedFunctionalExchangeRealizations();
            for (FunctionalExchangeRealization functionalExchangeRealisation : ownedFunctionalExchangeRealisations) {
                currentElements.add((CapellaElement)functionalExchangeRealisation.getTargetElement());
            }
        }
        return currentElements;
    }
}

