/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.activities;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.CompoundScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.RuleContainersScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.RuleRootElementsScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.traceability.CompoundTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.core.transition.system.handlers.attachment.CapellaDefaultAttachmentHandler;
import org.polarsys.capella.core.transition.system.handlers.traceability.config.MergeTargetConfiguration;
import org.polarsys.capella.core.transition.system.handlers.transformation.CapellaTransformationHandler;
import org.polarsys.capella.core.transition.system.helpers.SemanticHelper;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeTransitionActivity
extends org.polarsys.capella.core.transition.common.activities.InitializeTransitionActivity {
    public static final String ID = "org.polarsys.capella.core.transition.system.activities.InitializeTransitionActivity";

    protected IStatus initializeContext(IContext context, ActivityParameters activityParams) {
        IStatus status = super.initializeContext(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeOptimizations(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        return status;
    }

    protected IStatus initializeScopeRetrieverHandlers(IContext context, CompoundScopeRetriever handler, ActivityParameters activityParams) {
        handler.addScopeRetriever((IScopeRetriever)new RuleRootElementsScopeRetriever(), context);
        handler.addScopeRetriever((IScopeRetriever)new RuleContainersScopeRetriever(), context);
        return super.initializeScopeRetrieverHandlers(context, handler, activityParams);
    }

    protected IStatus initializeOptimizations(IContext context, ActivityParameters activityParams) {
        return Status.OK_STATUS;
    }

    protected IStatus initializeTransitionSources(IContext context, ActivityParameters activityParams) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SELECTION");
        context.put((Object)"TRANSITION_SOURCES", this.adaptSelection(selection));
        return Status.OK_STATUS;
    }

    protected Collection<Object> adaptSelection(Collection<Object> selection) {
        Collection<Object> result = SemanticHelper.getSemanticObjects(selection);
        return result;
    }

    protected IStatus initializeSource(IContext context, ActivityParameters activityParams) {
        EObject source;
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (selection.size() > 0) {
            source = (EObject)selection.toArray()[0];
            if (!(source instanceof CapellaElement)) {
                return new Status(4, Messages.Activity_Transition, "Input selection is not a CapellaElement");
            }
        } else {
            return new Status(4, Messages.Activity_Transition, "No input selection");
        }
        this.ensureOpening(source);
        SystemEngineering root = SystemEngineeringExt.getSystemEngineering((CapellaElement)((CapellaElement)source));
        context.put((Object)"_TSRo", (Object)root);
        context.put((Object)"_T_S_Res", (Object)root.eResource());
        context.put((Object)"TRANSITION_SOURCE_EDITING_DOMAIN", (Object)TransactionUtil.getEditingDomain((Resource)root.eResource()));
        return Status.OK_STATUS;
    }

    protected IStatus initializeTarget(IContext context, ActivityParameters activityParams) {
        Resource sourceResource = (Resource)context.get((Object)"_T_S_Res");
        Resource outputResource = sourceResource;
        if (outputResource != null && outputResource.getContents().size() != 0) {
            context.put((Object)"_T_T_Res", (Object)outputResource);
            context.put((Object)"TRANSITION_TARGET_EDITING_DOMAIN", (Object)TransactionUtil.getEditingDomain((Resource)outputResource));
            Project project = (Project)CapellaElementExt.getRoot((CapellaElement)((CapellaElement)outputResource.getContents().get(0)));
            SystemEngineering sysengineering = null;
            Object sourceRoot = context.get((Object)"_TSRo");
            sysengineering = sourceRoot instanceof SystemEngineering ? (SystemEngineering)sourceRoot : this.getEngineering(project, project.getName());
            if (sysengineering != null) {
                context.put((Object)"_TTRo", (Object)sysengineering);
            }
        } else {
            return new Status(4, Messages.Activity_Transition, "Output model is invalid");
        }
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultAttachmentHandler() {
        return new CapellaDefaultAttachmentHandler();
    }

    protected IHandler createDefaultTransformationHandler() {
        return new CapellaTransformationHandler();
    }

    protected IHandler createDefaultTraceabilityTargetHandler() {
        MergeTargetConfiguration configuration = new MergeTargetConfiguration();
        return new CompoundTraceabilityHandler((ITraceabilityConfiguration)configuration);
    }

    protected void ensureOpening(EObject source) {
        Session session = SessionManager.INSTANCE.getSession(source);
        if (session == null && source instanceof CapellaElement) {
            SystemEngineering element = SystemEngineeringExt.getSystemEngineering((CapellaElement)((CapellaElement)source));
            EObject root = element.eContainer();
            root.eResource();
        }
    }

    protected SystemEngineering getEngineering(Project project, String name) {
        ModelRoot root2;
        for (ModelRoot root2 : project.getOwnedModelRoots()) {
            if (!(root2 instanceof SystemEngineering) || !((SystemEngineering)root2).getName().equals(name)) continue;
            return (SystemEngineering)root2;
        }
        if (!project.getOwnedModelRoots().isEmpty() && project.getOwnedModelRoots().size() == 1 && (root2 = (ModelRoot)project.getOwnedModelRoots().iterator().next()) instanceof SystemEngineering) {
            return (SystemEngineering)root2;
        }
        return null;
    }
}

