/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.menu.dynamic.AbstractActionProvider;
import org.polarsys.capella.common.menu.dynamic.contributions.ActionContributionProvider;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaValidateAction;
import org.polarsys.capella.core.validation.ui.CapellaValidationUIActivator;
import org.polarsys.capella.core.validation.ui.DynamicActionContributionItem;
import org.polarsys.capella.core.validation.ui.actions.EPFValidationAction;

public class DynamicActionProvider
extends AbstractActionProvider {
    private ValidateAction defaultValidationAction;
    private List<ValidateAction> userValidationActions;
    private ImageDescriptor imageDescriptor;
    private ISelectionProvider selectionProvider;

    public DynamicActionProvider() {
        ActionContributionProvider.getInstance();
    }

    protected void initActions(Shell shell, IWorkbenchPage page, ISelectionProvider _selectionProvider) {
        this.selectionProvider = _selectionProvider;
        this.imageDescriptor = CapellaValidationUIActivator.getDefault().getImageDescriptor("capella_validate_16.gif");
        this.userValidationActions = new ArrayList<ValidateAction>();
        this.defaultValidationAction = this.createDefaultValidation();
        for (IFile file : PreferencesHelper.retrieveUserDefinedPreferenceFiles((ISelectionProvider)this.selectionProvider, (String)"epf")) {
            this.userValidationActions.add(this.createValidationAction(false, file, this.selectionProvider, this.imageDescriptor));
        }
    }

    public ValidateAction createDefaultValidation() {
        this.imageDescriptor = CapellaValidationUIActivator.getDefault().getImageDescriptor("capella_validate_16.gif");
        CapellaValidateAction validationAction = new CapellaValidateAction();
        validationAction.setImageDescriptor(this.imageDescriptor);
        validationAction.setText("Validate Model");
        validationAction.setActiveWorkbenchPart(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)validationAction);
        ISelection selection = this.selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            validationAction.selectionChanged(new SelectionChangedEvent(this.selectionProvider, selection));
        }
        return validationAction;
    }

    protected IContributionItem createContributionItem() {
        if (this.userValidationActions.size() > 0) {
            MenuManager menuManager = new MenuManager("Validate Model", this.imageDescriptor, "ID");
            menuManager.add((IAction)this.defaultValidationAction);
            menuManager.add((IContributionItem)new Separator());
            for (ValidateAction action : this.userValidationActions) {
                menuManager.add((IAction)action);
            }
            return menuManager;
        }
        this.imageDescriptor = CapellaValidationUIActivator.getDefault().getImageDescriptor("capella_validate_16.gif");
        this.userValidationActions = new ArrayList<ValidateAction>();
        this.defaultValidationAction = this.createDefaultValidation();
        MenuManager menu = new MenuManager("Validate Model", this.imageDescriptor, "ID");
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.defaultValidationAction);
        return menu;
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.insertAfter("group.new", this.createContributionItem());
    }

    public void fillActionBars(IActionBars actionBars) {
    }

    protected ValidateAction createValidationAction(boolean isRootAction, IFile file, ISelectionProvider selectionProvider, ImageDescriptor imageDescriptor) {
        EPFValidationAction validationAction = new EPFValidationAction(isRootAction, file);
        validationAction.setImageDescriptor(imageDescriptor);
        validationAction.setActiveWorkbenchPart(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)validationAction);
        ISelection selection = selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            validationAction.selectionChanged(new SelectionChangedEvent(selectionProvider, selection));
            validationAction.setEnabled(true);
        }
        return validationAction;
    }

    protected void addContributionItem(IMenuManager menu, String groupId, IContributionItem item) {
        if (groupId != null) {
            menu.appendToGroup(groupId, item);
        } else {
            menu.add(item);
        }
    }

    protected void addAction(IMenuManager menu, String groupId, IAction action) {
        this.addContributionItem(menu, groupId, (IContributionItem)new DynamicActionContributionItem(action));
    }
}

