/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.LightMarkerRegistry;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.links.helpers.LinksCommandRegistry;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerActivator;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerState;
import org.polarsys.capella.core.ui.fastlinker.Messages;
import org.polarsys.capella.core.ui.fastlinker.view.FastLinkerView;

public class FastLinkerManager {
    protected final FastLinkerState _currentState = new FastLinkerState();
    protected final List<AbstractCreateLinksCommand> _firstToSecondCommands = new ArrayList<AbstractCreateLinksCommand>();
    protected final List<AbstractCreateLinksCommand> _secondToFirstCommands = new ArrayList<AbstractCreateLinksCommand>();

    protected Collection getElementToPut(Collection originalElement_p) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object elem : originalElement_p) {
            if (CsPackage.Literals.PART.isInstance((Object)originalElement_p)) {
                ret.add(((Part)elem).getAbstractType());
                continue;
            }
            ret.add(elem);
        }
        return ret;
    }

    public static EClass getCommonType(Collection<? extends EObject> elements_p) {
        EClass result = null;
        if (!elements_p.isEmpty()) {
            ArrayList<EClass> common = new ArrayList<EClass>(FastLinkerManager.getSuperTypes(elements_p.iterator().next().eClass()));
            for (EObject eObject : elements_p) {
                common.retainAll(FastLinkerManager.getSuperTypes(eObject.eClass()));
            }
            if (!common.isEmpty()) {
                result = (EClass)common.get(common.size() - 1);
            }
        }
        return result;
    }

    private static List<EClass> getSuperTypes(EClass class_p) {
        EList allButSelf = class_p.getEAllSuperTypes();
        ArrayList<EClass> result = new ArrayList<EClass>(allButSelf.size() + 1);
        result.addAll((Collection<EClass>)allButSelf);
        result.add(class_p);
        return Collections.unmodifiableList(result);
    }

    public boolean acceptElementInFastLinker(Collection elementToPut_p) {
        if (!this.putInFastLinkerPreconditionsRespected(elementToPut_p)) {
            return false;
        }
        Collection modelElementToPut = this.getElementToPut(elementToPut_p);
        FastLinkerState futureState = this._currentState.getPreviewState(modelElementToPut);
        if (futureState == null) {
            return false;
        }
        this._firstToSecondCommands.clear();
        this._secondToFirstCommands.clear();
        if (futureState._firstElement != null && futureState._secondElement == null && !futureState._firstElement.isEmpty()) {
            EClass commonSuperType = FastLinkerManager.getCommonType(elementToPut_p);
            LinksCommandRegistry linksCommandRegistryInstance = LinksCommandRegistry.getInstance();
            if (linksCommandRegistryInstance.containsCommandForSourceType(commonSuperType) || linksCommandRegistryInstance.containsCommandForTargetType(commonSuperType)) {
                return true;
            }
        } else if (!futureState._firstElement.isEmpty() && !futureState._secondElement.isEmpty()) {
            EClass firstSuperType = FastLinkerManager.getCommonType(futureState._firstElement);
            EClass secondSuperType = FastLinkerManager.getCommonType(futureState._secondElement);
            if (LinksCommandRegistry.getInstance().containsCommandForSourceTargetTypes(firstSuperType, secondSuperType) || LinksCommandRegistry.getInstance().containsCommandForSourceTargetTypes(secondSuperType, firstSuperType)) {
                this._firstToSecondCommands.addAll(LinksCommandRegistry.getInstance().getExecutableCommands(futureState._firstElement, futureState._secondElement));
                this._secondToFirstCommands.addAll(LinksCommandRegistry.getInstance().getExecutableCommands(futureState._secondElement, futureState._firstElement));
                if (!this._firstToSecondCommands.isEmpty() || !this._secondToFirstCommands.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean putInFastLinkerPreconditionsRespected(Collection elementToPut_p) {
        if (elementToPut_p == null || elementToPut_p.isEmpty()) {
            return false;
        }
        for (Object it : elementToPut_p) {
            if (it instanceof ModelElement) continue;
            return false;
        }
        return FastLinkerManager.getCommonType(elementToPut_p) != null;
    }

    public void pinModelElement(Collection elementToPin_p) {
        this._currentState.pinModelElement(elementToPin_p);
        this.showFastLinkerView().update();
    }

    public void clearFastLinker() {
        this._currentState.clear();
        this.showFastLinkerView().update();
    }

    public FastLinkerState getCurrentState() {
        return this._currentState;
    }

    public List<AbstractCreateLinksCommand> getFirstToSecondCommands() {
        return Collections.unmodifiableList(this._firstToSecondCommands);
    }

    public List<AbstractCreateLinksCommand> getSecondToFirstCommands() {
        return Collections.unmodifiableList(this._secondToFirstCommands);
    }

    public FastLinkerView showFastLinkerView() {
        try {
            return (FastLinkerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.core.ui.fastlinker.view", null, 2);
        }
        catch (PartInitException exception_p) {
            FastLinkerActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.core.ui.fastlinker", exception_p.getLocalizedMessage(), (Throwable)exception_p));
            return null;
        }
    }

    public void putElementInFastLinker(Collection elementToPut_p) {
        this.putElementInFastLinker(elementToPut_p, null);
    }

    public void putElementInFastLinker(Collection elementToPut_p, AbstractCreateLinksCommand commandToExecute_p) {
        AbstractCreateLinksCommand commandToExecute;
        if (!this.putInFastLinkerPreconditionsRespected(elementToPut_p)) {
            return;
        }
        if (!(commandToExecute_p == null || this._firstToSecondCommands.contains(commandToExecute_p) && this._secondToFirstCommands.contains(commandToExecute_p))) {
            throw new IllegalArgumentException("Command to execute must be amongst executable command(s).");
        }
        Collection modelElementToPut = this.getElementToPut(elementToPut_p);
        this._currentState.updateState(modelElementToPut);
        if (this._firstToSecondCommands.size() == 0 && this._secondToFirstCommands.size() == 0) {
            commandToExecute = null;
        } else if (1 == this._firstToSecondCommands.size() && this._secondToFirstCommands.size() == 0) {
            commandToExecute = this._firstToSecondCommands.get(0);
        } else if (this._firstToSecondCommands.size() == 0 && 1 == this._secondToFirstCommands.size()) {
            commandToExecute = this._secondToFirstCommands.get(0);
        } else if (commandToExecute_p != null) {
            commandToExecute = commandToExecute_p;
        } else {
            FastLinkerView fastLinkerView = this.showFastLinkerView();
            fastLinkerView.update();
            commandToExecute = fastLinkerView.chooseCommandToExecute(this._firstToSecondCommands, this._secondToFirstCommands);
        }
        if (commandToExecute != null) {
            Collection sources = commandToExecute.getSources();
            Collection targets = commandToExecute.getTargets();
            for (ModelElement src : sources) {
                for (ModelElement tgt : targets) {
                    commandToExecute.setSources(Collections.singleton(src));
                    commandToExecute.setTargets(Collections.singleton(tgt));
                    LinksCommandRegistry.getInstance().executeCommand((EObject)src, commandToExecute);
                    this.showCommandExecutedMessage(commandToExecute);
                }
            }
            this._currentState.setLinkCreated(commandToExecute.getLinkRepresentation());
        }
        this.showFastLinkerView().update();
    }

    public void showCommandExecutedMessage(AbstractCreateLinksCommand executedCommand_p) {
        EObject affectedObject;
        String informationMessage;
        EObject createdLinkObject = executedCommand_p.getCreatedLinkObject();
        String sourceName = executedCommand_p.getSource().getLabel();
        String targetName = executedCommand_p.getTarget().getLabel();
        if (createdLinkObject != null) {
            informationMessage = MessageFormat.format(Messages.FastLinkerManager_QualifiedLinkCommandReport, createdLinkObject.eClass().getName(), sourceName, targetName);
            affectedObject = createdLinkObject;
        } else {
            informationMessage = MessageFormat.format(Messages.FastLinkerManager_UnQualifiedLinkCommandReport, executedCommand_p.getLabel(), sourceName, targetName);
            affectedObject = executedCommand_p.getSource();
        }
        LightMarkerRegistry.getInstance().createMarker((IResource)ResourcesPlugin.getWorkspace().getRoot(), (Diagnostic)new BasicDiagnostic(Messages.FastLinker, 0, informationMessage, new Object[]{affectedObject}));
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview", null, 2);
        }
        catch (PartInitException exception_p) {
            MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", exception_p.getLocalizedMessage(), (Throwable)exception_p));
        }
    }

    public void updateCurrentState(Collection first, Collection second, Collection pinned) {
        this._currentState.updateState(first, second, pinned);
        this.showFastLinkerView().update();
    }
}

