/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.exchangeitem;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ExchangeItemDirection
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ExchangeItem) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            ExchangeItem exchangeItem = (ExchangeItem)eObj;
            ExchangeMechanism exchangeMechanism = exchangeItem.getExchangeMechanism();
            if (exchangeMechanism != null && exchangeMechanism != ExchangeMechanism.OPERATION) {
                EList elements = exchangeItem.getOwnedElements();
                for (ExchangeItemElement exchangeItemElement : elements) {
                    ParameterDirection direction = exchangeItemElement.getDirection();
                    if (direction.equals((Object)ParameterDirection.UNSET)) continue;
                    IStatus status = this.createFailureStatus(ctx_p, new Object[]{exchangeItem.getName(), exchangeItemElement.getName()});
                    statuses.add(status);
                }
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

