/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CommunicationLinkIsDelegatedByOneSubcomponentAtLeast
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        if (eObj instanceof CommunicationLink) {
            CommunicationLink link = (CommunicationLink)eObj;
            ExchangeItem item = link.getExchangeItem();
            Component component = CommunicationLinkExt.getSource((CommunicationLink)link);
            List subComponents = ComponentExt.getSubUsedComponents((Component)component, (boolean)false);
            if (subComponents.size() > 0) {
                boolean oneSubfoundAtLeast = false;
                for (Component subComponent : subComponents) {
                    if (!this.getExchangeItemsForLinks(subComponent, link).contains(item)) continue;
                    oneSubfoundAtLeast = true;
                    break;
                }
                if (!oneSubfoundAtLeast) {
                    return ctx_p.createFailureStatus(new Object[]{link.getKind(), CapellaElementExt.getCapellaExplorerLabel((EObject)component), CapellaElementExt.getCapellaExplorerLabel((EObject)item)});
                }
            }
        }
        return ctx_p.createSuccessStatus();
    }

    private List<ExchangeItem> getExchangeItemsForLinks(Component component, CommunicationLink link) {
        ArrayList<ExchangeItem> exchangeItems = new ArrayList<ExchangeItem>();
        ArrayList links = new ArrayList();
        if (CommunicationLinkExt.isSender((CommunicationLink)link)) {
            links.addAll(component.getTransmit());
            links.addAll(component.getSend());
            links.addAll(component.getProduce());
            links.addAll(component.getCall());
            links.addAll(component.getWrite());
        }
        if (CommunicationLinkExt.isReceiver((CommunicationLink)link)) {
            links.addAll(component.getAcquire());
            links.addAll(component.getReceive());
            links.addAll(component.getConsume());
            links.addAll(component.getExecute());
            links.addAll(component.getAccess());
        }
        for (CommunicationLink communicationLink : links) {
            exchangeItems.add(communicationLink.getExchangeItem());
        }
        return exchangeItems;
    }
}

