/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.union;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.UnionKind;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_Union_QualifierCardinality
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Union) {
            Union union = (Union)eObj;
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            if (union.getKind() == UnionKind.UNION) {
                UnionProperty discriminant = union.getDiscriminant();
                UnionProperty defaultProperty = union.getDefaultProperty();
                EList properties = union.getContainedUnionProperties();
                ArrayList<DataValue> qualifiersList = new ArrayList<DataValue>();
                for (UnionProperty property : properties) {
                    if (discriminant == property || defaultProperty == property) continue;
                    EList qualifiers = property.getQualifier();
                    for (DataValue qualifier : qualifiers) {
                        if (qualifiersList.contains(qualifier)) {
                            statuses.add(this.createFailureStatus(ctx_p, new Object[]{property.getName(), union.getName(), qualifier.getName()}));
                            continue;
                        }
                        qualifiersList.add(qualifier);
                    }
                }
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx_p, statuses);
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

