/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.workspace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIFix;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Workspace;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;

public class WorkspaceManager
extends ResourceManager {
    private static final String USER_AF_FILE = ".user.af";
    public static final WorkspaceManager INSTANCE = new WorkspaceManager();
    private IProject currentProject;
    private boolean currentProjectIsOpen;
    private Workspace workspace;

    private WorkspaceManager() {
    }

    @Override
    public Object getRootModel() {
        if (this.isReadOnly()) {
            return null;
        }
        return this.workspace;
    }

    public void projectSelected(IProject project) {
        EList contents;
        if (project != null && project.equals((Object)this.currentProject) && this.currentProjectIsOpen == project.isOpen()) {
            return;
        }
        this.currentProject = project;
        this.disposeWorkspace();
        boolean bl = this.currentProjectIsOpen = this.currentProject != null && this.currentProject.isOpen();
        if (!this.currentProjectIsOpen) {
            this.setReadOnly(true);
            this.workspace = ViewpointFactory.eINSTANCE.createWorkspace();
            this.fireEvent();
            return;
        }
        this.setReadOnly(false);
        IFile userFile = this.currentProject.getFile(USER_AF_FILE);
        URI uri = URIFix.createPlatformResourceURI((String)(String.valueOf(this.currentProject.getName()) + '/' + USER_AF_FILE), (boolean)false);
        if (userFile.exists() && !(contents = set.getResource(uri, true).getContents()).isEmpty()) {
            this.workspace = (Workspace)contents.get(0);
        }
        if (this.workspace == null) {
            this.workspace = ViewpointFactory.eINSTANCE.createWorkspace();
            Resource createResource = set.createResource(uri);
            createResource.getContents().add((Object)this.workspace);
            this.saveModel();
        }
        this.fireEvent();
    }

    private void disposeWorkspace() {
        if (this.workspace != null && this.workspace.eResource() != null) {
            Resource eResource = this.workspace.eResource();
            eResource.unload();
            set.getResources().remove((Object)eResource);
        }
        this.workspace = null;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isReadOnly() {
        return super.isReadOnly() || this.workspace == null;
    }

    @Override
    public long getModelTimeStamp() {
        if (this.workspace == null || this.workspace.eResource() == null) {
            return -1L;
        }
        return this.workspace.eResource().getTimeStamp();
    }

    @Override
    public void saveModel() {
        if (this.isReadOnly()) {
            return;
        }
        try {
            Resource resource = this.workspace.eResource();
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            AD_Log.getDefault().logError((Throwable)e);
        }
        this.fireEvent();
    }

    public static abstract class ElementHandler
    extends ResourceManager.AbstractElementHandler {
        protected ElementHandler(Viewpoint viewpoint, ResourceManager wsManager) {
            super(viewpoint, wsManager);
        }

        protected Workspace getWorkspace() {
            return ((WorkspaceManager)this.getResourceManager()).getWorkspace();
        }

        protected ResourceManager getWorkspaceManager() {
            return this.getResourceManager();
        }

        @Override
        public boolean isRemovable(ViewpointElement element) {
            if (this.getResourceManager().isReadOnly()) {
                return false;
            }
            return EcoreUtil.getRootContainer((EObject)element) instanceof Workspace;
        }

        protected List<ViewpointElement> computeElements(List<? extends ViewpointElement> initial, List<? extends ViewpointElement> toRemove, List<? extends ViewpointElement> toAdd) {
            HashMap<String, ViewpointElement> name2elt = new HashMap<String, ViewpointElement>();
            for (ViewpointElement viewpointElement : initial) {
                name2elt.put(this.getIdentifier(viewpointElement), viewpointElement);
            }
            if (toRemove != null) {
                for (ViewpointElement viewpointElement : toRemove) {
                    name2elt.remove(this.getIdentifier(viewpointElement));
                }
            }
            if (toAdd != null) {
                for (ViewpointElement viewpointElement : toAdd) {
                    name2elt.put(this.getIdentifier(viewpointElement), viewpointElement);
                }
            }
            return new ArrayList<ViewpointElement>(name2elt.values());
        }
    }
}

