/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.integration.rules;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.ElementDescriptor;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.JavaRule;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.RuleProvider;
import org.polarsys.kitalpha.ad.viewpoint.utils.ModelAccessor;

public class JavaRuleProvider
implements RuleProvider {
    private static final String EXTENSION_POINT_ID = "org.polarsys.kitalpha.ad.viewpoint.javarules";
    public static final String ID = "Java";

    private JavaRule getRule(String id) {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            try {
                if (id.equals(elt.getAttribute("class"))) {
                    return (JavaRule)elt.createExecutableExtension("class");
                }
            }
            catch (CoreException e) {
                AD_Log.getDefault().logError("Cannot create rule", (Throwable)e);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ElementDescriptor[] getAvailableImplementations() {
        IConfigurationElement[] configurationElements;
        HashSet<String> names = new HashSet<String>();
        HashSet<String> implementations = new HashSet<String>();
        ArrayList<ElementDescriptor> result = new ArrayList<ElementDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            String name = elt.getAttribute("name");
            String implementation = elt.getAttribute("class");
            if (name == null || implementation == null) {
                AD_Log.getDefault().logWarning("This javaRule contains null values (name:" + name + " class:" + implementation + ")");
            } else if (names.contains(name) || implementations.contains(implementation)) {
                AD_Log.getDefault().logWarning("A javaRule already exists with this name or class (name:" + name + " class:" + implementation + ")");
            } else {
                names.add(name);
                implementations.add(implementation);
                result.add(new ElementDescriptor(name, implementation, elt.getContributor().getName()));
            }
            ++n2;
        }
        return result.toArray(new ElementDescriptor[result.size()]);
    }

    @Override
    public String getType() {
        return ID;
    }

    @Override
    public void execute(Rule rule, ModelAccessor properties, Object[] selection) {
        JavaRule jRule = this.getRule(rule.getImplementation());
        if (jRule == null) {
            AD_Log.getDefault().logWarning("Cannot find rule: " + rule.getImplementation());
        } else {
            jRule.run(properties, selection);
        }
    }

    @Override
    public boolean canExecute(Rule rule, ModelAccessor properties, Object[] selection) {
        String getImplementation = rule.getImplementation();
        if (getImplementation == null) {
            return false;
        }
        JavaRule jRule = this.getRule(getImplementation);
        if (jRule == null) {
            AD_Log.getDefault().logWarning("Cannot find rule: " + getImplementation);
            return false;
        }
        return jRule.canRun(properties, selection);
    }

    @Override
    public boolean hasProvider(Bundle bundle) {
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(bundle.getSymbolicName());
        if (model == null) {
            return false;
        }
        IPluginExtension[] iPluginExtensionArray = model.getExtensions().getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if (EXTENSION_POINT_ID.equals(extension.getPoint())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

