/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.refinement.scenarios.core.ScenarioRefinement;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;

public class RefinementTargeted
extends ScenarioRefinement {
    public RefinementTargeted(Scenario srcDiagram, ComponentArchitecture arch) {
        super(srcDiagram, (NamedElement)arch, arch.eContainer() instanceof LogicalComponent);
    }

    public RefinementTargeted(Scenario srcDiagram, Part part) {
        super(srcDiagram, (NamedElement)part, true);
    }

    public RefinementTargeted(Scenario srcDiagram, Component component) {
        super(srcDiagram, (NamedElement)component, true);
    }

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        super.execute(progressMonitor);
        NamedElement tgt = this.getTarget();
        NamedElement elt = (NamedElement)this.getResult();
        this.applyNamingRule(elt, tgt);
        this.processReferencedScenario(progressMonitor);
    }

    protected void processReferencedScenario(IProgressMonitor progressMonitor) {
        for (TimeLapse timeLapse : this._srcDiagram.getOwnedTimeLapses()) {
            InteractionUse interactionUse;
            Scenario sc;
            if (!(timeLapse instanceof InteractionUse) || this._isIntraLayerRefinement && !this.isInteracting((InteractionUse)timeLapse, this._tgtElement) || (sc = ((InteractionUse)timeLapse).getReferencedScenario()) == null) continue;
            RefinementTargeted ref = null;
            if (this._tgtElement instanceof ComponentArchitecture) {
                ref = new RefinementTargeted(sc, (ComponentArchitecture)this._tgtElement);
            } else if (this._tgtElement instanceof Component) {
                ref = new RefinementTargeted(sc, (Component)this._tgtElement);
            } else if (this._tgtElement instanceof Part) {
                ref = new RefinementTargeted(sc, (Part)this._tgtElement);
            }
            if (ref == null || sc.equals(this._srcDiagram) || !sc.getKind().equals((Object)ScenarioKind.INTERFACE)) continue;
            ref.execute(progressMonitor);
            Object refinedScenario = ref.getResult();
            if (!(refinedScenario instanceof Scenario) || (interactionUse = (InteractionUse)CapellaElementExt.getRefinementSrcElement((CapellaElement)timeLapse, (EClass)InteractionPackage.Literals.INTERACTION_USE, (EObject)this._tgtDiagram)) == null) continue;
            interactionUse.setReferencedScenario((Scenario)refinedScenario);
        }
    }
}

