/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.projection.commands.Messages;
import org.polarsys.capella.core.projection.common.AbstractTransform;

public abstract class AbstractTransitionCommand
extends AbstractReadWriteCommand {
    protected Collection<EObject> _rootElements = null;
    private IProgressMonitor _progressMonitor = null;

    public String getName() {
        return Messages.transition_title;
    }

    public AbstractTransitionCommand(Collection<EObject> rootElements_p) {
        this(rootElements_p, (IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractTransitionCommand(Collection<EObject> rootElements_p, IProgressMonitor progressMonitor_p) {
        this._rootElements = rootElements_p;
        this._progressMonitor = progressMonitor_p;
    }

    protected Collection<EObject> retrieveModelElements(EObject modelElement_p) {
        return Collections.singleton(modelElement_p);
    }

    protected abstract AbstractTransform getTransformation(EObject var1);

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            if (this._rootElements != null && this._rootElements.size() > 0) {
                ArrayList<EObject> elements = new ArrayList<EObject>();
                for (EObject rootElement : this._rootElements) {
                    elements.addAll(this.retrieveModelElements(rootElement));
                }
                this._progressMonitor.beginTask(String.valueOf(this.getName()) + Messages.transition_processing, elements.size());
                for (EObject relatedElement : elements) {
                    AbstractTransform transform;
                    if (relatedElement != null && (transform = this.getTransformation(relatedElement)) != null) {
                        transform.setContext(relatedElement);
                        transform.execute();
                    }
                    this._progressMonitor.worked(1);
                }
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
            }
            catch (PartInitException e) {
                CapellaActionsActivator.getDefault().log(4, e.getMessage(), (Throwable)e);
            }
        }
    }
}

