/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.core.properties.fields.FeatureBooleanPropertiesCheckbox;
import org.polarsys.capella.core.data.core.properties.fields.VisibilityKindGroup;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.properties.Messages;
import org.polarsys.capella.core.data.information.properties.controllers.MultiplicityElementLengthController;
import org.polarsys.capella.core.data.information.properties.controllers.MultiplicityElementValueController;
import org.polarsys.capella.core.data.information.properties.fields.AggregationKindGroup;
import org.polarsys.capella.core.data.information.properties.fields.PropertyBooleanPropertiesCheckbox;
import org.polarsys.capella.core.data.information.properties.sections.MultiplicityElementSection;
import org.polarsys.capella.core.ui.properties.controllers.ISimpleEditableSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleEditableSemanticField;

public class PropertySection
extends MultiplicityElementSection {
    private FeatureBooleanPropertiesCheckbox featureBooleanPropertiesCheckbox;
    private PropertyBooleanPropertiesCheckbox propertyBooleanPropertiesCheckbox;
    private VisibilityKindGroup visibilityKindGroup;
    private AggregationKindGroup aggregationKindGroup;
    private SimpleEditableSemanticField minValueField;
    private SimpleEditableSemanticField maxValueField;
    private SimpleEditableSemanticField defaultValueField;
    private SimpleEditableSemanticField nullValueField;
    private SimpleEditableSemanticField minLengthField;
    private SimpleEditableSemanticField maxLengthField;

    public PropertySection() {
        super(true, true, true, true);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this.featureBooleanPropertiesCheckbox = new FeatureBooleanPropertiesCheckbox((Composite)this.getCheckGroup(), this.getWidgetFactory());
        this.featureBooleanPropertiesCheckbox.setDisplayedInWizard(displayedInWizard);
        this.propertyBooleanPropertiesCheckbox = new PropertyBooleanPropertiesCheckbox((Composite)this.getCheckGroup(), this.getWidgetFactory());
        this.propertyBooleanPropertiesCheckbox.setDisplayedInWizard(displayedInWizard);
        this.aggregationKindGroup = new AggregationKindGroup(this._rootParentComposite, this.getWidgetFactory());
        this.aggregationKindGroup.setDisplayedInWizard(displayedInWizard);
        this.minValueField = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("MultiplicityElement.MinValueLabel"), this.getWidgetFactory(), "", (ISimpleEditableSemanticFieldController)new MultiplicityElementValueController());
        this.minValueField.setDisplayedInWizard(displayedInWizard);
        this.maxValueField = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("MultiplicityElement.MaxValueLabel"), this.getWidgetFactory(), "", (ISimpleEditableSemanticFieldController)new MultiplicityElementValueController());
        this.maxValueField.setDisplayedInWizard(displayedInWizard);
        this.defaultValueField = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("MultiplicityElement.DefaultValueLabel"), this.getWidgetFactory(), "", (ISimpleEditableSemanticFieldController)new MultiplicityElementValueController());
        this.defaultValueField.setDisplayedInWizard(displayedInWizard);
        this.nullValueField = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("MultiplicityElement.NullValueLabel"), this.getWidgetFactory(), "", (ISimpleEditableSemanticFieldController)new MultiplicityElementValueController());
        this.nullValueField.setDisplayedInWizard(displayedInWizard);
        this.minLengthField = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("MultiplicityElement.MinLengthLabel"), this.getWidgetFactory(), "", (ISimpleEditableSemanticFieldController)new MultiplicityElementLengthController(), true, 2);
        this.minLengthField.setDisplayedInWizard(displayedInWizard);
        this.maxLengthField = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("MultiplicityElement.MaxLengthLabel"), this.getWidgetFactory(), "", (ISimpleEditableSemanticFieldController)new MultiplicityElementLengthController(), true, 3);
        this.maxLengthField.setDisplayedInWizard(displayedInWizard);
        this.visibilityKindGroup = new VisibilityKindGroup(this._rootParentComposite, this.getWidgetFactory());
        this.visibilityKindGroup.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.featureBooleanPropertiesCheckbox.loadData(capellaElement);
        this.propertyBooleanPropertiesCheckbox.loadData(capellaElement);
        this.visibilityKindGroup.loadData(capellaElement, (EStructuralFeature)CapellacorePackage.eINSTANCE.getFeature_Visibility());
        this.aggregationKindGroup.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getProperty_AggregationKind());
        this.minValueField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getMultiplicityElement_OwnedMinValue());
        this.maxValueField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getMultiplicityElement_OwnedMaxValue());
        this.defaultValueField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getMultiplicityElement_OwnedDefaultValue());
        this.nullValueField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getMultiplicityElement_OwnedNullValue());
        this.minLengthField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getMultiplicityElement_OwnedMinLength());
        this.maxLengthField.loadData(capellaElement, (EStructuralFeature)InformationPackage.eINSTANCE.getMultiplicityElement_OwnedMaxLength());
        this.evaluateButtonStatus((Property)capellaElement);
    }

    protected void evaluateButtonStatus(Property property) {
        if (property != null) {
            AbstractType type = property.getAbstractType();
            if (type != null) {
                if (type instanceof DataType) {
                    this.aggregationKindGroup.setEnabled(false);
                } else {
                    this.aggregationKindGroup.setEnabled(true);
                }
                if (type instanceof StringType) {
                    this.minLengthField.setEnabled(true);
                    this.maxLengthField.setEnabled(true);
                } else {
                    this.minLengthField.setEnabled(false);
                    this.maxLengthField.setEnabled(false);
                }
            } else {
                this.aggregationKindGroup.setEnabled(true);
                this.minLengthField.setEnabled(false);
                this.maxLengthField.setEnabled(false);
            }
        }
    }

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest != null && eObjectToTest.eClass() == InformationPackage.eINSTANCE.getProperty() && eObjectToTest.eClass() != InformationPackage.eINSTANCE.getUnionProperty();
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.aggregationKindGroup);
        fields.add((AbstractSemanticField)this.defaultValueField);
        fields.add((AbstractSemanticField)this.featureBooleanPropertiesCheckbox);
        fields.add((AbstractSemanticField)this.maxLengthField);
        fields.add((AbstractSemanticField)this.maxValueField);
        fields.add((AbstractSemanticField)this.minLengthField);
        fields.add((AbstractSemanticField)this.minValueField);
        fields.add((AbstractSemanticField)this.nullValueField);
        fields.add((AbstractSemanticField)this.propertyBooleanPropertiesCheckbox);
        fields.add((AbstractSemanticField)this.visibilityKindGroup);
        return fields;
    }
}

