/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;

public class MigrationJob
extends WorkspaceJob {
    public static final QualifiedName RESULT_PROPERTY = new QualifiedName("org.polarsys.capella.core.data.migration", "result");
    private MigrationContext _context;
    private AbstractMigrationRunnable _runnable;
    private boolean _checkVersion;

    public MigrationJob(AbstractMigrationRunnable runnable, MigrationContext context, boolean checkVersion) {
        super(context.getName());
        this._context = context;
        this._runnable = runnable;
        this._checkVersion = checkVersion;
        this.setRule((ISchedulingRule)runnable.getFile().getProject().getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), 100);
        try {
            IStatus result = this._runnable.run(this._context, this._checkVersion);
            if (result.isOK()) {
                try {
                    this._runnable.getFile().getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                }
                catch (CoreException exception) {
                    result = new Status(4, "org.polarsys.capella.core.data.migration", exception.getMessage(), (Throwable)exception);
                }
            }
            this.setProperty(RESULT_PROPERTY, result);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
            this._runnable = null;
            this._context = null;
        }
    }
}

