/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.commands.registry.WorkflowType;
import org.polarsys.kitalpha.model.common.commands.runner.ModelCommandRunner;
import org.polarsys.kitalpha.model.detachment.ui.Activator;
import org.polarsys.kitalpha.model.detachment.ui.Messages;
import org.polarsys.kitalpha.model.detachment.ui.page.AbstractDetachmentFormPage;
import org.polarsys.kitalpha.model.detachment.ui.registry.ModelDetachmentPageRegistry;

public class ModelDetachment
extends SharedHeaderFormEditor {
    Logger LOGGER = Logger.getLogger(ModelDetachment.class);
    private Action perfomDetachment;
    private static ModelDetachment editor;

    public ModelDetachment() {
        editor = this;
    }

    public void initAndLaunchDetachmentAction(final Resource resource) {
        if (this.perfomDetachment == null) {
            this.perfomDetachment = new Action(){

                public void run() {
                    final ModelCommandRunner actionRunner = new ModelCommandRunner();
                    final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    boolean canPerform = MessageDialog.openQuestion((Shell)shell, (String)Messages.QUESTION_DIALOG_TITLE, (String)Messages.QUESTION_IN_DIALOG);
                    if (canPerform) {
                        try {
                            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        monitor.setCanceled(false);
                                        EnumSet<WorkflowType> workflows = EnumSet.of(WorkflowType.ALL, WorkflowType.DETACHMENT);
                                        actionRunner.run(resource, workflows, monitor);
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                MessageDialog.openConfirm((Shell)shell, (String)Messages.CONFIRM_DIALOG_TITLE, (String)Messages.FINISH_DETACHMENT_MESSAGE);
                                                ModelDetachment.this.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
                                            }
                                        });
                                    }
                                    catch (ModelCommandException e) {
                                        Display.getDefault().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                Status status = new Status(4, "org.polarsys.kitalpha.model.detachment.ui", e.getMessage(), (Throwable)e);
                                                ErrorDialog.openError((Shell)shell, (String)Messages.ERROR_DIALOG_TITLE, (String)e.getMessage(), (IStatus)status);
                                                ((this).this).ModelDetachment.this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                            }
                                        });
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                            ModelDetachment.this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            ModelDetachment.this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            this.perfomDetachment.setToolTipText(Messages.PERFORM_DETACHMENT);
            this.perfomDetachment.setText(Messages.PERFORM_DETACHMENT);
            String IMG_PATH = "icons/run_detach.png";
            Bundle currentBundle = Activator.getDefault().getBundle();
            URL url = FileLocator.find((Bundle)currentBundle, (IPath)new Path(IMG_PATH), null);
            this.perfomDetachment.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
            this.getHeaderForm().getForm().getForm().getToolBarManager().add((IAction)this.perfomDetachment);
            this.getHeaderForm().getForm().getForm().getToolBarManager().update(true);
            this.getHeaderForm().getForm().getForm().setToolBarVerticalAlignment(131072);
            this.getHeaderForm().reflow(true);
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        FormToolkit tk = headerForm.getToolkit();
        tk.decorateFormHeading(headerForm.getForm().getForm());
        headerForm.getForm().getForm().setText(Messages.HEADER_EDITOR_TITLE);
        this.getHeaderForm().getForm().getForm().getToolBarManager().update(true);
    }

    protected void addPages() {
        Set<AbstractDetachmentFormPage> pageRegistry = ModelDetachmentPageRegistry.INSTANCE.initRegistry((IEditorPart)this);
        ArrayList<AbstractDetachmentFormPage> sortedPages = new ArrayList<AbstractDetachmentFormPage>(pageRegistry);
        Collections.sort(sortedPages, new Comparator<AbstractDetachmentFormPage>(){

            @Override
            public int compare(AbstractDetachmentFormPage arg0, AbstractDetachmentFormPage arg1) {
                return arg0.getPartName().compareTo(arg1.getPartName());
            }
        });
        for (AbstractDetachmentFormPage detachmentPage : sortedPages) {
            try {
                this.addPage((IFormPage)detachmentPage);
            }
            catch (PartInitException e) {
                this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }
}

