/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class Cloner {
    protected static Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    private Cloner() {
    }

    public static Object clone(EObject sourceElement, ITransfo transfo, List<AbstractTrace> transfoLinkList) throws TransfoException {
        List<EObject> sourceElementList = Cloner.findElements(sourceElement, transfo);
        Cloner.transform(sourceElementList, transfo, transfoLinkList);
        Cloner.update(sourceElementList, transfo);
        Cloner.attach(sourceElementList, transfo);
        Object targetElement = Query.retrieveTransformedElement(sourceElement, transfo);
        return targetElement;
    }

    protected static List<EObject> findElements(EObject sourceElement, ITransfo transfo) {
        ArrayList<EObject> elementsToBeCloned = new ArrayList<EObject>();
        ArrayList<EObject> agenda = new ArrayList<EObject>();
        agenda.add(sourceElement);
        while (!agenda.isEmpty()) {
            EObject currentElement = (EObject)agenda.get(0);
            if (!elementsToBeCloned.contains(currentElement)) {
                elementsToBeCloned.add(currentElement);
            }
            List<EObject> relatedElements = Cloner.retrieveRelatedElementsForClone(currentElement);
            agenda.remove(currentElement);
            for (EObject relatedElement : relatedElements) {
                if (!Cloner.isContainedBy(relatedElement, sourceElement)) continue;
                agenda.add(relatedElement);
            }
            if (Collections.disjoint(agenda, elementsToBeCloned)) continue;
            agenda.removeAll(elementsToBeCloned);
        }
        return elementsToBeCloned;
    }

    protected static void transform(List<EObject> sourceElementList, ITransfo transfo, List<AbstractTrace> transfoLinkList) throws TransfoException {
        for (EObject sourceElement : sourceElementList) {
            EClass clazz;
            EObject targetElement;
            AbstractTrace transfoLink;
            if (Query.isElementTransformed(sourceElement, transfo) || (transfoLink = TigerRelationshipHelper.createTransfoLink(sourceElement, targetElement = CapellacommonFactory.eINSTANCE.create(clazz = sourceElement.eClass()), transfo)) == null) continue;
            transfoLinkList.add(transfoLink);
        }
    }

    protected static void update(List<EObject> sourceElementList, ITransfo transfo) {
        for (EObject sourceElement : sourceElementList) {
            EClass clazz = sourceElement.eClass();
            Object targetElement = Query.retrieveTransformedElement(sourceElement, transfo);
            if (!(targetElement instanceof EObject)) continue;
            EObject targetElement2 = (EObject)targetElement;
            EList attributes = clazz.getEAllAttributes();
            for (EAttribute attribute : attributes) {
                if (!Cloner.isClonableFeature((EStructuralFeature)attribute) || attribute.isID()) continue;
                Object value = sourceElement.eGet((EStructuralFeature)attribute);
                targetElement2.eSet((EStructuralFeature)attribute, value);
            }
        }
    }

    protected static void attach(List<EObject> sourceElementList, ITransfo transfo) {
        for (EObject sourceElement : sourceElementList) {
            EClass clazz = sourceElement.eClass();
            EList features = clazz.getEAllStructuralFeatures();
            for (EStructuralFeature feature : features) {
                if (!Cloner.isClonableFeature(feature)) continue;
                TigerRelationshipHelper.attachTransformedRelatedElements(sourceElement, transfo, (EReference)feature);
            }
        }
    }

    protected static List<EObject> retrieveRelatedElementsForClone(EObject element) {
        EClass clazz = element.eClass();
        ArrayList<EObject> relatedElements = new ArrayList<EObject>();
        EList features = clazz.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            try {
                if (!Cloner.isClonableFeature(feature)) continue;
                Object obj = element.eGet(feature);
                if (obj instanceof EObject) {
                    EObject eObject = (EObject)obj;
                    relatedElements.add(eObject);
                    continue;
                }
                if (!(obj instanceof EList)) continue;
                relatedElements.addAll((Collection<EObject>)((EList)obj));
            }
            catch (Exception e) {
                _logger.error((Object)("   + Cancel feature " + feature.getName() + " on " + element.eClass().getName() + " while cloning."), (Throwable)e);
            }
        }
        return relatedElements;
    }

    protected static boolean isClonableFeature(EStructuralFeature feature) {
        return !feature.isUnsettable() && !feature.isDerived() && !feature.isVolatile() && !feature.isTransient();
    }

    protected static boolean isContainedBy(EObject object, EObject container) {
        if (object == container) {
            return true;
        }
        boolean found = false;
        EObject currentElement = object.eContainer();
        while (currentElement != null && !found) {
            found = currentElement == container;
            currentElement = currentElement.eContainer();
        }
        return found;
    }
}

