/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.helpers;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.tiger.helpers.ContextQuery;

public class ScenarioHelper {
    public static void retrieveFilteredScenario(Scenario scenario, Component systemComponent, List<Component> componentList, List<InstanceRole> filteredInstanceRoleList, List<SequenceMessage> filteredMessages, List<AbstractEnd> filteredAbstractEndList, List<TimeLapse> filteredExecutionList, List<Event> filteredEventList) {
        List<Part> externalComponentInstanceList = ContextQuery.findComponentInstanceList(componentList);
        List<Part> systemComponentInstanceList = ContextQuery.findComponentInstanceList(systemComponent);
        EList abstractEnds = scenario.getOwnedInteractionFragments();
        EList executions = scenario.getOwnedTimeLapses();
        for (InteractionFragment interactionFragment : abstractEnds) {
            ExecutionEnd executionEnd;
            Execution execution;
            InstanceRole instanceRole;
            MessageEnd messageEnd;
            SequenceMessage sequenceMessage;
            AbstractEnd abstractEnd;
            AbstractInstance componentInstance;
            if (!(interactionFragment instanceof AbstractEnd) || !externalComponentInstanceList.contains(componentInstance = (abstractEnd = (AbstractEnd)interactionFragment).getCovered().getRepresentedInstance()) && !systemComponentInstanceList.contains(componentInstance)) continue;
            if (abstractEnd instanceof MessageEnd && ScenarioHelper.isSequenceMessageInvolvedInInteraction(sequenceMessage = (messageEnd = (MessageEnd)abstractEnd).getMessage(), systemComponentInstanceList, externalComponentInstanceList)) {
                filteredAbstractEndList.add(abstractEnd);
                filteredEventList.add(abstractEnd.getEvent());
                if (!filteredMessages.contains(sequenceMessage)) {
                    filteredMessages.add(sequenceMessage);
                }
                if (!filteredInstanceRoleList.contains(instanceRole = messageEnd.getCovered())) {
                    filteredInstanceRoleList.add(instanceRole);
                }
            }
            if (!(abstractEnd instanceof ExecutionEnd) || !ScenarioHelper.isExecutionInvolvedInInteraction(execution = (executionEnd = (ExecutionEnd)abstractEnd).getExecution(), systemComponentInstanceList, externalComponentInstanceList)) continue;
            filteredAbstractEndList.add((AbstractEnd)executionEnd);
            filteredEventList.add(executionEnd.getEvent());
            instanceRole = executionEnd.getCovered();
            if (filteredInstanceRoleList.contains(instanceRole)) continue;
            filteredInstanceRoleList.add(instanceRole);
        }
        for (TimeLapse execution : executions) {
            InteractionFragment startEnd = execution.getStart();
            InteractionFragment finishEnd = execution.getFinish();
            if (!filteredAbstractEndList.contains(startEnd) || !filteredAbstractEndList.contains(finishEnd) || filteredExecutionList.contains(execution)) continue;
            filteredExecutionList.add(execution);
        }
    }

    private static boolean isSequenceMessageInvolvedInInteraction(SequenceMessage sequenceMessage, List<Part> systemComponentInstanceList, List<Part> externalComponentInstanceList) {
        AbstractInstance sendingComponentInstance = sequenceMessage.getSendingEnd().getCovered().getRepresentedInstance();
        AbstractInstance receivingComponentInstance = sequenceMessage.getReceivingEnd().getCovered().getRepresentedInstance();
        return externalComponentInstanceList.contains(sendingComponentInstance) && systemComponentInstanceList.contains(receivingComponentInstance) || externalComponentInstanceList.contains(receivingComponentInstance) && systemComponentInstanceList.contains(sendingComponentInstance);
    }

    private static boolean isExecutionInvolvedInInteraction(Execution execution, List<Part> systemComponentInstanceList, List<Part> externalComponentInstanceList) {
        MessageEnd messageEnd;
        SequenceMessage message;
        boolean isInvolved = true;
        InteractionFragment startEnd = execution.getStart();
        InteractionFragment finishEnd = execution.getFinish();
        if (startEnd instanceof MessageEnd && !ScenarioHelper.isSequenceMessageInvolvedInInteraction(message = (messageEnd = (MessageEnd)startEnd).getMessage(), systemComponentInstanceList, externalComponentInstanceList)) {
            isInvolved = false;
        }
        if (finishEnd instanceof MessageEnd && !ScenarioHelper.isSequenceMessageInvolvedInInteraction(message = (messageEnd = (MessageEnd)finishEnd).getMessage(), systemComponentInstanceList, externalComponentInstanceList)) {
            isInvolved = false;
        }
        return isInvolved;
    }
}

