/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.IState;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.DeepHistoryPseudoState;
import org.polarsys.capella.core.data.capellacommon.EntryPointPseudoState;
import org.polarsys.capella.core.data.capellacommon.ExitPointPseudoState;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.ForkPseudoState;
import org.polarsys.capella.core.data.capellacommon.InitialPseudoState;
import org.polarsys.capella.core.data.capellacommon.JoinPseudoState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Pseudostate;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.ShallowHistoryPseudoState;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacommon.TerminatePseudoState;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.ModellingBlock;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.StateExt;
import org.polarsys.capella.core.model.helpers.move.MoveHelper;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideSMStateMode;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideSMTransitions;

public class StateMachineServices {
    private static final String CHAR_X = "X";
    private static StateMachineServices _service;

    public static StateMachineServices getService() {
        if (_service == null) {
            _service = new StateMachineServices();
        }
        return _service;
    }

    public List<CapellaElement> getAllStatesAndModesFromBlockArchitecture(EObject context, BlockArchitecture arch) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        BlockArchitectureExt.getAllStatesAndModesFromBlockArchitecture((BlockArchitecture)arch, result);
        return result;
    }

    public List<CapellaElement> getAllStatesAndModesFromComponent(EObject context, Component comp) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        result.addAll(ComponentExt.getAllStatesAndModesFromComponent((Component)comp));
        return result;
    }

    public String displayCharX(EObject context, EObject colomn) {
        IState state;
        AbstractCapability cap;
        if (context != null && colomn != null && (context instanceof AbstractCapability ? (cap = (AbstractCapability)context).getAvailableInStates().contains((Object)colomn) : (context instanceof AbstractFunction ? (cap = (AbstractFunction)context).getAvailableInStates().contains((Object)colomn) : (context instanceof FunctionalChain ? (cap = (FunctionalChain)context).getAvailableInStates().contains((Object)colomn) : context instanceof IState && (state = (IState)context).getReferencedStates().contains((Object)colomn))))) {
            return CHAR_X;
        }
        return "";
    }

    public void inActiveAnElement(EObject context, EObject colomn) {
        if (context != null && colomn != null && colomn instanceof State) {
            FunctionalChain ele;
            EList availableInStates;
            if (context instanceof AbstractCapability) {
                AbstractCapability ele2 = (AbstractCapability)context;
                EList availableInStates2 = ele2.getAvailableInStates();
                if (!availableInStates2.isEmpty()) {
                    availableInStates2.remove((Object)colomn);
                }
            } else if (context instanceof AbstractFunction) {
                AbstractFunction ele3 = (AbstractFunction)context;
                EList availableInStates3 = ele3.getAvailableInStates();
                if (!availableInStates3.isEmpty()) {
                    availableInStates3.remove((Object)colomn);
                }
            } else if (context instanceof FunctionalChain && !(availableInStates = (ele = (FunctionalChain)context).getAvailableInStates()).isEmpty()) {
                availableInStates.remove((Object)colomn);
            }
        }
    }

    public void activeAnElement(EObject context, EObject colomn) {
        if (context != null && colomn != null && colomn instanceof State) {
            FunctionalChain ele;
            EList availableInStates;
            if (context instanceof AbstractCapability) {
                AbstractCapability ele2 = (AbstractCapability)context;
                EList availableInStates2 = ele2.getAvailableInStates();
                if (availableInStates2 != null) {
                    availableInStates2.add((Object)((State)colomn));
                }
            } else if (context instanceof AbstractFunction) {
                AbstractFunction ele3 = (AbstractFunction)context;
                EList availableInStates3 = ele3.getAvailableInStates();
                if (availableInStates3 != null) {
                    availableInStates3.add((Object)((State)colomn));
                }
            } else if (context instanceof FunctionalChain && (availableInStates = (ele = (FunctionalChain)context).getAvailableInStates()) != null) {
                availableInStates.add((Object)((State)colomn));
            }
        }
    }

    public List<EObject> getAllFunctionsActiveInStates(EObject context, IState ele) {
        List referencers = EObjectExt.getReferencers((EObject)ele, (EReference)FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES);
        return referencers;
    }

    public List<EObject> getAllCapabilitiesActiveInStates(EObject context, State ele) {
        List referencers = EObjectExt.getReferencers((EObject)ele, (EReference)InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
        return referencers;
    }

    public List<EObject> getAllFunctionalChainsActiveInStates(EObject context, IState ele) {
        List referencers = EObjectExt.getReferencers((EObject)ele, (EReference)FaPackage.Literals.FUNCTIONAL_CHAIN__AVAILABLE_IN_STATES);
        return referencers;
    }

    public EList<State> getAvailableStateAndMode(EObject context) {
        if (context != null) {
            if (context instanceof FunctionalChain) {
                FunctionalChain ele = (FunctionalChain)context;
                return ele.getAvailableInStates();
            }
            if (context instanceof AbstractFunction) {
                AbstractFunction ele = (AbstractFunction)context;
                return ele.getAvailableInStates();
            }
            if (context instanceof AbstractCapability) {
                AbstractCapability ele = (AbstractCapability)context;
                return ele.getAvailableInStates();
            }
        }
        return null;
    }

    public List<IState> getInvolvedStatesRecursively(EObject context) {
        ArrayList<IState> result = new ArrayList<IState>();
        if (context instanceof StateMachine) {
            for (Region subregion : ((StateMachine)context).getOwnedRegions()) {
                result.addAll(this.getInvolvedStatesRecursively((EObject)subregion));
            }
        }
        if (context instanceof Region) {
            Region region = (Region)context;
            for (IState state : region.getInvolvedStates()) {
                if (state instanceof Pseudostate) {
                    result.add(state);
                }
                if (!(state instanceof State)) continue;
                State asm = (State)state;
                result.add((IState)asm);
                for (Region subregion : asm.getOwnedRegions()) {
                    result.addAll(this.getInvolvedStatesRecursively((EObject)subregion));
                }
            }
        }
        if (context instanceof State) {
            State asm = (State)context;
            for (Region subregion : asm.getOwnedRegions()) {
                List<IState> subRegionStates = this.getInvolvedStatesRecursively((EObject)subregion);
                result.addAll(subRegionStates);
            }
        }
        return result;
    }

    public List<IState> getReferencableStates(EObject containerState) {
        ArrayList<IState> result = new ArrayList<IState>();
        EObject container = containerState.eContainer();
        while (!(container instanceof Block)) {
            container = container.eContainer();
        }
        Region currentRegion = null;
        currentRegion = containerState instanceof Region ? (Region)containerState : (Region)((State)containerState).getOwnedRegions().get(0);
        TreeIterator iter = currentRegion.eAllContents();
        IState referenceState = null;
        boolean hasShallowHystoryPseudoState = false;
        boolean hasDeepHystoryPseudoState = false;
        while (iter.hasNext()) {
            EObject type = (EObject)iter.next();
            if (type instanceof Mode || type instanceof State) {
                referenceState = (IState)type;
            }
            if (type instanceof ShallowHistoryPseudoState) {
                hasShallowHystoryPseudoState = true;
            }
            if (!(type instanceof DeepHistoryPseudoState)) continue;
            hasDeepHystoryPseudoState = true;
        }
        HashSet<State> parentExclusionList = new HashSet<State>();
        EObject currentParent = containerState;
        while (!(currentParent instanceof StateMachine)) {
            if (currentParent instanceof State) {
                parentExclusionList.add((State)currentParent);
            }
            currentParent = currentParent.eContainer();
        }
        Block block = (Block)container;
        for (StateMachine sm : block.getOwnedStateMachines()) {
            TreeIterator it = sm.eAllContents();
            while (it.hasNext()) {
                EObject type = (EObject)it.next();
                if (!(type instanceof IState) || parentExclusionList.contains(type)) continue;
                if (type instanceof Pseudostate && !(type instanceof ShallowHistoryPseudoState) && !(type instanceof DeepHistoryPseudoState)) {
                    result.add((IState)type);
                }
                if (type instanceof ShallowHistoryPseudoState && !hasShallowHystoryPseudoState) {
                    result.add((IState)type);
                }
                if (type instanceof DeepHistoryPseudoState && !hasDeepHystoryPseudoState) {
                    result.add((IState)type);
                }
                if (referenceState != null && referenceState.eClass() != type.eClass() || type instanceof Pseudostate || type instanceof State && !MoveHelper.getInstance().canMoveModeState((State)type, currentRegion)) continue;
                result.add((IState)type);
            }
        }
        return result;
    }

    @Deprecated
    private boolean isPseudoStateCompatible(Pseudostate type, IState referenceState) {
        Region region = (Region)type.eContainer();
        if (referenceState == null) {
            return true;
        }
        for (IState currentState : region.getInvolvedStates()) {
            if (!(currentState instanceof State)) continue;
            State state = (State)currentState;
            return referenceState.eClass() == state.eClass();
        }
        return true;
    }

    public List<IState> getAllReferencedStatesInSM(StateMachine sm) {
        ArrayList<IState> result = new ArrayList<IState>();
        for (Region r : sm.getOwnedRegions()) {
            for (IState state : r.getOwnedStates()) {
                result.addAll(this.getAllReferencedStates(state));
            }
        }
        return result;
    }

    private List<IState> getAllReferencedStates(IState s) {
        ArrayList<IState> result = new ArrayList<IState>();
        result.add(s);
        for (IState iState : s.getReferencedStates()) {
            result.addAll(this.getAllReferencedStates(iState));
        }
        return result;
    }

    public List<IState> getStateReferenced(EObject context) {
        IState lineState = (IState)context;
        return lineState.getReferencedStates();
    }

    public boolean hasStateMachine(Component comp) {
        if (comp.getOwnedStateMachines().size() > 0) {
            return true;
        }
        Collection components = ComponentExt.getAllSubUsedComponents((Component)comp);
        for (Component component : components) {
            if (component.getOwnedStateMachines().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<Component> getSubComponentsWithStateMachine(EObject context) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (context instanceof Component) {
            Component component = (Component)context;
            for (Component sub : ComponentExt.getSubDefinedComponents((Component)component)) {
                if (!this.hasStateMachine(sub)) continue;
                result.add(sub);
            }
        }
        return result;
    }

    public List<AbstractCapability> getCapabilitiesForStateMatrix(ModellingBlock block) {
        ArrayList<AbstractCapability> result = new ArrayList<AbstractCapability>();
        EObject container = block.eContainer();
        if (container instanceof BlockArchitecture) {
            BlockArchitecture archi = (BlockArchitecture)container;
            return this.getCapabilitiesForStateMatrix(archi);
        }
        if (block instanceof SystemComponent) {
            SystemComponent component = (SystemComponent)block;
            for (Involvement involve : component.getInvolvingInvolvements()) {
                InvolverElement involver = involve.getInvolver();
                if (!(involver instanceof AbstractCapability)) continue;
                AbstractCapability ac = (AbstractCapability)involver;
                result.add(ac);
            }
            for (Component subComponent : ComponentExt.getSubDefinedComponents((Component)component)) {
                result.addAll(this.getCapabilitiesForStateMatrix((ModellingBlock)subComponent));
            }
        }
        return result;
    }

    public List<AbstractCapability> getCapabilitiesForStateMatrix(BlockArchitecture archi) {
        ArrayList<AbstractCapability> result = new ArrayList<AbstractCapability>();
        AbstractCapabilityPkg acp = archi.getOwnedAbstractCapabilityPkg();
        result.addAll(AbstractCapabilityPkgExt.getAllAbstractCapabilities((AbstractCapabilityPkg)acp));
        Component rootComponent = (Component)ComponentExt.getSubDefinedComponents((BlockArchitecture)archi).get(0);
        for (Component subComponent : ComponentExt.getSubDefinedComponents((Component)rootComponent)) {
            result.addAll(this.getCapabilitiesForStateMatrix((ModellingBlock)subComponent));
        }
        return result;
    }

    public List<AbstractFunction> getAbstractFunctionForStateModeMatrix(EObject obj) {
        if (obj instanceof Component) {
            return this.getAbstractFunctionForStateModeMatrix((Component)obj);
        }
        return this.getAbstractFunctionForStateModeMatrix(obj);
    }

    public List<AbstractFunction> getAbstractFunctionForStateModeMatrix(BlockArchitecture context) {
        Component component = (Component)ComponentExt.getSubDefinedComponents((BlockArchitecture)context).get(0);
        return this.getAbstractFunctionForStateModeMatrix(component);
    }

    private List<AbstractFunction> getAbstractFunctionForStateModeMatrix(Component component) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        result.addAll((Collection<AbstractFunction>)component.getAllocatedFunctions());
        for (Component subComponent : ComponentExt.getSubDefinedComponents((Component)component)) {
            result.addAll(this.getAbstractFunctionForStateModeMatrix(subComponent));
        }
        for (StateMachine sm : component.getOwnedStateMachines()) {
            for (IState state : this.getAllReferencedStatesInSM(sm)) {
                if (!(state instanceof State)) continue;
                State asm = (State)state;
                for (EObject abstractFunction : this.getAllFunctionsActiveInStates(null, (IState)asm)) {
                    if (!(abstractFunction instanceof AbstractFunction)) continue;
                    AbstractFunction af = (AbstractFunction)abstractFunction;
                    result.add(af);
                }
            }
        }
        return result;
    }

    public List<AbstractCapability> getCapabilityFromStateAndMode(EObject context, IState state) {
        ArrayList<AbstractCapability> result = new ArrayList<AbstractCapability>();
        List referencers = EObjectExt.getReferencers((EObject)state, (EReference)InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES);
        for (EObject eObject : referencers) {
            if (!(eObject instanceof AbstractCapability)) continue;
            AbstractCapability ac = (AbstractCapability)eObject;
            result.add(ac);
        }
        return result;
    }

    public static boolean isReferencedState(IState inputState, EObject container) {
        if (container != null) {
            Region region;
            if (container instanceof Region) {
                region = (Region)container;
            } else {
                State state = (State)container;
                region = (Region)state.getOwnedRegions().get(0);
            }
            return !region.getOwnedStates().contains((Object)inputState) && region.getInvolvedStates().contains((Object)inputState);
        }
        return false;
    }

    public Region getRegionForTransition(EObject context, DDiagramElement delement) {
        Region region = null;
        EObject container = delement.eContainer();
        if (!(container instanceof DDiagram)) {
            EObject obj = ((DNodeContainer)container).getTarget();
            State state = (State)obj;
            return (Region)state.getOwnedRegions().get(0);
        }
        region = (Region)((DSemanticDiagram)container).getTarget();
        return region;
    }

    public Region getRegionForInsertion(EObject context, EObject delement) {
        Region region = null;
        if (delement instanceof DDiagram) {
            region = (Region)((DSemanticDiagram)delement).getTarget();
        } else if (delement instanceof DDiagramElementContainer) {
            EObject obj = ((DNodeContainer)delement).getTarget();
            State state = (State)obj;
            return (Region)state.getOwnedRegions().get(0);
        }
        return region;
    }

    public List<IState> getInitialSelectionSM(EObject context) {
        ArrayList<IState> result = new ArrayList<IState>();
        if (context instanceof Region) {
            result.addAll((Collection<IState>)((Region)context).getInvolvedStates());
        } else {
            State state = (State)context;
            for (Region r : state.getOwnedRegions()) {
                result.addAll((Collection<IState>)r.getInvolvedStates());
            }
        }
        return result;
    }

    public boolean mustDisplayTransition(EObject context, EObject srcView, EObject tarView) {
        DDiagramElement sourceView = (DDiagramElement)srcView;
        DDiagramElement targetView = (DDiagramElement)tarView;
        DSemanticDecorator sourceContainer = (DSemanticDecorator)sourceView.eContainer();
        DSemanticDecorator targetContainer = (DSemanticDecorator)targetView.eContainer();
        EObject semanticContainer = sourceContainer.getTarget();
        EObject semanticTargetContainer = targetContainer.getTarget();
        boolean isCorrectContainer = false;
        boolean isCorrectTargetContainer = false;
        if (semanticContainer instanceof Region) {
            Region region = (Region)semanticContainer;
            isCorrectContainer = region.getOwnedTransitions().contains((Object)context);
            if (semanticTargetContainer instanceof State) {
                isCorrectTargetContainer = ((Region)((State)semanticTargetContainer).getOwnedRegions().get(0)).getOwnedStates().contains((Object)targetView.getTarget()) || sourceContainer == targetContainer;
            } else if (semanticTargetContainer instanceof Region) {
                Region targetRegion = (Region)semanticTargetContainer;
                isCorrectTargetContainer = targetRegion.getOwnedStates().contains((Object)targetView.getTarget()) || sourceContainer == targetContainer;
            }
        } else if (semanticContainer instanceof State) {
            State containerState = (State)semanticContainer;
            for (Region region : containerState.getOwnedRegions()) {
                if (!region.getOwnedTransitions().contains((Object)context)) continue;
                isCorrectContainer = true;
            }
            if (semanticTargetContainer instanceof State) {
                isCorrectTargetContainer = ((Region)((State)semanticTargetContainer).getOwnedRegions().get(0)).getOwnedStates().contains((Object)targetView.getTarget()) || sourceContainer == targetContainer;
            } else if (semanticTargetContainer instanceof Region) {
                Region region;
                region = (Region)semanticTargetContainer;
                boolean bl = isCorrectTargetContainer = region.getOwnedStates().contains((Object)targetView.getTarget()) || sourceContainer == targetContainer;
            }
        }
        return isCorrectContainer && isCorrectTargetContainer && this.isUndoublonLink((DSemanticDecorator)srcView, (DSemanticDecorator)tarView);
    }

    protected LinkedList<EObject> getParents(EObject object, EClass clazz) {
        LinkedList<EObject> parents = new LinkedList<EObject>();
        EObject current = object;
        if (current == null) {
            return parents;
        }
        current = current.eContainer();
        while (current != null && !clazz.isInstance((Object)current)) {
            parents.addLast(current);
            current = current.eContainer();
        }
        return parents;
    }

    private boolean isUndoublonLink(DSemanticDecorator sourceElement, DSemanticDecorator targetElement) {
        boolean valid = true;
        LinkedList<EObject> sourceParents = this.getParents((EObject)sourceElement, DiagramPackage.Literals.DDIAGRAM);
        LinkedList<EObject> targetParents = this.getParents((EObject)targetElement, DiagramPackage.Literals.DDIAGRAM);
        sourceParents.remove(sourceElement);
        targetParents.remove(targetElement);
        HashSet<EObject> targetParentSet = new HashSet<EObject>(targetParents);
        Object current = null;
        if (!sourceParents.isEmpty()) {
            current = sourceParents.removeLast();
            while (current != null && targetParentSet.contains(current)) {
                current = sourceParents.size() > 0 ? sourceParents.removeLast() : null;
            }
        }
        if (current != null) {
            if (current instanceof DDiagramElement) {
                for (DSemanticDecorator dSemanticDecorator : DiagramServices.getDiagramServices().getDiagramElements((EObject)((DDiagramElement)current))) {
                    if (dSemanticDecorator.getTarget() == null || !dSemanticDecorator.getTarget().equals(targetElement.getTarget())) continue;
                    valid = false;
                }
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public boolean canCreateMode(EObject context, EObject containerView) {
        Region testedRegion = this.getRegionFromView(containerView);
        if (testedRegion != null) {
            if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
                return MoveHelper.getInstance().canMoveModeState((State)CapellacommonFactory.eINSTANCE.createMode(), testedRegion);
            }
            for (IState iState : this.getStatesOfRegion(testedRegion)) {
                if (!(iState instanceof State) || iState instanceof Mode || iState instanceof FinalState) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canCreateDeepHistory(EObject context, EObject containerView) {
        Region testedRegion = this.getRegionFromView(containerView);
        if (testedRegion != null && !(testedRegion.eContainer() instanceof StateMachine)) {
            for (AbstractState state : testedRegion.getOwnedStates()) {
                if (!(state instanceof DeepHistoryPseudoState)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canCreateEntryExitPoint(EObject context, EObject containerView) {
        Region testedRegion = this.getRegionFromView(containerView);
        return testedRegion != null && !(testedRegion.eContainer() instanceof StateMachine);
    }

    public boolean canCreateShallowHistory(EObject context, EObject containerView) {
        Region testedRegion = this.getRegionFromView(containerView);
        if (testedRegion != null && !(testedRegion.eContainer() instanceof StateMachine)) {
            for (AbstractState state : testedRegion.getOwnedStates()) {
                if (!(state instanceof ShallowHistoryPseudoState)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Region getRegionFromView(EObject containerView) {
        Region testedRegion = null;
        if (containerView instanceof DSemanticDecorator) {
            DSemanticDecorator dd = (DSemanticDecorator)containerView;
            EObject testedElement = dd.getTarget();
            if (testedElement instanceof Region) {
                testedRegion = (Region)testedElement;
            } else if (testedElement instanceof State) {
                State state = (State)testedElement;
                testedRegion = StateExt.getPrimaryRegion((State)state, (boolean)false);
            }
        }
        return testedRegion;
    }

    public boolean canCreateState(EObject context, EObject containerView) {
        Region testedRegion = this.getRegionFromView(containerView);
        if (testedRegion != null) {
            if (!CapellaModelPreferencesPlugin.getDefault().isMixedModeStateAllowed()) {
                return MoveHelper.getInstance().canMoveModeState(CapellacommonFactory.eINSTANCE.createState(), testedRegion);
            }
            for (IState iState : this.getStatesOfRegion(testedRegion)) {
                if (!(iState instanceof Mode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Collection<AbstractState> getStatesOfRegion(Region testedRegion) {
        return testedRegion.getInvolvedStates();
    }

    public List<StateTransition> getDisplayedTransitions(DSemanticDecorator view) {
        ArrayList<StateTransition> returnedList = new ArrayList<StateTransition>();
        for (DEdge aView : this.getDisplayedTransitionViews(view)) {
            returnedList.add((StateTransition)aView.getTarget());
        }
        return returnedList;
    }

    public List<DEdge> getDisplayedTransitionViews(DSemanticDecorator view) {
        ArrayList<DEdge> returnedList = new ArrayList<DEdge>();
        if (view instanceof DDiagram) {
            DDiagram diagram = (DDiagram)view;
            for (DEdge edge : diagram.getEdges()) {
                if (edge.getTarget() == null || !(edge.getTarget() instanceof StateTransition)) continue;
                returnedList.add(edge);
            }
        }
        if (view instanceof DNodeContainer) {
            DNodeContainer currentContainer = (DNodeContainer)view;
            for (DEdge edge : currentContainer.getIncomingEdges()) {
                if (edge.getTarget() == null || !(edge.getTarget() instanceof StateTransition)) continue;
                returnedList.add(edge);
            }
            for (DEdge edge : currentContainer.getOutgoingEdges()) {
                if (edge.getTarget() == null || !(edge.getTarget() instanceof StateTransition)) continue;
                returnedList.add(edge);
            }
        }
        return returnedList;
    }

    public List<State> getDisplayedStates(DSemanticDecorator view) {
        ArrayList<State> returnedList = new ArrayList<State>();
        for (AbstractDNode aView : this.getDisplayedStateViews(view)) {
            returnedList.add((State)aView.getTarget());
        }
        return returnedList;
    }

    public List<IState> getAllDisplayedStates(DSemanticDecorator view) {
        ArrayList<IState> returnedList = new ArrayList<IState>();
        for (AbstractDNode aView : this.getAllDisplayedStateViews(view)) {
            returnedList.add((IState)aView.getTarget());
        }
        return returnedList;
    }

    public List<IState> getDisplayedPseudoStates(DSemanticDecorator view) {
        ArrayList<IState> returnedList = new ArrayList<IState>();
        for (AbstractDNode aView : this.getDisplayedPseudoStateViews(view)) {
            returnedList.add((IState)((State)aView.getTarget()));
        }
        return returnedList;
    }

    public List<AbstractDNode> getDisplayedStateViews(DSemanticDecorator view) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        if (view instanceof DDiagram) {
            DDiagram diagram = (DDiagram)view;
            for (AbstractDNode aContainer : diagram.getContainers()) {
                if (aContainer.getTarget() == null || !(aContainer.getTarget() instanceof IState)) continue;
                returnedList.add(aContainer);
            }
        }
        if (view instanceof DNodeContainer) {
            DNodeContainer currentContainer = (DNodeContainer)view;
            for (AbstractDNode aContainer : currentContainer.getContainers()) {
                if (aContainer.getTarget() == null || !(aContainer.getTarget() instanceof IState)) continue;
                returnedList.add(aContainer);
            }
        }
        return returnedList;
    }

    public List<AbstractDNode> getDisplayedPseudoStateViews(DSemanticDecorator view) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        if (view instanceof DDiagram) {
            DDiagram diagram = (DDiagram)view;
            for (AbstractDNode node : diagram.getNodes()) {
                if (node.getTarget() == null || !(node.getTarget() instanceof IState)) continue;
                returnedList.add(node);
            }
        }
        if (view instanceof DNodeContainer) {
            DNodeContainer currentContainer = (DNodeContainer)view;
            for (AbstractDNode node : currentContainer.getNodes()) {
                if (node.getTarget() == null || !(node.getTarget() instanceof IState)) continue;
                returnedList.add(node);
            }
        }
        return returnedList;
    }

    public List<AbstractDNode> getAllDisplayedStateViews(DSemanticDecorator view) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        List<AbstractDNode> displayedStateViews = this.getDisplayedStateViews(view);
        List<AbstractDNode> displayedPseudoStateViews = this.getDisplayedPseudoStateViews(view);
        returnedList.addAll(displayedStateViews);
        returnedList.addAll(displayedPseudoStateViews);
        return returnedList;
    }

    public List<IState> getAvailableStatesAndModesToInsertInStatemachineDiag(DSemanticDecorator current) {
        ArrayList<IState> stateAndModeList = new ArrayList<IState>();
        EObject target = current.getTarget();
        if (current instanceof DDiagram && target instanceof Region) {
            stateAndModeList.addAll(this.getInvolvedStatesRecursively(target));
        }
        Pseudostate currentState = null;
        if (target != null && current instanceof DNodeContainer && target instanceof State) {
            State state = (State)target;
            List<IState> involvedStates = this.getInvolvedStatesRecursively((EObject)state);
            stateAndModeList.addAll(involvedStates);
        }
        if (target != null && current instanceof DNodeContainer && target instanceof Pseudostate) {
            currentState = (Pseudostate)target;
            stateAndModeList.add((IState)currentState);
        }
        return stateAndModeList;
    }

    public List<StateTransition> getAvailableTransitionsToInsertInSM(DSemanticDecorator current) {
        State state;
        ArrayList<StateTransition> transitionList = new ArrayList<StateTransition>();
        EObject target = current.getTarget();
        if (current instanceof DDiagram && target instanceof Region) {
            Region defaultRegion = (Region)target;
            for (StateTransition trans : defaultRegion.getOwnedTransitions()) {
                transitionList.add(trans);
            }
        }
        if (current instanceof DNodeContainer && target != null && target instanceof State && (state = (State)target).eContainer() instanceof Region) {
            Region containerRegion = (Region)state.eContainer();
            for (StateTransition trans : containerRegion.getOwnedTransitions()) {
                List<StateTransition> displayedTransitions = this.getDisplayedTransitions(current);
                if (displayedTransitions.contains(trans)) continue;
                transitionList.add(trans);
            }
        }
        return transitionList;
    }

    @Deprecated
    public ContainerMapping getMappingSMStateMode(State state, DDiagram diagram_p) {
        String mappingName = MappingConstantsHelper.getMappingSMStateMode((EObject)state, diagram_p);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram_p, mappingName);
    }

    @Deprecated
    public ContainerMapping getMappingSMInnerStateMode(State state, DDiagram diagram_p) {
        String mappingName = MappingConstantsHelper.getMappingSMInnerStateMode((EObject)state, diagram_p);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram_p, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingSMInnerPseudostate(Pseudostate pseudoState, DDiagram diagram_p) {
        String mappingName = MappingConstantsHelper.getMappingSMInnerPseudostate((EObject)pseudoState, diagram_p);
        return DiagramServices.getDiagramServices().getNodeMapping(diagram_p, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingSMPseudostate(Pseudostate pseudoState, DDiagram diagram_p) {
        String mappingName = MappingConstantsHelper.getMappingSMPseudostate((EObject)pseudoState, diagram_p);
        return DiagramServices.getDiagramServices().getNodeMapping(diagram_p, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingSMTransition(StateTransition function_p, DDiagram diagram_p) {
        String mappingName = MappingConstantsHelper.getMappingSMTransition((EObject)function_p, diagram_p);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram_p, mappingName);
    }

    public EObject showHideStatesInStateAndModeDiag(DSemanticDecorator view, List<State> selectedStates, List<State> visibleStates, List<AbstractDNode> visibleStateViews) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents((DDiagram)diagram);
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        ShowHideSMStateMode shHide = new ShowHideSMStateMode(content);
        AbstractShowHide.DiagramContext diagramContext = new AbstractShowHide.DiagramContext(new ShowHideSMStateMode(content));
        diagramContext.setVariable("CONTEXTUAL_CONTAINER", view.getTarget());
        diagramContext.setVariable("CONTEXTUAL_CONTAINER_VIEW", view);
        for (IState iState : selectedStates) {
            shHide.show((EObject)iState, diagramContext);
        }
        for (AbstractDNode abstractDNode : visibleStateViews) {
            if (selectedStates.contains(abstractDNode.getTarget())) continue;
            toBeRemoved.add(abstractDNode.getTarget());
        }
        for (EObject eObject : toBeRemoved) {
            shHide.hide(eObject, diagramContext);
        }
        return view;
    }

    public EObject showHideSMTransitions(DSemanticDecorator view, List<StateTransition> selectedTransitions, List<StateTransition> visibleTransitions, List<DEdge> visibleTransitionViews) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents((DDiagram)diagram);
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        ShowHideSMTransitions shHide = new ShowHideSMTransitions(content);
        AbstractShowHide.DiagramContext diagramContext = new AbstractShowHide.DiagramContext(shHide);
        diagramContext.setVariable("CONTEXTUAL_CONTAINER", view.getTarget());
        diagramContext.setVariable("CONTEXTUAL_CONTAINER_VIEW", view);
        for (StateTransition trans : selectedTransitions) {
            shHide.show((EObject)trans, diagramContext);
        }
        for (DEdge edge : visibleTransitionViews) {
            if (selectedTransitions.contains(edge.getTarget())) continue;
            toBeRemoved.add(edge.getTarget());
        }
        for (EObject aView : toBeRemoved) {
            shHide.hide(aView, diagramContext);
        }
        return view;
    }

    public List<IState> getStateAncestors(IState state) {
        ArrayList<IState> result = new ArrayList<IState>(0);
        Region currentRegion = (Region)state.eContainer();
        while (currentRegion != null) {
            EObject parent = currentRegion.eContainer();
            if (parent != null && parent instanceof IState) {
                result.add((IState)parent);
                currentRegion = (Region)parent.eContainer();
                continue;
            }
            return result;
        }
        return result;
    }

    public List<AbstractState> getEntryPoints(IState state) {
        return this.getSpecificSubState(state, EntryPointPseudoState.class);
    }

    public List<AbstractState> getExitPoints(IState state) {
        return this.getSpecificSubState(state, ExitPointPseudoState.class);
    }

    private <T> List<AbstractState> getSpecificSubState(IState parent, Class<T> clazz) {
        ArrayList<AbstractState> res = new ArrayList<AbstractState>();
        if (parent != null && parent instanceof State) {
            for (Region region : ((State)parent).getOwnedRegions()) {
                res.addAll(Collections2.filter((Collection)region.getOwnedStates(), (Predicate)Predicates.instanceOf(clazz)));
            }
        }
        return res;
    }

    public boolean isInSameOrSubRegion(IState state, IState subState) {
        Region owningRegion = (Region)state.eContainer();
        TreeIterator it = owningRegion.eAllContents();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            if (!(e instanceof IState) || e != subState) continue;
            return true;
        }
        return false;
    }

    public StateMachine getOwningStateMachine(EObject e) {
        while (e instanceof IState || e instanceof StateTransition || e instanceof Region) {
            if (!((e = e.eContainer()) instanceof StateMachine)) continue;
            StateMachine sm = (StateMachine)e;
            return sm;
        }
        return null;
    }

    public List<StateTransition> getStateMachineTransition(EObject target) {
        ArrayList<StateTransition> list = new ArrayList<StateTransition>();
        StateMachine sm = this.getOwningStateMachine(target);
        TreeIterator it = sm.eAllContents();
        while (it.hasNext()) {
            StateTransition st;
            EObject e = (EObject)it.next();
            if (!(e instanceof StateTransition) || (st = (StateTransition)e).getTarget() != target) continue;
            list.add(st);
        }
        return list;
    }

    public List<StateTransition> getSourcingTransition(EObject source) {
        ArrayList<StateTransition> list = new ArrayList<StateTransition>();
        StateMachine sm = this.getOwningStateMachine(source);
        TreeIterator it = sm.eAllContents();
        while (it.hasNext()) {
            StateTransition st;
            EObject e = (EObject)it.next();
            if (!(e instanceof StateTransition) || (st = (StateTransition)e).getSource() != source) continue;
            list.add(st);
        }
        return list;
    }

    public List<StateTransition> getTargettingTransition(EObject target) {
        ArrayList<StateTransition> list = new ArrayList<StateTransition>();
        StateMachine sm = this.getOwningStateMachine(target);
        TreeIterator it = sm.eAllContents();
        while (it.hasNext()) {
            StateTransition st;
            EObject e = (EObject)it.next();
            if (!(e instanceof StateTransition) || (st = (StateTransition)e).getTarget() != target) continue;
            list.add(st);
        }
        return list;
    }

    public boolean canCreateTransition(EObject context, IState source, IState target) {
        if (target instanceof InitialPseudoState || source instanceof TerminatePseudoState || source instanceof FinalState) {
            return false;
        }
        if (source instanceof InitialPseudoState && (target instanceof TerminatePseudoState || target instanceof FinalState)) {
            return false;
        }
        if (target instanceof ExitPointPseudoState && !this.isInSameOrSubRegion(target, source) || source instanceof EntryPointPseudoState && !this.isInSameOrSubRegion(source, target) || source instanceof JoinPseudoState && this.getSourcingTransition((EObject)source).size() != 0 || target instanceof ForkPseudoState && this.getTargettingTransition((EObject)target).size() != 0) {
            return false;
        }
        return !EcoreUtil.isAncestor((EObject)source, (EObject)target) && !EcoreUtil.isAncestor((EObject)target, (EObject)source);
    }

    public boolean isValidDndSMModeState(EObject semanticToDrop, EObject oldContainer, EObject targetContainerView) {
        Region newRegion;
        return targetContainerView instanceof DSemanticDecorator && semanticToDrop instanceof AbstractState && (newRegion = this.getRegionFromView(targetContainerView)) != null && (StateMachineServices.isReferencedState((IState)((AbstractState)semanticToDrop), oldContainer) || !(semanticToDrop instanceof State) || MoveHelper.getInstance().canMoveModeState((State)semanticToDrop, newRegion));
    }

    public EObject dndSMModeState(EObject semanticObjectToDrop, EObject targetContainerView) {
        if (targetContainerView instanceof DSemanticDecorator && semanticObjectToDrop instanceof AbstractState) {
            AbstractState state = (AbstractState)semanticObjectToDrop;
            EObject target = ((DSemanticDecorator)targetContainerView).getTarget();
            Region targetRegion = null;
            if (target instanceof Region) {
                targetRegion = (Region)target;
            }
            if (target instanceof State) {
                targetRegion = StateExt.getPrimaryRegion((State)((State)target));
            }
            if (targetRegion != null) {
                targetRegion.getOwnedStates().add((Object)state);
            }
        }
        return semanticObjectToDrop;
    }
}

