/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponent;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABComponentExchange
extends ShowHideABComponent {
    public static final String SOURCE_PART_VIEWS = "spv";
    public static final String TARGET_PART_VIEWS = "tpv";

    public ShowHideABComponentExchange(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    protected boolean isValidSemanticView(EObject semantic_p, DSemanticDecorator semanticView_p, AbstractShowHide.DiagramContext context_p) {
        if (semantic_p instanceof Part || semantic_p instanceof Entity) {
            Collection views;
            AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable(SOURCE_PART_VIEWS);
            if (variable != null && (views = (Collection)variable.getValue()).iterator().hasNext() && semantic_p == ((DDiagramElement)views.iterator().next()).getTarget() && !views.contains(semanticView_p)) {
                return false;
            }
            variable = context_p.getLastVariable(TARGET_PART_VIEWS);
            if (variable != null && (views = (Collection)variable.getValue()).iterator().hasNext() && semantic_p == ((DDiagramElement)views.iterator().next()).getTarget() && !views.contains(semanticView_p)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof ComponentExchange) {
            ComponentExchange exchange = (ComponentExchange)lastContext.getValue();
            Port source = ComponentExchangeExt.getSourcePort((ComponentExchange)exchange);
            Port target = ComponentExchangeExt.getTargetPort((ComponentExchange)exchange);
            if (source == null) {
                source = ComponentExchangeExt.getSourcePart((ComponentExchange)exchange);
            }
            if (source == null && exchange instanceof CommunicationMean) {
                source = ComponentExchangeExt.getSourceComponent((ComponentExchange)exchange);
            }
            if (target == null) {
                target = ComponentExchangeExt.getTargetPart((ComponentExchange)exchange);
            }
            if (target == null && exchange instanceof CommunicationMean) {
                target = ComponentExchangeExt.getTargetComponent((ComponentExchange)exchange);
            }
            value.put("source", (EObject)source);
            value.put("target", (EObject)target);
        } else if (lastContext.getValue() instanceof ComponentPort) {
            ComponentPort port = (ComponentPort)lastContext.getValue();
            value.putAll("container", ComponentExt.getRepresentingParts((Component)PortExt.getRelatedComponent((ComponentPort)port)));
        }
        return value;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof ComponentPort) {
            String mappingName = MappingConstantsHelper.getMappingABComponentPort(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        } else if (lastContext.getValue() instanceof ComponentExchange) {
            String mappingName = MappingConstantsHelper.getMappingABConnection(this.getContent().getDDiagram());
            mapping = this.getContent().getMapping(mappingName);
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustShow(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, EdgeMapping edgeMapping_p) {
        if (exchange_p instanceof ComponentExchange) {
            return CsServices.getService().isValidComponentExchangeEdge(exchange_p, source_p, target_p);
        }
        return super.mustShow(source_p, target_p, exchange_p, edgeMapping_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof ComponentPort) {
            return true;
        }
        return semantic instanceof ComponentExchange;
    }
}

