/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponent;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideService;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideMCActors
extends ShowHideABComponent {
    IQueryFilter filter;
    protected IQueryContext qcontext = new QueryContext();

    public ShowHideMCActors(IQueryFilter filter, DDiagramContents content) {
        super(content);
        this.filter = filter;
    }

    @Override
    protected boolean mustHide(DDiagramElement view, AbstractShowHide.DiagramContext context) {
        return true;
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple, AbstractShowHide.DiagramContext context) {
        AbstractShowHide.ContextItemElement item;
        EObject semantic = originCouple.getValue();
        if (semantic != (item = context.getLast("root")).getValue()) {
            return false;
        }
        return this.isConcerned(semantic);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic, AbstractShowHide.DiagramContext context) {
        HashMapSet<String, EObject> related = super.getRelatedObjects(semantic, context);
        for (EObject object : new ArrayList(related.get("container"))) {
            if (!(object instanceof Part)) continue;
            related.remove("container", object);
            related.put("container", (EObject)((Part)object).getAbstractType());
        }
        return related;
    }

    protected boolean isConcerned(EObject object) {
        return this.filter == null || this.filter.keepElement((Object)object, this.qcontext);
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        DiagramElementMapping mapping = super.getMapping(semantic, context, relatedViews);
        if (this.isConcerned(semantic)) {
            DSemanticDecorator containerView;
            mapping = ShowHideService.getService().getMapping(semantic.eClass(), this.getContent().getDDiagram());
            EObject container = context.getLast("container") != null ? context.getLast("container").getValue() : null;
            DSemanticDecorator dSemanticDecorator = containerView = relatedViews.get("container").isEmpty() ? null : (DSemanticDecorator)relatedViews.get("container").iterator().next();
            if (SiriusElementMappingSpecOperations.checkPrecondition((DiagramElementMapping)mapping, (EObject)semantic, (EObject)container, (EObject)containerView)) {
                return mapping;
            }
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic, AbstractShowHide.DiagramContext context, Collection<DSemanticDecorator> targetViews) {
        return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
    }
}

