/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class CommonScenarioHelper {
    private CommonScenarioHelper() {
    }

    public static AbstractEventOperation getOperation(EObject element, ITransfo transfo) {
        AbstractEventOperation operation = null;
        if (element instanceof SequenceMessage) {
            operation = ((SequenceMessage)element).getInvokedOperation();
        }
        if (element instanceof EventSentOperation) {
            operation = ((EventSentOperation)element).getOperation();
        }
        if (element instanceof EventReceiptOperation) {
            operation = ((EventReceiptOperation)element).getOperation();
        }
        if (element instanceof AbstractEnd) {
            return CommonScenarioHelper.getOperation((EObject)((AbstractEnd)element).getEvent(), transfo);
        }
        return operation;
    }

    public static InstanceRole getOppositeCoveredIR(AbstractEnd end) {
        MessageEnd messageEnd = null;
        if (end instanceof ExecutionEnd) {
            messageEnd = (MessageEnd)((ExecutionEnd)end).getExecution().getStart();
        } else if (end instanceof MessageEnd) {
            messageEnd = (MessageEnd)end;
        }
        if (messageEnd != null) {
            MessageEnd opposite;
            MessageEnd messageEnd2 = opposite = messageEnd.getMessage().getSendingEnd() == messageEnd ? messageEnd.getMessage().getReceivingEnd() : messageEnd.getMessage().getSendingEnd();
            if (opposite != null) {
                return opposite.getCovered();
            }
        }
        return null;
    }

    public static InstanceRole getOppositeCoveredIR(ExecutionEnd executionEnd_p) {
        MessageEnd me = (MessageEnd)executionEnd_p.getExecution().getStart();
        return CommonScenarioHelper.getOppositeCoveredIR((AbstractEnd)me);
    }

    public static InstanceRole getOppositeCoveredIR(Execution exec) {
        return CommonScenarioHelper.getOppositeCoveredIR((AbstractEnd)((MessageEnd)exec.getStart()));
    }

    public static String getTitle(ITransfo transfo) {
        Object source = transfo.get((Object)"transfoSource");
        if (source instanceof EObject) {
            return NLS.bind((String)Messages.Rule_InstanceRole_TransitionTitleDetailled, (Object)EObjectLabelProviderHelper.getText((EObject)((EObject)source)));
        }
        return Messages.Rule_InstanceRole_TransitionTitle;
    }

    public static List<ExchangeItem> getExchangeItems(AbstractEventOperation operation) {
        ExchangeItemAllocation allocation;
        ArrayList<ExchangeItem> result = new ArrayList<ExchangeItem>();
        if (operation instanceof ExchangeItem) {
            result.add((ExchangeItem)operation);
        }
        if (operation instanceof ExchangeItemAllocation && (allocation = (ExchangeItemAllocation)operation).getAllocatedItem() != null && allocation.getAllocatedItem() instanceof ExchangeItem) {
            result.add(allocation.getAllocatedItem());
        }
        if (operation instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)operation;
            result.addAll((Collection<ExchangeItem>)fe.getExchangedItems());
        } else if (operation instanceof ComponentExchange) {
            ComponentExchange connection = (ComponentExchange)operation;
            for (AbstractExchangeItem item : connection.getConvoyedInformations()) {
                if (!(item instanceof ExchangeItem)) continue;
                result.add((ExchangeItem)item);
            }
        }
        return result;
    }

    public static void attachToBestAndValidElements(EObject element, EReference reference, Collection<EObject> objects, ITransfo transfo) {
        if (element == null || !TigerRelationshipHelper.isApplicable((EClass)element.eClass(), (EStructuralFeature)reference)) {
            return;
        }
        for (EObject targetElement : Query.retrieveTransformedElements((EObject)element, (ITransfo)transfo)) {
            if (!TigerRelationshipHelper.isApplicable((EClass)targetElement.eClass(), (EStructuralFeature)reference)) continue;
            Object resultTarget = targetElement.eGet((EStructuralFeature)reference);
            for (EObject sourceElement : TigerRelationshipHelper.retrieveReferenceAsList((EObject)element, (EReference)reference)) {
                for (EObject bestElement : TigerRelationshipHelper.retrieveBestElements((EObject)targetElement, (EObject)sourceElement, (EClass)((EClass)reference.getEType()), (ITransfo)transfo)) {
                    if (!objects.contains(bestElement) || !reference.isMany() && resultTarget != null && !resultTarget.equals(sourceElement) && !resultTarget.equals(bestElement)) continue;
                    if (bestElement != sourceElement) {
                        TigerRelationshipHelper.detachElementByRel((EObject)targetElement, (EObject)sourceElement, (EReference)reference);
                    }
                    TigerRelationshipHelper.attachElementByRel((EObject)targetElement, (EObject)bestElement, (EReference)reference);
                }
            }
        }
    }
}

